/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jmx;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.admin.ContainerConfig;
import com.j_spaces.core.admin.IJSpaceContainerAdmin;
import com.j_spaces.jmx.XMLDescriptorsMBean;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

@InternalApi
public class JMXSpaceContainer
extends XMLDescriptorsMBean
implements MBeanRegistration {
    private IJSpaceContainer m_container;
    private ContainerConfig m_containerConfig;
    private MBeanServer m_mbeanServer;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.jmx");

    public JMXSpaceContainer(IJSpaceContainer container, String xmlDescriptorsFileURL) throws Exception {
        super(xmlDescriptorsFileURL);
        this.m_container = container;
        this.m_containerConfig = ((IJSpaceContainerAdmin)((Object)container)).getConfig();
    }

    public JMXSpaceContainer() {
    }

    @Override
    protected void __setConfig(Object config) {
        this.m_containerConfig = (ContainerConfig)config;
    }

    @Override
    protected Object __getConfig() {
        return this.m_containerConfig;
    }

    private void updateConfig() throws RemoteException {
        ((IJSpaceContainerAdmin)((Object)this.m_container)).setConfig(this.m_containerConfig);
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList result;
        block2: {
            result = super.setAttributes(attributes);
            try {
                this.updateConfig();
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.WARNING)) break block2;
                _logger.log(Level.WARNING, ex.toString(), ex);
            }
        }
        return result;
    }

    public IJSpaceContainer getContainer() {
        return this.m_container;
    }

    public void shutdown() throws RemoteException {
        this.m_container.shutdown();
    }

    public String[] getSpaceNames() throws RemoteException {
        return this.m_container.getSpaceNames();
    }

    public String getRuntimeConfigReport() throws RemoteException {
        return ((IJSpaceContainerAdmin)((Object)this.m_container)).getRuntimeConfigReport();
    }

    public Boolean isJndiRegistration() {
        return this.m_containerConfig.isJndiEnabled();
    }

    public void setJndiRegistration(Boolean b) {
        this.m_containerConfig.setJndiEnabled(b);
    }

    public Boolean isJiniRegistration() {
        return this.m_containerConfig.isJiniLusEnabled();
    }

    public void setJiniRegistration(Boolean b) {
        this.m_containerConfig.setJiniLusEnabled(b);
    }

    public String getSchemaName() {
        return this.m_containerConfig.getSchemaName();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        super.setAttribute(attribute);
        try {
            this.updateConfig();
        }
        catch (RemoteException e) {
            throw new MBeanException(e);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer mbs, ObjectName objName) throws Exception {
        this.m_mbeanServer = mbs;
        return objName;
    }

    @Override
    public void postRegister(Boolean arg0) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }
}

