/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jmx;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.j_spaces.core.IGSEntry;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.TemplateInfo;
import java.util.Map;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;

@InternalApi
public class TemplateImpl
implements IGSEntry {
    private static final long serialVersionUID = -6239273862115667186L;
    private ITypeDesc _typeDesc;
    private TemplateInfo _template;

    public TemplateImpl() {
    }

    public TemplateImpl(TemplateInfo template, ITypeDesc typeDesc) {
        this._typeDesc = typeDesc;
        this._template = template;
    }

    @Override
    public String getClassName() {
        return this._typeDesc.getTypeName();
    }

    @Override
    public String getCodebase() {
        return this._typeDesc.getCodeBase();
    }

    @Override
    public String[] getSuperClassesNames() {
        return this._typeDesc.getRestrictSuperClassesNames();
    }

    @Override
    public String[] getFieldsNames() {
        return this._typeDesc.getPropertiesNames();
    }

    @Override
    public String[] getFieldsTypes() {
        return this._typeDesc.getPropertiesTypes();
    }

    @Override
    public boolean[] getIndexIndicators() {
        return this._typeDesc.getPropertiesIndexTypes();
    }

    @Override
    public String getRoutingFieldName() {
        return this._typeDesc.getRoutingPropertyName();
    }

    @Override
    public String getPrimaryKeyName() {
        boolean[] indexIndicators = this.getIndexIndicators();
        if (indexIndicators != null) {
            for (int i = 0; i < indexIndicators.length; ++i) {
                if (!indexIndicators[i]) continue;
                return this.getFieldsNames()[i];
            }
        }
        return null;
    }

    @Override
    public String getFieldType(String fieldName) {
        try {
            return this._typeDesc.getFixedProperty(fieldName).getTypeName();
        }
        catch (Exception e) {
            throw new IllegalStateException("The field types array was not properly set", e);
        }
    }

    @Override
    public boolean isIndexedField(String fieldName) {
        try {
            return this._typeDesc.getIndexType(fieldName).isIndexed();
        }
        catch (Exception e) {
            throw new IllegalStateException("The field indexes array was not properly set", e);
        }
    }

    @Override
    public boolean isReplicatable() {
        return this._typeDesc.isReplicable();
    }

    @Override
    public Object getFieldValue(String fieldName) throws IllegalArgumentException, IllegalStateException {
        return this.getFieldValue(this.getFieldPosition(fieldName));
    }

    @Override
    public Object getFieldValue(int position) throws IllegalArgumentException, IllegalStateException {
        return this.getFieldsValues()[position];
    }

    @Override
    public int getFieldPosition(String fieldName) {
        for (int i = 0; i < this._typeDesc.getNumOfFixedProperties(); ++i) {
            if (!this._typeDesc.getFixedProperty(i).getName().equals(fieldName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Field name " + fieldName + " is not available");
    }

    @Deprecated
    public Entry getEntry(IJSpace space) throws UnusableEntryException {
        return null;
    }

    @Override
    public Object[] getFieldsValues() {
        return this._template.getValues();
    }

    @Override
    public Map.Entry getMapEntry() {
        return null;
    }

    @Override
    public Object getObject(IJSpace space) throws UnusableEntryException {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return this._template.getExpiresAt().getTime();
    }

    @Override
    public String getUID() {
        return null;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public boolean isFifo() {
        return this._template.isFIFO();
    }

    @Override
    public Object setFieldValue(String fieldName, Object value) throws IllegalArgumentException, IllegalStateException {
        return null;
    }

    @Override
    public Object setFieldValue(int position, Object value) throws IllegalArgumentException, IllegalStateException {
        return null;
    }

    @Override
    public boolean isTransient() {
        return true;
    }
}

