/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jmx;

import com.j_spaces.jmx.AbstractDynamicMBean;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLDescriptorsMBean
extends AbstractDynamicMBean {
    private static final String ATTRIBUTE_TAG = "attribute";
    private static final String OPERATION_TAG = "operation";
    private static final String CONSTRUCTOR_TAG = "constructor";
    private static final String NOTIFIER_TAG = "notifier";
    private static final String PARAMETER_TAG = "parameter";
    private static final String TYPES_TAG = "types";
    private static final String NAME_ATTR = "name";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String TYPE_ATTR = "type";
    private static final String IS_READABLE_ATTR = "isReadable";
    private static final String IS_WRITABLE_ATTR = "isWritable";
    private static final String IS_IS_ATTR = "isIs";
    private static final String IMPACT_ARRT = "impact";
    private String m_type;
    static final String VALID_SCHEMA_FILE = "/MBeanXMLDescriptors.xsd";
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";

    protected XMLDescriptorsMBean(String xmlFileURL) throws Exception {
        this.init(xmlFileURL);
    }

    protected XMLDescriptorsMBean() {
    }

    private void init(String xmlFileURL) throws Exception {
        Map attrMap;
        Element element;
        int i;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document rootDoc = builder.parse(xmlFileURL);
        Element rootElem = rootDoc.getDocumentElement();
        this.m_type = rootElem.getAttribute(TYPE_ATTR);
        this.setMBeanDescription(rootElem.getAttribute(DESCRIPTION_ATTR));
        NodeList elementsList = rootElem.getElementsByTagName(ATTRIBUTE_TAG);
        for (i = 0; i < elementsList.getLength(); ++i) {
            element = (Element)elementsList.item(i);
            attrMap = this.getXmlAttributesFromNode(element);
            String descrPrefix = attrMap.get(NAME_ATTR) + ": ";
            this.addMBeanAttributeInfo(new MBeanAttributeInfo((String)attrMap.get(NAME_ATTR), (String)attrMap.get(TYPE_ATTR), descrPrefix + attrMap.get(DESCRIPTION_ATTR), Boolean.valueOf((String)attrMap.get(IS_READABLE_ATTR)), Boolean.valueOf((String)attrMap.get(IS_WRITABLE_ATTR)), Boolean.valueOf((String)attrMap.get(IS_IS_ATTR))));
        }
        elementsList = rootElem.getElementsByTagName(OPERATION_TAG);
        for (i = 0; i < elementsList.getLength(); ++i) {
            element = (Element)elementsList.item(i);
            attrMap = this.getXmlAttributesFromNode(element);
            this.addMBeanOperationInfo(new MBeanOperationInfo((String)attrMap.get(NAME_ATTR), (String)attrMap.get(DESCRIPTION_ATTR), this.getSignature(element.getElementsByTagName(PARAMETER_TAG)), (String)attrMap.get(TYPE_ATTR), this.convertImpact((String)attrMap.get(IMPACT_ARRT))));
        }
        elementsList = rootElem.getElementsByTagName(CONSTRUCTOR_TAG);
        for (i = 0; i < elementsList.getLength(); ++i) {
            element = (Element)elementsList.item(i);
            attrMap = this.getXmlAttributesFromNode(element);
            this.addMBeanConstructorInfo(new MBeanConstructorInfo((String)attrMap.get(NAME_ATTR), (String)attrMap.get(DESCRIPTION_ATTR), this.getSignature(element.getElementsByTagName(PARAMETER_TAG))));
        }
        elementsList = rootElem.getElementsByTagName(NOTIFIER_TAG);
        for (i = 0; i < elementsList.getLength(); ++i) {
            element = (Element)elementsList.item(i);
            attrMap = this.getXmlAttributesFromNode(element);
            String types = this.getNodeValueIfExists(element, TYPES_TAG);
            String[] notifTypes = null;
            if (types != null && types.trim().length() > 0) {
                StringTokenizer st = new StringTokenizer(types.trim());
                notifTypes = new String[st.countTokens()];
                for (int j = 0; j < st.countTokens(); ++j) {
                    notifTypes[j] = st.nextToken();
                }
            }
            this.addMBeanNotificationInfo(new MBeanNotificationInfo(notifTypes, (String)attrMap.get(NAME_ATTR), (String)attrMap.get(DESCRIPTION_ATTR)));
        }
    }

    private MBeanParameterInfo[] getSignature(NodeList paramList) {
        MBeanParameterInfo[] signature = null;
        if (paramList != null && paramList.getLength() > 0) {
            signature = new MBeanParameterInfo[paramList.getLength()];
            for (int j = 0; j < paramList.getLength(); ++j) {
                Element paramElem = (Element)paramList.item(j);
                Map paramAttr = this.getXmlAttributesFromNode(paramElem);
                signature[j] = new MBeanParameterInfo((String)paramAttr.get(NAME_ATTR), (String)paramAttr.get(TYPE_ATTR), (String)paramAttr.get(DESCRIPTION_ATTR));
            }
        }
        return signature;
    }

    private Map getXmlAttributesFromNode(Element element) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        NamedNodeMap attrMap = element.getAttributes();
        for (int j = 0; j < attrMap.getLength(); ++j) {
            Node node = attrMap.item(j);
            String nodeName = node.getNodeName();
            String nodeValue = node.getNodeValue();
            result.put(nodeName, nodeValue);
        }
        return result;
    }

    private String getNodeValueIfExists(Element parentNode, String nodeName) {
        Node child;
        String value = null;
        NodeList nl = parentNode.getElementsByTagName(nodeName);
        if (nl.getLength() > 0 && (child = nl.item(0).getFirstChild()) != null) {
            value = child.getNodeValue().trim();
        }
        return value;
    }

    private int convertImpact(String value) throws InvalidAttributeValueException {
        if (value.equals("ACTION")) {
            return 1;
        }
        if (value.equals("ACTION_INFO")) {
            return 2;
        }
        if (value.equals("INFO")) {
            return 0;
        }
        if (value.equals("UNKNOWN")) {
            return 3;
        }
        throw new InvalidAttributeValueException("The value of <operation> impact attribute, should be ACTION, ACTION_INFO, INFO or UNKNOWN");
    }

    @Override
    public String getType() {
        if (this.m_type == null || this.m_type.trim().length() <= 0) {
            this.m_type = this.getClass().getName();
        }
        return this.m_type;
    }
}

