/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jmx.util;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class JConsoleUtilities {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.common");
    private static final String JCONSOLE_PLUGIN_TOPTHREADS_FILE_PATH = SystemInfo.singleton().locations().lib() + File.separator + "platform" + File.separator + "ui" + File.separator + "topthreads-1.0.0.jar";

    public static String[] createJConsoleCommand(String jmxServiceUrl, String javaHomeDir, boolean usePlugin, boolean useParameters) {
        ArrayList<String> commandArray = new ArrayList<String>(5);
        if (javaHomeDir == null) {
            javaHomeDir = JConsoleUtilities.calculateJConsoleCommandJavaHome();
        }
        if (javaHomeDir != null) {
            commandArray.add(javaHomeDir + File.separator + "bin" + File.separator + "jconsole");
        } else {
            commandArray.add("jconsole");
        }
        if (useParameters) {
            block17: {
                String property = System.getProperty("com.gs.jconsole.interval");
                if (property != null) {
                    try {
                        int interval = Integer.parseInt(property);
                        commandArray.add("-interval=" + interval);
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Passed by system property [com.gs.jconsole.interval] jconsole interval parameter:" + interval);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block17;
                        _logger.severe("jconsole interval parameter passed by system property [com.gs.jconsole.interval] is not a number, jconsole will be run with its default interval parameter");
                    }
                }
            }
            if (usePlugin) {
                if (new File(JCONSOLE_PLUGIN_TOPTHREADS_FILE_PATH).exists()) {
                    commandArray.add("-pluginpath");
                    commandArray.add(JCONSOLE_PLUGIN_TOPTHREADS_FILE_PATH);
                    if (jmxServiceUrl != null) {
                        commandArray.add(jmxServiceUrl);
                    }
                } else if (javaHomeDir != null) {
                    commandArray.add("-pluginpath");
                    commandArray.add(javaHomeDir + File.separator + "demo" + File.separator + "management" + File.separator + "JTop" + File.separator + "JTop.jar");
                    if (jmxServiceUrl != null) {
                        commandArray.add(jmxServiceUrl);
                    }
                }
            } else if (jmxServiceUrl != null) {
                commandArray.add(jmxServiceUrl);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "all jconsole parameters:" + commandArray);
        }
        return commandArray.toArray(new String[commandArray.size()]);
    }

    public static String[] createJVisualVmCommand(String jmxServiceUrl, String javaHomeDir, File visualVmFileLaunchFilePath) {
        ArrayList<String> commandArray = new ArrayList<String>(5);
        if (visualVmFileLaunchFilePath != null && visualVmFileLaunchFilePath.exists()) {
            commandArray.add(visualVmFileLaunchFilePath.getPath());
        } else {
            if (javaHomeDir == null) {
                javaHomeDir = JConsoleUtilities.calculateJVisualVmCommandJavaHome();
            }
            if (javaHomeDir != null) {
                commandArray.add(javaHomeDir + File.separator + "bin" + File.separator + "jvisualvm");
            } else {
                commandArray.add("jvisualvm");
            }
        }
        commandArray.add("--openjmx");
        commandArray.add(jmxServiceUrl);
        commandArray.add("--nosplash");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "all jvisualvm parameters:" + commandArray);
        }
        return commandArray.toArray(new String[commandArray.size()]);
    }

    private static String calculateJConsoleCommandJavaHome() {
        return JConsoleUtilities.calculateAppJavaHome("jconsole");
    }

    private static String calculateJVisualVmCommandJavaHome() {
        return JConsoleUtilities.calculateAppJavaHome("jvisualvm");
    }

    private static String calculateAppJavaHome(String appName) {
        String opSys = System.getProperty("os.name");
        String ext = opSys.startsWith("Win") ? ".exe" : "";
        String javaHome = System.getProperty("java.home");
        String applPath = javaHome + File.separator + "bin" + File.separator + appName + ext;
        File applFile = new File(applPath);
        if (!applFile.exists()) {
            File javaHomeDir = new File(javaHome);
            javaHome = javaHomeDir.getParent();
            applPath = javaHome + File.separator + "bin" + File.separator + appName + ext;
            applFile = new File(applPath);
        }
        if (applFile.exists()) {
            return javaHome;
        }
        return null;
    }
}

