/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.gigaspaces.internal.utils.threadlocal.ThreadLocalPool;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import com.j_spaces.kernel.StoredListIterator;
import com.j_spaces.kernel.list.IterableStoredListIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractStoredList<T>
implements IStoredList<T>,
Iterable<T> {
    protected static final int SCAN_LIMIT = 100000;
    protected static final int NUMBER_OF_OCCUPIED_POS_QUOTA = 1000;
    protected static final int MINIMAL_NUMBER_TO_HANDLE_POSITIONS = 2;
    private static final ThreadLocalPool<StoredListIterator> _SLHolderPool = new ThreadLocalPool<StoredListIterator>(new StoredListIterator.StoredListIteratorFactory());
    protected ArrayList<ObjectInfo<T>> m_BasicOccupied;
    protected ArrayList<ArrayList<ObjectInfo<T>>> m_AllOccupiedPos;
    protected int m_Size;
    protected boolean m_Support_Random_Scans;
    protected int m_LastChunk;
    protected int m_LastPos;
    protected ObjectInfo<T> m_Tail;
    protected ObjectInfo<T> m_Head;

    protected AbstractStoredList(boolean Support_Random_Scans) {
        this.m_Support_Random_Scans = Support_Random_Scans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(Logger logger, String msg) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(msg);
            IStoredListIterator<T> slh = null;
            try {
                slh = this.establishListScan(false);
                while (slh != null) {
                    Object subject = slh.getSubject();
                    if (subject != null) {
                        logger.info(subject.getClass().getName());
                    }
                    slh = this.next(slh);
                }
            }
            finally {
                if (slh != null) {
                    slh.release();
                }
            }
        }
    }

    @Override
    public StoredListIterator<T> establishListScan(boolean random_scan) {
        if (this.isEmpty()) {
            return null;
        }
        StoredListIterator slh = _SLHolderPool.get();
        if (!this.iterate(random_scan, slh)) {
            slh.release();
            return null;
        }
        return slh;
    }

    protected abstract boolean iterate(boolean var1, StoredListIterator<T> var2);

    @Override
    public IStoredListIterator<T> next(IStoredListIterator<T> slh) {
        if (!this.nextPos((StoredListIterator)slh)) {
            slh.release();
            return null;
        }
        return slh;
    }

    public abstract boolean nextPos(StoredListIterator<T> var1);

    @Override
    public void freeSLHolder(IStoredListIterator<T> slh) {
        if (slh != null) {
            slh.release();
        }
    }

    protected boolean removeByObject_impl(Object obj) {
        ObjectInfo<T> oi;
        for (oi = this.m_Tail; !(oi == null || oi.getSubject() != null && oi.getSubject().equals(obj)); oi = oi.getForwardRef()) {
        }
        if (oi == null) {
            return false;
        }
        this.remove(oi);
        return true;
    }

    protected boolean contains_impl(T obj) {
        for (ObjectInfo<T> oi = this.m_Tail; oi != null; oi = oi.getForwardRef()) {
            if (oi.getSubject() == null || !oi.getSubject().equals(obj)) continue;
            return true;
        }
        return false;
    }

    protected void remove_impl(ObjectInfo<T> oiToRemove) {
        if (oiToRemove.getPosInList() == -1) {
            throw new RuntimeException(" Stored list- called remove but element already deleted !");
        }
        if (this.m_Size == 0) {
            throw new RuntimeException(" Stored list- called remove but list is empty !");
        }
        oiToRemove.setSubject(null);
        if (oiToRemove.getBackwardsRef() != null) {
            oiToRemove.getBackwardsRef().setForwardRef(oiToRemove.getForwardRef());
        }
        if (oiToRemove.getForwardRef() != null) {
            oiToRemove.getForwardRef().setBackwardsRef(oiToRemove.getBackwardsRef());
        }
        if (this.m_Tail == oiToRemove) {
            this.m_Tail = oiToRemove.getForwardRef();
        }
        if (this.m_Head == oiToRemove) {
            this.m_Head = oiToRemove.getBackwardsRef();
        }
        --this.m_Size;
        if (this.m_Support_Random_Scans && this.m_BasicOccupied != null) {
            ArrayList<ObjectInfo<T>> my_al;
            ArrayList<ObjectInfo<T>> last_al = this.m_LastChunk > 0 ? this.m_AllOccupiedPos.get(this.m_LastChunk) : this.m_BasicOccupied;
            int my_chunknum = (oiToRemove.getPosInList() - 1) / 1000;
            int my_pos_inside = (oiToRemove.getPosInList() - 1) % 1000;
            ArrayList<ObjectInfo<T>> arrayList = my_al = my_chunknum > 0 ? this.m_AllOccupiedPos.get(my_chunknum) : this.m_BasicOccupied;
            if (this.m_Size > 0 && (my_chunknum != this.m_LastChunk || my_pos_inside != this.m_LastPos)) {
                ObjectInfo<T> soi = last_al.get(this.m_LastPos);
                soi.setPosInList(oiToRemove.getPosInList());
                my_al.set(my_pos_inside, soi);
            }
            last_al.remove(this.m_LastPos);
            if (this.m_LastPos == 0 && this.m_LastChunk > 0) {
                this.m_AllOccupiedPos.remove(this.m_LastChunk);
            }
            --this.m_LastPos;
            if (this.m_LastPos < 0) {
                if (this.m_LastChunk > 0) {
                    --this.m_LastChunk;
                    this.m_LastPos = 999;
                    if (this.m_LastChunk == 0) {
                        this.m_AllOccupiedPos = null;
                    }
                } else {
                    this.m_LastPos = 0;
                }
            }
        }
        oiToRemove.setPosInList(-1);
    }

    protected abstract boolean isInvalid();

    protected ObjectInfo<T> store_impl(T subject) {
        if (this.isInvalid()) {
            return null;
        }
        ++this.m_Size;
        ObjectInfo<T> oi = null;
        if (this.m_Support_Random_Scans && this.m_BasicOccupied == null && this.m_Size >= 2) {
            this.m_BasicOccupied = new ArrayList();
            int indx = 1;
            for (oi = this.m_Tail; oi != null; oi = oi.getForwardRef()) {
                this.m_BasicOccupied.add(oi);
                this.m_LastPos = indx - 1;
                oi.setPosInList(indx++);
            }
        }
        oi = new ObjectInfo<T>(subject);
        if (this.m_Tail != null) {
            oi.setForwardRef(this.m_Tail);
            this.m_Tail.setBackwardsRef(oi);
        }
        this.m_Tail = oi;
        if (this.m_Head == null) {
            this.m_Head = oi;
        }
        if (this.m_Support_Random_Scans && this.m_BasicOccupied != null) {
            ArrayList<ObjectInfo<T>> spos = null;
            int n = this.m_LastPos = this.m_Size > 1 ? this.m_LastPos + 1 : 0;
            if (this.m_LastPos >= 1000) {
                this.m_LastPos = 0;
                ++this.m_LastChunk;
                if (this.m_AllOccupiedPos == null) {
                    this.m_AllOccupiedPos = new ArrayList();
                    this.m_AllOccupiedPos.add(this.m_BasicOccupied);
                }
                this.m_AllOccupiedPos.add(new ArrayList());
            }
            spos = this.m_LastChunk == 0 ? this.m_BasicOccupied : this.m_AllOccupiedPos.get(this.m_LastChunk);
            spos.add(oi);
            oi.setPosInList(this.m_Size);
        }
        return oi;
    }

    protected ObjectInfo<T> storeBeforeCeiling_impl(ObjectInfo<T> theCeiling, T subject) {
        if (this.m_Support_Random_Scans) {
            throw new RuntimeException("storeBeforeCeiling and Support_Random_Scans!");
        }
        ObjectInfo<T> oi = new ObjectInfo<T>(subject);
        ObjectInfo<T> ceiling = theCeiling;
        if (ceiling == null) {
            if (this.m_Size == 0) {
                return (ObjectInfo)this.add(subject);
            }
            this.m_Head.setForwardRef(oi);
            oi.setBackwardsRef(this.m_Head);
            this.m_Head = oi;
        } else {
            if (ceiling.getPosInList() == -1) {
                throw new RuntimeException("storeBeforeCeiling and ceiling deleted!");
            }
            oi.setBackwardsRef(ceiling.getBackwardsRef());
            ceiling.setBackwardsRef(oi);
            oi.setForwardRef(ceiling);
            if (oi.getBackwardsRef() != null) {
                oi.getBackwardsRef().setForwardRef(oi);
            }
            if (this.m_Tail == ceiling) {
                this.m_Tail = oi;
            }
        }
        ++this.m_Size;
        return oi;
    }

    @Override
    public boolean isMultiObjectCollection() {
        return true;
    }

    public Iterator<T> iterator(boolean randomScan) {
        return new IterableStoredListIterator(this, randomScan);
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(false);
    }

    @Override
    public boolean isIterator() {
        return false;
    }

    static class ObjectInfo<T>
    implements Serializable,
    IObjectInfo<T> {
        private static final long serialVersionUID = -4410731885256582304L;
        private ObjectInfo<T> _backwrd;
        private ObjectInfo<T> _fwrd;
        private int _pos;
        private T _subject;

        public ObjectInfo(T subject) {
            this.setSubject(subject);
        }

        @Override
        public void setSubject(T subject) {
            this._subject = subject;
        }

        @Override
        public T getSubject() {
            return this._subject;
        }

        public void setBackwardsRef(ObjectInfo<T> backwrd) {
            this._backwrd = backwrd;
        }

        protected ObjectInfo<T> getBackwardsRef() {
            return this._backwrd;
        }

        public void setForwardRef(ObjectInfo<T> fwrd) {
            this._fwrd = fwrd;
        }

        public ObjectInfo<T> getForwardRef() {
            return this._fwrd;
        }

        public void setPosInList(int pos) {
            this._pos = pos;
        }

        public int getPosInList() {
            return this._pos;
        }
    }
}

