/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class ClassHelper {
    private static final Class[][] TYPES = new Class[][]{{Boolean.class, Boolean.TYPE}, {Byte.class, Byte.TYPE}, {Short.class, Short.TYPE}, {Character.class, Character.TYPE}, {Integer.class, Integer.TYPE}, {Long.class, Long.TYPE}, {Float.class, Float.TYPE}, {Double.class, Double.TYPE}};

    private ClassHelper() {
    }

    public static Method getMethod(Class type, String name, Object[] args) throws NoSuchMethodException {
        Method method;
        Class[] types;
        block19: {
            boolean containsNull = false;
            types = null;
            if (args == null) {
                types = new Class[]{};
            } else {
                types = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] != null) {
                        types[i] = args[i].getClass();
                        continue;
                    }
                    containsNull = true;
                }
            }
            method = null;
            if (!containsNull) {
                try {
                    method = type.getMethod(name, types);
                }
                catch (NoSuchMethodException ignore) {
                    if (types.length == 0) break block19;
                    Class[] converted = new Class[types.length];
                    if (args != null) {
                        for (int i = 0; i < args.length; ++i) {
                            converted[i] = ClassHelper.getPrimitiveType(args[i].getClass());
                        }
                    }
                    try {
                        method = type.getMethod(name, types);
                    }
                    catch (NoSuchMethodException i) {
                        // empty catch block
                    }
                }
            }
        }
        if (method == null) {
            int i;
            Method[] methods = type.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                if (!Modifier.isPublic(methods[i].getModifiers()) || !methods[i].getName().equals(name) || !ClassHelper.checkParameters(methods[i], types)) continue;
                method = methods[i];
                break;
            }
            if (method == null) {
                methods = type.getMethods();
                for (i = 0; i < methods.length; ++i) {
                    if (!methods[i].getName().equals(name) || !ClassHelper.checkParameters(methods[i], types)) continue;
                    method = methods[i];
                    break;
                }
            }
            if (method == null) {
                String msg = "No method found for name=" + name + ", argument types=(";
                if (args != null && args.length > 0) {
                    for (int i2 = 0; i2 < args.length; ++i2) {
                        if (i2 > 0) {
                            msg = msg + ", ";
                        }
                        msg = args[i2] != null ? msg + args[i2].getClass().getName() : msg + "Object";
                    }
                }
                msg = msg + ")";
                throw new NoSuchMethodException(msg);
            }
        }
        return method;
    }

    public static Class getPrimitiveType(Class wrapper) {
        Class result = null;
        for (int i = 0; i < TYPES.length; ++i) {
            if (!wrapper.equals(TYPES[i][0])) continue;
            result = TYPES[i][1];
            break;
        }
        return result != null ? result : wrapper;
    }

    public static String getPrimitiveName(Class wrapper) {
        String result = null;
        Class type = ClassHelper.getPrimitiveType(wrapper);
        result = type.isArray() ? type.getComponentType().getName() + "[]" : type.getName();
        return result;
    }

    private static boolean checkParameters(Method method, Class[] types) {
        boolean result = true;
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length != types.length) {
            result = false;
        } else {
            for (int i = 0; i < parameters.length; ++i) {
                Class<?> parameter = parameters[i];
                if (types[i] == null) {
                    if (!parameter.isPrimitive()) continue;
                    result = false;
                    break;
                }
                if (parameter.isAssignableFrom(types[i]) || parameter.isAssignableFrom(ClassHelper.getPrimitiveType(types[i]))) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

