/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.lrmi.classloading.LRMIClassLoadersHolder;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.threadpool.FastContextClassLoaderThread;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.boot.LoggableClassLoader;

@InternalApi
public class ClassLoaderHelper {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.kernel");
    private static final Map<String, Class<?>> _primitiveTypes = ClassLoaderHelper.loadPrimitiveTypes();
    private static final Field _directContextClassLoaderThreadField = ClassLoaderHelper.getContextThreadCLField();
    private static final String NULL_CL_LOGNAME = "null";

    private static final Field getContextThreadCLField() {
        Field threadCLField;
        block2: {
            threadCLField = null;
            try {
                Thread currThread = Thread.currentThread();
                threadCLField = Thread.class.getDeclaredField("contextClassLoader");
                threadCLField.setAccessible(true);
                ClassLoader cl = (ClassLoader)threadCLField.get(currThread);
                threadCLField.set(currThread, cl);
            }
            catch (Throwable th) {
                if (!_logger.isLoggable(Level.FINEST)) break block2;
                _logger.log(Level.FINEST, "Failed to get access to 'contextClassLoader' field.", th);
            }
        }
        return threadCLField;
    }

    private static Map<String, Class<?>> loadPrimitiveTypes() {
        HashMap types = new HashMap();
        types.put(Byte.TYPE.getName(), Byte.TYPE);
        types.put(Short.TYPE.getName(), Short.TYPE);
        types.put(Integer.TYPE.getName(), Integer.TYPE);
        types.put(Long.TYPE.getName(), Long.TYPE);
        types.put(Float.TYPE.getName(), Float.TYPE);
        types.put(Double.TYPE.getName(), Double.TYPE);
        types.put(Boolean.TYPE.getName(), Boolean.TYPE);
        types.put(Character.TYPE.getName(), Character.TYPE);
        return types;
    }

    public static <T> T newInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class cls = ClassLoaderHelper.loadClass(className);
        Object instance = cls.newInstance();
        return instance;
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return ClassLoaderHelper.loadClass(className, false);
    }

    public static Class loadLocalClass(String className) throws ClassNotFoundException {
        return ClassLoaderHelper.loadClass(className, true);
    }

    public static Class loadClass(String className, boolean localOnly) throws ClassNotFoundException {
        Class<?> primitiveType = _primitiveTypes.get(className);
        if (primitiveType != null) {
            return primitiveType;
        }
        ClassLoader loader = ClassLoaderHelper.getContextClassLoader();
        if (loader == null) {
            loader = ClassLoaderHelper.class.getClassLoader();
        }
        try {
            Class<?> loadClass = Class.forName(className, true, loader);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Load class: [" + className + "] Thread: [" + Thread.currentThread().getName() + "] using ClassLoader: [" + loader + "]\n" + JSpaceUtilities.getStackTrace(new Exception("Debugging stack trace: ")));
            } else if (_logger.isLoggable(Level.FINE)) {
                StringBuilder classLoaderHierarchy = new StringBuilder("ClassLoader Hierarchy: ");
                for (ClassLoader classLoaders = loader; classLoaders != null; classLoaders = classLoaders.getParent()) {
                    classLoaderHierarchy.append(classLoaders.getClass().toString()).append(" <-- ");
                }
                _logger.log(Level.FINE, "Load class: [" + className + "] Thread: [" + Thread.currentThread().getName() + "] using ClassLoader: [" + loader + "] \n [ " + classLoaderHierarchy.toString() + " ] \n");
            }
            return loadClass;
        }
        catch (ClassNotFoundException ex) {
            if (localOnly) {
                throw ex;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Thread: [" + Thread.currentThread().getName() + "] failed to load class [" + className + "] by Thread ContextClassLoader: [" + loader + "]. Attempting to load by Class.forName()", ex);
            }
            return LRMIClassLoadersHolder.loadClass(className);
        }
    }

    public static Class loadClass(String className, boolean localOnly, Class defaultClass) {
        if (className == null) {
            return defaultClass;
        }
        try {
            return ClassLoaderHelper.loadClass(className, localOnly);
        }
        catch (ClassNotFoundException e) {
            return defaultClass;
        }
    }

    public static Class loadClass(String codebase, String className, ClassLoader classLoader) throws ClassNotFoundException, MalformedURLException {
        return ClassLoaderHelper.loadClass(codebase, className, classLoader, false);
    }

    public static Class loadClass(String codebase, String className, ClassLoader classLoader, boolean localOnly) throws ClassNotFoundException, MalformedURLException {
        try {
            return ClassLoaderHelper.loadClass(className, localOnly);
        }
        catch (ClassNotFoundException cnfe) {
            if (localOnly) {
                throw cnfe;
            }
            try {
                Class<?> loaded = RMIClassLoader.loadClass(codebase, className, classLoader);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Load class: [" + className + "] Thread: [" + Thread.currentThread().getName() + "] using RMIClassLoader passing codebase: [" + codebase + "] and additional ClassLoader: [" + classLoader + "] \n");
                }
                return loaded;
            }
            catch (ClassNotFoundException loaded) {
                try {
                    return LRMIClassLoadersHolder.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "Thread: [" + Thread.currentThread().getName() + "] failed to load class [" + className + "] using LRMIClassLoader \n", e);
                    }
                    throw e;
                }
            }
        }
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static void setContextClassLoader(ClassLoader cl, boolean ignoreSecurity) {
        if (ignoreSecurity) {
            ClassLoaderHelper.setDirectContextClassLoader(cl);
        } else {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private static void setDirectContextClassLoader(ClassLoader cl) {
        Thread t = Thread.currentThread();
        if (t instanceof FastContextClassLoaderThread) {
            t.setContextClassLoader(cl);
            return;
        }
        if (_directContextClassLoaderThreadField != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Thread: " + Thread.currentThread() + " set direct contextClassLoader: " + cl);
            }
            try {
                _directContextClassLoaderThreadField.set(Thread.currentThread(), cl);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Unexpected behavior of Thread.class. Failed to setContextClassLoader.", e);
            }
        } else {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static String getClassLoaderLogName(ClassLoader cl) {
        if (cl == null) {
            return NULL_CL_LOGNAME;
        }
        return cl instanceof LoggableClassLoader ? ((LoggableClassLoader)cl).getLogName() : cl.toString();
    }
}

