/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.AbstractStoredList;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.SimpleLockStoredList;
import java.util.HashMap;

@InternalApi
public class HashedSimpleLockIStoredList<T>
extends SimpleLockStoredList<T> {
    private static final int MINIMAL_SIZE_TO_CREATE_HASH = 10;
    private HashMap<T, IObjectInfo<T>> _objectsMap;

    public HashedSimpleLockIStoredList(boolean Support_Random_Scans) {
        super(Support_Random_Scans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectInfo<T> add(T subject) {
        this.lock.lock();
        try {
            AbstractStoredList.ObjectInfo<T> oi = this.store_impl(subject);
            this.updateHashAfterInsertion(oi);
            AbstractStoredList.ObjectInfo<T> objectInfo = oi;
            return objectInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateHashAfterInsertion(IObjectInfo<T> oi) {
        if (this._objectsMap != null) {
            this._objectsMap.put(oi.getSubject(), oi);
        } else if (this.m_Size >= 10) {
            this._objectsMap = new HashMap();
            for (AbstractStoredList.ObjectInfo toi = this.m_Tail; toi != null; toi = toi.getForwardRef()) {
                if (toi.getSubject() == null) continue;
                this._objectsMap.put(toi.getSubject(), toi);
            }
        }
    }

    @Override
    public void remove(IObjectInfo<T> oi) {
        this.lock.lock();
        try {
            if (this._objectsMap != null && oi.getSubject() != null) {
                this._objectsMap.remove(oi.getSubject());
            }
            this.remove_impl((AbstractStoredList.ObjectInfo)oi);
            if (this.m_Size == 0 && this._objectsMap != null) {
                this._objectsMap = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeByObject(T obj) {
        this.lock.lock();
        IObjectInfo<T> oi = null;
        try {
            if (this._objectsMap != null) {
                oi = this._objectsMap.remove(obj);
                if (oi != null) {
                    this.remove_impl((AbstractStoredList.ObjectInfo)oi);
                    if (this.m_Size == 0) {
                        this._objectsMap = null;
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = this.removeByObject_impl(obj);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean contains(T obj) {
        this.lock.lock();
        try {
            if (this._objectsMap != null) {
                boolean bl = this._objectsMap.containsKey(obj);
                return bl;
            }
            boolean bl = this.contains_impl(obj);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

