/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.loadbalance.LoadBalancingPolicy;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.io.XmlUtils;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.internal.utils.CollectionUtils;
import com.gigaspaces.internal.utils.xslt.XSLTConverter;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoProvider;
import com.gigaspaces.management.entry.JMXConnection;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.UnderTxnLockedObject;
import com.j_spaces.core.cluster.ClusterMemberInfo;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.exception.ClusterConfigurationException;
import com.j_spaces.core.exception.internal.EngineInternalSpaceException;
import com.j_spaces.core.exception.internal.LeaseInternalSpaceException;
import com.j_spaces.core.exception.internal.ProxyInternalSpaceException;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import com.j_spaces.kernel.log.JProperties;
import com.j_spaces.lookup.entry.ClusterName;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.jini.admin.JoinAdmin;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.discovery.Constants;
import net.jini.discovery.LookupGroups;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.lookup.entry.Name;
import net.jini.space.InternalSpaceException;
import org.jini.rio.boot.BootUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@InternalApi
public class JSpaceUtilities {
    public static final String BLANK_VALUE = "-";
    public static final String YES_VAL = "Yes";
    public static final String NO_VAL = "No";
    public static final String SECURED_HIDDEN_VALUE = "****";
    public static final String NOT_AVAILABLE_STR = "n/a";
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.config");
    private static final String XML_VERSION_TAG = "<?xml version=\"1.0\"?>";
    private static final String EMPTY = "";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Map<ServiceID, Boolean> jmxRemotePortDefiedMap = new HashMap<ServiceID, Boolean>();
    private static final Set<String> ALL_SPACE_SCHEMAS = CollectionUtils.toUnmodifiableSet("default", "javaspace", "cache", "persistent");

    public static boolean domWriter(Node node, PrintStream ps, String prefix) {
        ps.print(XML_VERSION_TAG);
        return JSpaceUtilities._domWriter(node, ps, prefix);
    }

    private static boolean _domWriter(Node node, PrintStream ps, String prefix) {
        if (node.getNodeType() == 3) {
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                JSpaceUtilities._domWriter(nl.item(i), ps, prefix);
            }
            String nodeValue = node.getNodeValue().trim();
            if (nodeValue != null && nodeValue.length() > 0) {
                ps.print(nodeValue);
                return true;
            }
            return false;
        }
        if (node.getNodeType() == 8) {
            ps.println();
            ps.print(prefix + "<!--" + node.getNodeValue().trim() + "-->");
            return false;
        }
        NodeList nl = node.getChildNodes();
        int numOfChildren = nl.getLength();
        String tagName = JSpaceUtilities.getNodeSignature(node);
        ps.println();
        ps.print(prefix + "<" + tagName + ">");
        boolean isMemberUrlTag = tagName.equals("member-url");
        boolean valueNode = false;
        for (int i = 0; i < numOfChildren; ++i) {
            Node childNode = nl.item(i);
            if (isMemberUrlTag) {
                String memberUrl = childNode.getNodeValue();
                memberUrl = JSpaceUtilities.handleInvalidChars(memberUrl);
                childNode.setNodeValue(memberUrl);
            }
            boolean returnedValue = JSpaceUtilities._domWriter(childNode, ps, prefix + "     ");
            valueNode = valueNode || returnedValue;
        }
        if (!valueNode) {
            ps.println();
            ps.print(prefix + "</" + node.getNodeName() + ">");
        } else {
            ps.print("</" + node.getNodeName() + ">");
        }
        return false;
    }

    public static String createContainerPresentName(String hostName, String containerName) {
        hostName = hostName == null ? EMPTY : hostName + ":";
        return hostName + containerName;
    }

    private static String getNodeSignature(Node node) {
        if (!node.hasAttributes()) {
            return node.getNodeName();
        }
        String nodeSignature = node.getNodeName() + " ";
        NamedNodeMap attrMap = node.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Node attrNode = attrMap.item(i);
            nodeSignature = nodeSignature + attrNode.getNodeName() + "=\"" + attrNode.getNodeValue() + "\" ";
        }
        return nodeSignature.trim();
    }

    public static boolean parseBooleanTag(String tag, String s) {
        return JSpaceUtilities.parseBooleanTag(tag, s, false);
    }

    public static boolean parseBooleanTag(String tag, String s, boolean defaultValue) {
        if (s == null || s.startsWith("${")) {
            return defaultValue;
        }
        if (s.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return false;
        }
        if (s.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return true;
        }
        throw new IllegalArgumentException("Illegal boolean input string: \"" + s + "\" for tag: <" + tag + ">");
    }

    public static void normalize(Node node) {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() == 3 && childNode.getNodeValue().trim().length() == 0) {
                node.removeChild(childNode);
                --i;
                continue;
            }
            JSpaceUtilities.normalize(childNode);
        }
    }

    public static void convertDOMTreeFromSystemProperty(Node node) {
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (childNode.getNodeType() == 3) {
                String childNodeValue = childNode.getNodeValue().trim();
                if (childNodeValue.length() == 0) continue;
                childNodeValue = JProperties.getPropertyFromSystem(childNodeValue, null);
                childNode.setNodeValue(childNodeValue);
                continue;
            }
            JSpaceUtilities.convertDOMTreeFromSystemProperty(childNode);
        }
    }

    private static Node createTextNode(Document _doc, String tagName, String tagValue) {
        Element tag = _doc.createElement(tagName);
        Text tagText = _doc.createTextNode(tagValue);
        tag.appendChild(tagText);
        return tag;
    }

    private static Node createClusterMembers(Document _rootDoc, Element _rootMembersElem, int _totalMembers, int _backupMembers, String _clusterName, String _groups) {
        Element memberTag = null;
        String memberPrefix = System.getProperty("com.gs.cluster.url-protocol-prefix", "jini://*/");
        for (int i = 1; i <= _totalMembers; ++i) {
            memberTag = _rootDoc.createElement("member");
            if (_backupMembers > 0) {
                memberTag.setAttribute("backup-container", _clusterName + "_container" + i);
                memberTag.setAttribute("number-backups", Integer.toString(_backupMembers));
                if (_groups != null) {
                    memberTag.setAttribute("jini-groups", "?groups=" + _groups);
                }
                memberTag.setAttribute("member-prefix", memberPrefix);
            }
            Element memberNameTag = _rootDoc.createElement("member-name");
            Text memberNameText = _rootDoc.createTextNode(_clusterName + "_container" + i + ":" + _clusterName);
            Element memberUrlTag = _rootDoc.createElement("member-url");
            Text memberUrlText = null;
            memberUrlText = _groups != null ? _rootDoc.createTextNode(memberPrefix + _clusterName + "_container" + i + "/" + _clusterName + "?groups=" + _groups) : _rootDoc.createTextNode(memberPrefix + _clusterName + "_container" + i + "/" + _clusterName);
            memberTag.appendChild(memberNameTag).appendChild(memberNameText);
            memberTag.appendChild(memberUrlTag).appendChild(memberUrlText);
            _rootMembersElem.appendChild(memberTag);
        }
        return _rootMembersElem;
    }

    public static Document convertToClusterConfiguration(Document clusterXMLDomElement, InputStream clusterXSLPolicy) throws IOException, TransformerConfigurationException, TransformerException, ParserConfigurationException, SAXException {
        Document rootDoc = (Document)XSLTConverter.transformDOM2DOM(clusterXMLDomElement, clusterXSLPolicy);
        return rootDoc;
    }

    public static Document overrideClusterConfigWithXPath(String xpath, String newValue, Document clusterConfigRootDoc) throws Exception {
        Node firstNode = null;
        NodeList nodes = null;
        try {
            nodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate(xpath, clusterConfigRootDoc, XPathConstants.NODESET);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Failed to override the cluster config using the xpath expression <" + xpath + "> passed through the custom properties.", e);
        }
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                firstNode = node.getNodeType() == 2 ? node : node.getFirstChild();
                if (firstNode == null) continue;
                String oldNodeValue = firstNode.getNodeValue().trim();
                firstNode.setNodeValue(newValue);
                if (!_logger.isLoggable(Level.CONFIG)) continue;
                _logger.log(Level.CONFIG, "Override the cluster config using the xpath expression <" + xpath + "> passed through the custom properties.\n\tOld value: <" + oldNodeValue + "> \t new value: <" + newValue + ">");
            }
        }
        if (firstNode == null && _logger.isLoggable(Level.SEVERE)) {
            throw new ClusterConfigurationException("Failed to override the cluster config using the xpath expression <" + xpath + ">, no element matched the given xpath expression");
        }
        return clusterConfigRootDoc;
    }

    public static Document overrideClusterConfigWithXPath(Properties customProps, Document clusterConfigRootDoc) throws Exception {
        if (customProps != null) {
            Enumeration<Object> keys = customProps.keys();
            while (keys.hasMoreElements()) {
                boolean isStandardXPath;
                String propKey = (String)keys.nextElement();
                boolean bl = isStandardXPath = propKey.startsWith("/cluster-config");
                if (!isStandardXPath && !propKey.startsWith("cluster-config")) continue;
                String propValue = customProps.getProperty(propKey);
                if (!isStandardXPath) {
                    propKey = "/" + JSpaceUtilities.replaceInString(propKey, ".", "/", true);
                }
                if (!JSpaceUtilities.isEmpty(propValue)) {
                    propValue = JSpaceUtilities.removeInvertedCommas(propValue);
                }
                clusterConfigRootDoc = JSpaceUtilities.overrideClusterConfigWithXPath(propKey, propValue, clusterConfigRootDoc);
            }
        }
        return clusterConfigRootDoc;
    }

    public static Document buildClusterXMLDom(int _totalMembers, int _backupMembers, String _clusterSchemaName, String _clusterName, String _distCacheConfigName, String _jmsConfigName, String _groups) throws ParserConfigurationException {
        Document rootDoc = XmlUtils.getDocumentBuilder().newDocument();
        Element clusterConfigTag = rootDoc.createElement("cluster-config");
        Node clusterSchemaTag = JSpaceUtilities.createTextNode(rootDoc, "cluster-schema-name", _clusterSchemaName);
        clusterConfigTag.appendChild(clusterSchemaTag);
        Node clusterNameTag = JSpaceUtilities.createTextNode(rootDoc, "cluster-name", _clusterName);
        clusterConfigTag.appendChild(clusterNameTag);
        if (!JSpaceUtilities.isEmpty(_distCacheConfigName)) {
            Element dcacheConfigElem = rootDoc.createElement("dist-cache");
            dcacheConfigElem.appendChild(JSpaceUtilities.createTextNode(rootDoc, "config-name", _distCacheConfigName));
            clusterConfigTag.appendChild(dcacheConfigElem);
        }
        if (!JSpaceUtilities.isEmpty(_jmsConfigName)) {
            Element jmsConfigElem = rootDoc.createElement("jms");
            jmsConfigElem.appendChild(JSpaceUtilities.createTextNode(rootDoc, "config-name", _jmsConfigName));
            clusterConfigTag.appendChild(jmsConfigElem);
        }
        Node notifyRecoveryTag = JSpaceUtilities.createTextNode(rootDoc, "notify-recovery", ClusterXML.NOTIFY_RECOVERY_DEFAULT_VALUE);
        clusterConfigTag.appendChild(notifyRecoveryTag);
        Element clusterMembersTag = rootDoc.createElement("cluster-members");
        clusterConfigTag.appendChild(clusterMembersTag);
        JSpaceUtilities.createClusterMembers(rootDoc, clusterMembersTag, _totalMembers, _backupMembers, _clusterName, _groups);
        rootDoc.appendChild(clusterConfigTag);
        return rootDoc;
    }

    public static void setXMLImplSystemProps() {
        if (Boolean.getBoolean("com.gs.dont-use-default-xml-parser")) {
            System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        }
    }

    public static String replaceInString(String content, String oldStr, String newStr, boolean replaceAll) {
        int startInx = 0;
        String lowCaseContent = content.toLowerCase();
        StringBuilder originalCotext = new StringBuilder(content);
        String lowSearchStr = oldStr.toLowerCase();
        while ((startInx = lowCaseContent.indexOf(lowSearchStr, startInx)) != -1) {
            int endInx = startInx + oldStr.length();
            content = originalCotext.replace(startInx, endInx, newStr).toString();
            lowCaseContent = originalCotext.toString().toLowerCase();
            startInx = endInx;
            if (replaceAll) continue;
            return content;
        }
        return content;
    }

    private static String handleInvalidChars(String str) {
        String result = EMPTY;
        String replaceAmpresand1 = "&";
        String replaceAmpresand2 = "amp;";
        String replaceAmpresand = "&amp;";
        int ampLength = "amp;".length();
        StringTokenizer strTokinizer = new StringTokenizer(str, String.valueOf("&"), true);
        while (strTokinizer.hasMoreTokens()) {
            String token = strTokinizer.nextToken();
            if (token.startsWith("amp;")) {
                token = token.substring(ampLength);
            } else if (token.equals("&")) {
                token = "&amp;";
            }
            result = result + token;
        }
        return result;
    }

    public static String getStackTrace(Throwable t) {
        return BootUtil.getStackTrace((Throwable)t);
    }

    public static String getCallStackTraces(int deep) {
        int shift = 2;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StringBuilder stringBuilder = new StringBuilder("\n");
        for (int i = 0; i < deep && i + 2 < stackTrace.length; ++i) {
            stringBuilder.append(stackTrace[i + 2]);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String getPropertiesPresentation(Properties props) {
        if (props == null) {
            return EMPTY;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        props.list(pw);
        pw.flush();
        return sw.toString();
    }

    public static String getCauseExceptionMessageFromHierarchy(Exception sourceException, Class checkCauseExceptionClass) {
        Throwable causeException = sourceException;
        while ((causeException = causeException.getCause()) != null) {
            if (!causeException.getClass().equals(checkCauseExceptionClass)) continue;
            String message = causeException.getMessage();
            if (JSpaceUtilities.isEmpty(message)) {
                message = causeException.toString();
            }
            return message;
        }
        return null;
    }

    public static Throwable getCauseExceptionFromHierarchy(Exception sourceException, Class checkCauseExceptionClass) {
        Throwable causeException = sourceException;
        while ((causeException = causeException.getCause()) != null) {
            if (!causeException.getClass().equals(checkCauseExceptionClass)) continue;
            return causeException;
        }
        return null;
    }

    public static Throwable getAssignableCauseExceptionFromHierarchy(Exception sourceException, Class checkCauseExceptionClass) {
        Throwable causeException = sourceException;
        while ((causeException = causeException.getCause()) != null) {
            if (!checkCauseExceptionClass.isAssignableFrom(causeException.getClass())) continue;
            return causeException;
        }
        return null;
    }

    public static Throwable getRootCauseException(Throwable sourceException) {
        Throwable causeException = sourceException;
        while (causeException.getCause() != null) {
            causeException = causeException.getCause();
        }
        return causeException;
    }

    public static boolean isSameException(Throwable exception1, Throwable exception2) {
        if (exception1 == exception2) {
            return true;
        }
        if (exception1 == null || exception2 == null) {
            return false;
        }
        if (!exception1.getClass().equals(exception2.getClass())) {
            return false;
        }
        if (!exception1.getMessage().equals(exception2.getMessage())) {
            return false;
        }
        return Arrays.equals(exception1.getStackTrace(), exception2.getStackTrace());
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmpty(String s, boolean isWithTrim) {
        if (s == null) {
            return true;
        }
        if (isWithTrim) {
            s = s.trim();
        }
        return s.length() == 0;
    }

    public static boolean isObjectEquals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static boolean isStringEquals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (JSpaceUtilities.isEmpty(s1) && JSpaceUtilities.isEmpty(s2)) {
            return true;
        }
        return s1.trim().equals(s2.trim());
    }

    public static boolean isStringEqualsIgnoreCase(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (JSpaceUtilities.isEmpty(s1) && JSpaceUtilities.isEmpty(s2)) {
            return true;
        }
        return s1.trim().equalsIgnoreCase(s2.trim());
    }

    public static ServiceID getSpaceServiceID(IJSpace space) {
        return JSpaceUtilities.getServiceID((ReferentUuid)space);
    }

    public static ServiceID getServiceID(ReferentUuid service) {
        Uuid uuid = service.getReferentUuid();
        return new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static String removeInvertedCommas(String s) {
        return JSpaceUtilities.removeDelimiter(s, '\"');
    }

    public static String removeDelimiter(String s, char delim) {
        return JSpaceUtilities.removeDelimiter(s, delim, '\uffff', '\uffff');
    }

    public static String removeDelimiter(String s, char delim, char openEscape, char closeEscape) {
        StringBuilder t = new StringBuilder(s);
        boolean escaped = false;
        for (int i = 0; i < t.length(); ++i) {
            char c = t.charAt(i);
            if (escaped) {
                if (c != closeEscape) continue;
                escaped = false;
                continue;
            }
            if (c == openEscape) {
                escaped = true;
                continue;
            }
            if (c != delim) continue;
            t.deleteCharAt(i--);
        }
        return t.toString();
    }

    public static String getJiniGroupRepresentation(IRemoteJSpaceAdmin spaceAdmin) throws RemoteException {
        String jiniGroupRepresentation = EMPTY;
        if (spaceAdmin instanceof JoinAdmin) {
            String[] lookupGroups;
            JoinAdmin joinAdmin = (JoinAdmin)spaceAdmin;
            for (String groupName : lookupGroups = joinAdmin.getLookupGroups()) {
                jiniGroupRepresentation = jiniGroupRepresentation.length() == 0 ? groupName : jiniGroupRepresentation + "; " + groupName;
            }
        }
        return jiniGroupRepresentation;
    }

    public static Object getObjectFromSpaceByUid(IJSpace spaceProxy, String uid) throws Exception {
        Object returnObject;
        block2: {
            ExternalEntry entry = (ExternalEntry)((ISpaceProxy)spaceProxy).readByUid(uid, null, 32, QueryResultTypeInternal.EXTERNAL_ENTRY, false);
            returnObject = entry;
            try {
                returnObject = ((ISpaceProxy)spaceProxy).getDirectProxy().getTypeManager().getObjectFromIGSEntry(entry);
            }
            catch (Exception exc) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, exc.toString(), exc);
            }
        }
        return returnObject;
    }

    public static void throwInternalSpaceException(String msg, Exception cause) throws InternalSpaceException {
        throw new InternalSpaceException(msg, cause);
    }

    public static void throwLeaseInternalSpaceException(String msg, Exception cause) throws InternalSpaceException {
        throw new LeaseInternalSpaceException(msg, cause);
    }

    public static void throwEngineInternalSpaceException(String msg, Exception cause) throws InternalSpaceException {
        throw new EngineInternalSpaceException(msg, cause);
    }

    public static ProxyInternalSpaceException createProxyInternalSpaceException(Exception e) throws InternalSpaceException {
        return new ProxyInternalSpaceException(e.getMessage(), e.getCause());
    }

    public static void throwReplicationInternalSpaceException(String msg, Exception cause) throws InternalSpaceException {
        throw new ReplicationInternalSpaceException(msg, cause);
    }

    public static long countSpaceObjects(SpaceRuntimeInfo info) {
        long count = 0L;
        int listSize = info.m_NumOFEntries.size();
        for (int i = 0; i < listSize; ++i) {
            Integer intObj = info.m_NumOFEntries.get(i);
            count += (long)intObj.intValue();
        }
        return count;
    }

    public static String[] splitString(String source, char delimeter) {
        String[] resultArray = null;
        int delimeterIndex = source.indexOf(delimeter);
        if (delimeterIndex < 0) {
            resultArray = new String[]{source};
        } else {
            String firstStr = source.substring(0, delimeterIndex);
            String secondStr = source.substring(delimeterIndex + 1);
            resultArray = new String[]{firstStr, secondStr};
        }
        return resultArray;
    }

    public static String createFullSpaceName(String containerName, String spaceName) {
        return containerName + ":" + spaceName;
    }

    public static String formatMillis(long millis) {
        boolean isMinutes = false;
        double instTime = millis;
        String suffix = "milliseconds";
        if (instTime > 60000.0) {
            suffix = "minutes";
            instTime /= 60000.0;
            isMinutes = true;
        } else if (instTime > 1000.0) {
            suffix = "seconds";
            instTime /= 1000.0;
        }
        if (!isMinutes) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            return nf.format(instTime) + " " + suffix;
        }
        int minutes = (int)instTime;
        double seconds = (instTime - (double)minutes) * 60.0;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumIntegerDigits(2);
        return minutes + ":" + nf.format(seconds) + " " + suffix;
    }

    public static String[] parseLookupGroups(String lookupGroups) {
        String[] groups = new String[]{EMPTY};
        if (!lookupGroups.equalsIgnoreCase(EMPTY)) {
            if (lookupGroups.equalsIgnoreCase("none")) {
                groups = LookupGroups.none();
            } else if (lookupGroups.equalsIgnoreCase("all")) {
                groups = LookupGroups.all();
            } else {
                StringTokenizer st = new StringTokenizer(lookupGroups, ",");
                groups = new String[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    String grl = st.nextToken().trim();
                    if (grl.equalsIgnoreCase("all")) {
                        groups = LookupGroups.all();
                        break;
                    }
                    groups[i] = grl.equalsIgnoreCase("public") ? EMPTY : grl;
                    ++i;
                }
            }
        }
        return groups;
    }

    public static Map<String, ClusterMemberInfo> getClusterMembersInfoMap(ClusterPolicy clusterPolicy) {
        Set<ClusterMemberInfo> clusterMemberInfoSet = JSpaceUtilities.getClusterMembersInfoSet(clusterPolicy);
        HashMap<String, ClusterMemberInfo> resultMap = new HashMap<String, ClusterMemberInfo>(clusterMemberInfoSet.size());
        for (ClusterMemberInfo clusterMemberInfo : clusterMemberInfoSet) {
            resultMap.put(clusterMemberInfo.memberName, clusterMemberInfo);
        }
        return resultMap;
    }

    public static Set<ClusterMemberInfo> getClusterMembersInfoSet(ClusterPolicy clusterPolicy) {
        HashSet<ClusterMemberInfo> clusterMembersSet = new HashSet<ClusterMemberInfo>();
        FailOverPolicy failOverPolicy = clusterPolicy.m_FailOverPolicy;
        LoadBalancingPolicy loadBalancingPolicy = clusterPolicy.m_LoadBalancingPolicy;
        ReplicationPolicy replicationPolicy = clusterPolicy.m_ReplicationPolicy;
        List<SpaceURL> urlsList = null;
        List<String> groupMemberNames = null;
        if (failOverPolicy != null) {
            urlsList = failOverPolicy.failOverGroupMembersURLs;
            groupMemberNames = failOverPolicy.failOverGroupMembersNames;
            Set<ClusterMemberInfo> failOverURLsSet = JSpaceUtilities.transformToSet(urlsList, groupMemberNames);
            clusterMembersSet.addAll(failOverURLsSet);
        }
        if (loadBalancingPolicy != null) {
            urlsList = loadBalancingPolicy.loadBalanceGroupMembersURLs;
            groupMemberNames = loadBalancingPolicy.loadBalanceGroupMembersNames;
            Set<ClusterMemberInfo> loadBalancingURLsSet = JSpaceUtilities.transformToSet(urlsList, groupMemberNames);
            clusterMembersSet.addAll(loadBalancingURLsSet);
        }
        if (replicationPolicy != null) {
            urlsList = replicationPolicy.m_ReplicationGroupMembersURLs;
            groupMemberNames = replicationPolicy.m_ReplicationGroupMembersNames;
            Set<ClusterMemberInfo> replicationURLsSet = JSpaceUtilities.transformToSet(urlsList, groupMemberNames);
            clusterMembersSet.addAll(replicationURLsSet);
        }
        return clusterMembersSet;
    }

    private static Set<ClusterMemberInfo> transformToSet(List<SpaceURL> urlsList, List<String> memberNamesList) {
        if (urlsList == null) {
            return new HashSet<ClusterMemberInfo>(1);
        }
        HashSet<ClusterMemberInfo> set = new HashSet<ClusterMemberInfo>(urlsList.size());
        int listSize = urlsList.size();
        for (int i = 0; i < listSize; ++i) {
            SpaceURL memberURL = urlsList.get(i);
            String memberName = memberNamesList.get(i);
            ClusterMemberInfo clusterMemberInfo = new ClusterMemberInfo(memberName, memberURL, null, null, null, false);
            set.add(clusterMemberInfo);
        }
        return set;
    }

    public static String retriveHostName(NIOInfoProvider nioInfoProvider) throws RemoteException {
        NIODetails nioDetails = nioInfoProvider.getNIODetails();
        return nioDetails.getHostName();
    }

    public static String retriveHostAddress(NIOInfoProvider nioInfoProvider) throws RemoteException {
        NIODetails nioDetails = nioInfoProvider.getNIODetails();
        return nioDetails.getHostAddress();
    }

    public static String getJMXConnectionUrl(ServiceItem serviceItem) {
        JMXConnection jmxConnection = JSpaceUtilities.getJMXConnectionEntry(serviceItem.attributeSets);
        return jmxConnection == null ? null : jmxConnection.jmxServiceURL;
    }

    public static boolean isJMXRemotePortDefined(ServiceItem serviceItem) {
        Boolean isJmxRemoteAuthenticationRequired;
        block4: {
            isJmxRemoteAuthenticationRequired = false;
            if (serviceItem.service instanceof JVMInfoProvider) {
                JVMInfoProvider jvmInfoProvider = (JVMInfoProvider)serviceItem.service;
                ServiceID serviceId = serviceItem.serviceID;
                try {
                    isJmxRemoteAuthenticationRequired = jmxRemotePortDefiedMap.get(serviceId);
                    if (isJmxRemoteAuthenticationRequired == null) {
                        JVMDetails jvmDetails = jvmInfoProvider.getJVMDetails();
                        Map vmSystemProperties = jvmDetails.getSystemProperties();
                        isJmxRemoteAuthenticationRequired = vmSystemProperties.get("com.sun.management.jmxremote.port") != null && vmSystemProperties.get("com.sun.management.jmxremote.authenticate") != null && Boolean.parseBoolean((String)vmSystemProperties.get("com.sun.management.jmxremote.authenticate"));
                        jmxRemotePortDefiedMap.put(serviceId, isJmxRemoteAuthenticationRequired);
                    }
                }
                catch (RemoteException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block4;
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
        return isJmxRemoteAuthenticationRequired;
    }

    private static JMXConnection getJMXConnectionEntry(Entry[] attrs) {
        JMXConnection jmxConnection = null;
        for (int x = 0; x < attrs.length; ++x) {
            if (!(attrs[x] instanceof JMXConnection)) continue;
            jmxConnection = (JMXConnection)attrs[x];
            break;
        }
        return jmxConnection;
    }

    public static String retriveClusterName(Entry[] attrs) {
        String clusterName = null;
        for (Entry entry : attrs) {
            if (!(entry instanceof ClusterName)) continue;
            clusterName = ((ClusterName)entry).name;
            break;
        }
        if (clusterName != null && clusterName.equals("NONE")) {
            clusterName = null;
        }
        return clusterName;
    }

    public static String retrieveName(Entry[] attrs) {
        String name = null;
        for (Entry entry : attrs) {
            if (!(entry instanceof Name)) continue;
            name = ((Name)entry).name;
            break;
        }
        if (name != null && name.equals("NONE")) {
            name = null;
        }
        return name;
    }

    public static boolean isJDK_1_4Runtime() {
        return System.getProperty("java.specification.version", EMPTY).startsWith("1.4");
    }

    public static String createServiceName(String serviceType, int agentID, long pid) {
        return JSpaceUtilities.createServiceName(serviceType, agentID, pid, null);
    }

    public static String createServiceName(String serviceType, int agentID, long pid, String[] zones) {
        String name1 = agentID < 0 ? serviceType.toLowerCase() : serviceType.toLowerCase() + BLANK_VALUE + agentID;
        String zonesRepresentation = JSpaceUtilities.getZonesStringRepresentation(zones);
        if (zonesRepresentation.length() > 0) {
            zonesRepresentation = "[" + zonesRepresentation + "]";
        }
        String name2 = pid < 0L ? name1 : name1 + "[" + pid + "]" + zonesRepresentation;
        return name2;
    }

    public static String getLookupGroupsStringRepresentation(String[] lookupGroups) {
        String mergedGroups = EMPTY;
        if (lookupGroups != null) {
            for (String prop : lookupGroups) {
                mergedGroups = mergedGroups.length() == 0 ? prop : mergedGroups + "," + prop;
            }
        } else {
            mergedGroups = "[ALL]";
        }
        return mergedGroups;
    }

    public static String getLookupLocatorsStringRepresentation(LookupLocator[] lookupLocators) {
        String mergedLocators = EMPTY;
        if (lookupLocators != null) {
            for (LookupLocator lookupLocator : lookupLocators) {
                String locator = lookupLocator.getHost() + ":" + lookupLocator.getPort();
                mergedLocators = mergedLocators.length() == 0 ? locator : mergedLocators + "," + locator;
            }
        }
        return mergedLocators;
    }

    public static LookupLocator createLookupLocator(String loookupLocatorStr) {
        String host;
        int port = -1;
        int portIndex = loookupLocatorStr.indexOf(":");
        if (portIndex == -1) {
            port = Constants.getDiscoveryPort();
        }
        String string = host = portIndex == -1 ? loookupLocatorStr : loookupLocatorStr.substring(0, portIndex);
        if (portIndex != -1) {
            String p = loookupLocatorStr.substring(portIndex + 1, loookupLocatorStr.length());
            try {
                port = new Integer(p);
            }
            catch (Throwable t) {
                port = Constants.getDiscoveryPort();
            }
        }
        return new LookupLocator(host, port);
    }

    public static String getZonesStringRepresentation(String[] zones) {
        String mergedZones = EMPTY;
        if (zones == null || zones.length == 0) {
            return mergedZones;
        }
        if (zones != null) {
            for (String zone : zones) {
                mergedZones = mergedZones.length() == 0 ? zone : mergedZones + "," + zone;
            }
        }
        return mergedZones;
    }

    public static Entry getServiceItemLookupAttributeName(ServiceItem serviceItem, Class<? extends Entry> entryClass) {
        Entry[] attributeSets;
        Entry entryResult = null;
        for (Entry entry : attributeSets = serviceItem.attributeSets) {
            if (!entry.getClass().isAssignableFrom(entryClass)) continue;
            entryResult = entry;
            break;
        }
        return entryResult;
    }

    public static String getTransactionTypeName(int transactionType) {
        switch (transactionType) {
            case 0: {
                return "All";
            }
            case 2: {
                return "Distributed";
            }
            case 1: {
                return "Local";
            }
            case 3: {
                return "XA";
            }
        }
        return EMPTY;
    }

    public static String getTransactionStatusName(int transactionStatus) {
        switch (transactionStatus) {
            case 6: {
                return "Aborted";
            }
            case 1: {
                return "Active";
            }
            case 5: {
                return "Committed";
            }
            case 4: {
                return "Not changed";
            }
            case 3: {
                return "Prepared";
            }
            case 2: {
                return "Voting";
            }
        }
        return EMPTY;
    }

    public static String getTransactionLockTypeName(UnderTxnLockedObject lockedObject) {
        switch (lockedObject.getLockType()) {
            case 1: {
                return "Read Lock";
            }
            case 2: {
                return "Write Lock";
            }
        }
        return " - ";
    }

    public static String getTransactionLockOperationTypeName(UnderTxnLockedObject lockedObject) {
        switch (lockedObject.getOperationType()) {
            case 6: {
                return "Notify";
            }
            case 2: {
                return "Read";
            }
            case 3: {
                return "Read If Exists";
            }
            case 4: {
                return "Take";
            }
            case 5: {
                return "Take If Exists";
            }
            case 7: {
                return "Update";
            }
            case 1: {
                return "Write";
            }
        }
        return " - ";
    }

    public static Properties parsePropertiesParam(String argsStr) {
        Properties props = new Properties();
        if (argsStr != null) {
            StringTokenizer tokenizer = new StringTokenizer(argsStr, ";");
            while (tokenizer.hasMoreTokens()) {
                String property = tokenizer.nextToken();
                int equalsIndex = property.indexOf(61);
                if (equalsIndex == -1) {
                    props.setProperty(property, EMPTY);
                    continue;
                }
                props.setProperty(property.substring(0, equalsIndex), property.substring(equalsIndex + 1));
            }
        }
        return props.isEmpty() ? null : props;
    }

    public static Set<String> getExportCodebasesSet(Object service) {
        URLClassLoader cl = (URLClassLoader)service.getClass().getClassLoader();
        URL[] urls = cl.getURLs();
        HashSet<String> codebaseSet = new HashSet<String>(urls.length);
        for (URL url : urls) {
            String exportCodebase = JSpaceUtilities.retrieveCodebase(url);
            codebaseSet.add(exportCodebase);
        }
        return codebaseSet;
    }

    public static String getExportCodebase(Object service) {
        URLClassLoader cl = (URLClassLoader)service.getClass().getClassLoader();
        URL[] urls = cl.getURLs();
        return JSpaceUtilities.retrieveCodebase(urls[0]);
    }

    private static String retrieveCodebase(URL url) {
        int index;
        String exportCodebase;
        block5: {
            exportCodebase = null;
            try {
                exportCodebase = url.toURI().getPath();
            }
            catch (URISyntaxException e) {
                if (!_logger.isLoggable(Level.WARNING)) break block5;
                _logger.log(Level.WARNING, e.toString(), e);
            }
        }
        if (exportCodebase == null) {
            return EMPTY;
        }
        if (exportCodebase.indexOf(".jar") != -1 && (index = exportCodebase.lastIndexOf(47)) != -1) {
            exportCodebase = exportCodebase.substring(0, index + 1);
        }
        if (exportCodebase.startsWith("httpmd")) {
            exportCodebase = "http" + exportCodebase.substring(6);
        }
        return exportCodebase;
    }

    public static Set<String> getSpaceSchemas() {
        return ALL_SPACE_SCHEMAS;
    }
}

