/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.ConfigurationException;
import com.gigaspaces.internal.io.XmlUtils;
import com.gigaspaces.start.Locator;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.cluster.ClusterXML;
import com.j_spaces.core.exception.ClusterConfigurationException;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.jini.rio.boot.BootUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@InternalApi
public class ResourceLoader {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.common.resourceloader");

    public static URL getServicesConfigUrl() {
        URL servicesConfig = ResourceLoader.getResourceURL("config/services/services.config");
        if (servicesConfig == null) {
            servicesConfig = ResourceLoader.getResourceURL("config/services/services.config.template");
            if (servicesConfig == null) {
                try {
                    return new URL("file://dummy--services.config");
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            try {
                servicesConfig = new URL(servicesConfig.toExternalForm().substring(0, servicesConfig.toExternalForm().lastIndexOf(".template")));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return servicesConfig;
    }

    public static InputStream getResourceStream(String name, String locatorBaseDir) {
        return ResourceLoader.getResourceStream(name, locatorBaseDir, true);
    }

    public static InputStream getResourceStream(String name, String locatorBaseDir, boolean createIfNotExists) {
        InputStream result;
        block23: {
            result = null;
            try {
                File file;
                ClassLoader cl;
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                Thread currentThread = Thread.currentThread();
                ClassLoader classLoader = currentThread.getContextClassLoader();
                int lastChar = name.lastIndexOf(47);
                String onlyResourceName = null;
                boolean searchedOnlyResourceName = false;
                if (lastChar > -1) {
                    onlyResourceName = name.substring(lastChar + 1);
                }
                if (classLoader != null) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Going to load the resource <" + name + "> from the ContextClassLoader using CL: " + classLoader.getClass().getName());
                    }
                    if ((result = classLoader.getResourceAsStream(name)) == null && onlyResourceName != null) {
                        searchedOnlyResourceName = true;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Going to load the resource <" + onlyResourceName + "> from the ContextClassLoader using CL: " + classLoader.getClass().getName());
                        }
                        result = classLoader.getResourceAsStream(onlyResourceName);
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        StringBuilder classLoaderHierarchy = new StringBuilder("ClassLoader Hierarchy: ");
                        for (ClassLoader tmpCL = classLoader; tmpCL != null; tmpCL = tmpCL.getParent()) {
                            classLoaderHierarchy.append(tmpCL.getClass().toString()).append(" <-- ");
                        }
                        _logger.log(Level.FINE, "Load resource: [" + (searchedOnlyResourceName ? onlyResourceName : name) + "] Thread: [" + currentThread.getName() + "] using ClassLoader: [" + classLoader + "] \n [ " + classLoaderHierarchy.toString() + " ] \n [ Returning result: " + result + " ] \n" + (_logger.isLoggable(Level.FINEST) ? JSpaceUtilities.getStackTrace(new Exception("Debugging stack trace only (can be ignored): ")) : ""));
                    }
                }
                if (result == null && (cl = ResourceLoader.class.getClassLoader()) != null && !cl.equals(classLoader)) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "2nd try, going to load the resource <" + name + "> NOT from the ContextClassLoader but using CL: " + cl.getClass().getName());
                    }
                    if ((result = cl.getResourceAsStream(name)) == null && onlyResourceName != null) {
                        searchedOnlyResourceName = true;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "2nd try, going to load the resource <" + onlyResourceName + "> NOT from the ContextClassLoader but using CL: " + cl.getClass().getName());
                        }
                        result = cl.getResourceAsStream(onlyResourceName);
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        StringBuilder classLoaderHierarchy = new StringBuilder("ClassLoader Hierarchy: ");
                        for (ClassLoader tmpCL = cl; tmpCL != null; tmpCL = tmpCL.getParent()) {
                            classLoaderHierarchy.append(tmpCL.getClass().toString()).append(" <-- ");
                        }
                        _logger.log(Level.FINE, "Load resource: [" + (searchedOnlyResourceName ? onlyResourceName : name) + "] Thread: [" + currentThread.getName() + "] using ClassLoader: [" + cl + "] \n [ " + classLoaderHierarchy.toString() + " ] \n [ Returning result: " + result + " ] \n" + (_logger.isLoggable(Level.FINEST) ? JSpaceUtilities.getStackTrace(new Exception("Debugging stack trace only (can be ignored): ")) : ""));
                    }
                }
                if (result == null && (file = new File(name)).isFile() && file.exists()) {
                    URL fileURL = file.toURI().toURL();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Going to load the resource <" + name + "> from the path: " + fileURL);
                    }
                    if ((result = fileURL.openStream()) != null) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Load resource: [" + fileURL + "] \n [ Returning result: " + result + " ] \n" + (_logger.isLoggable(Level.FINEST) ? JSpaceUtilities.getStackTrace(new Exception("Debugging stack trace only (can be ignored): ")) : ""));
                        }
                        return result;
                    }
                }
                if (result == null && locatorBaseDir != null && createIfNotExists) {
                    String resourcePath = Locator.derivePath((String)locatorBaseDir, (String)(onlyResourceName != null ? onlyResourceName : name));
                    if (resourcePath != null) {
                        result = new File(resourcePath).toURI().toURL().openStream();
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "Load resource using Locator utility searching from < " + locatorBaseDir + " > base directory: \n [" + (onlyResourceName != null ? onlyResourceName : name) + "] Thread: [" + currentThread.getName() + "] using resource path: [" + resourcePath + "] \n [ Returning result: " + result + " ] \n" + (_logger.isLoggable(Level.FINEST) ? JSpaceUtilities.getStackTrace(new Exception("Debugging stack trace only (can be ignored): ")) : ""));
                    }
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINE)) break block23;
                _logger.log(Level.FINE, "Failed to load resource: [" + name + "] ", e);
            }
        }
        return result;
    }

    public static URL getResourceURL(String name, String locatorBaseDir) {
        return BootUtil.getResourceURL((String)name, (String)locatorBaseDir);
    }

    public static InputStream getResourceStream(String name) {
        return ResourceLoader.getResourceStream(name, null);
    }

    public static URL getResourceURL(String name) {
        return ResourceLoader.getResourceURL(name, null);
    }

    public static Properties findCustomPropertiesObj(String schemaPropertiesFileName) throws IOException, ConfigurationException {
        InputStream schemaInputStream = null;
        String schemaPropertiesPath = null;
        boolean downloadingPropsFromHTTP = schemaPropertiesFileName.startsWith("http:");
        if (downloadingPropsFromHTTP) {
            try {
                URL theUrl = new URL(schemaPropertiesFileName);
                URLConnection con = theUrl.openConnection();
                schemaInputStream = con.getInputStream();
                schemaPropertiesPath = schemaPropertiesFileName;
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to download properties file from '" + schemaPropertiesFileName + "' cause: " + e.getClass().getName() + " message: " + e.getMessage(), e);
            }
        } else {
            schemaPropertiesPath = "config/" + schemaPropertiesFileName + ".properties";
            schemaInputStream = ResourceLoader.getResourceStream(schemaPropertiesPath);
        }
        Properties schemaProperties = null;
        if (schemaInputStream != null) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("Loading properties file from: " + (downloadingPropsFromHTTP ? schemaPropertiesFileName : ResourceLoader.getResourceURL(schemaPropertiesPath).toString()));
            }
            schemaProperties = new Properties();
            schemaProperties.load(schemaInputStream);
            schemaInputStream.close();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("custom properties file values: ");
                schemaProperties.list(System.out);
            }
        } else {
            throw new ConfigurationException("Failed to load properties file: " + schemaPropertiesPath);
        }
        return schemaProperties;
    }

    public static InputStream findClusterXSLSchema(InputStream _clusterXMLInputStream) throws ClusterConfigurationException {
        String schemaNameToBeUsed = null;
        try {
            Document clusterXMLDocumet = XmlUtils.getDocumentBuilder().parse(_clusterXMLInputStream);
            schemaNameToBeUsed = ClusterXML.getNodeValueIfExists(clusterXMLDocumet.getDocumentElement(), "cluster-schema-name");
            if (JSpaceUtilities.isEmpty(schemaNameToBeUsed)) {
                String missingSchemaMsg = "Could not find the <cluster-schema-name> tag in the cluster members xml file.";
                throw new ClusterConfigurationException(missingSchemaMsg);
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return ResourceLoader.findClusterXSLSchema(schemaNameToBeUsed);
    }

    public static InputStream resolveClusterXSLSchema(String _clusterMembers) throws ClusterConfigurationException {
        String schemaNameToBeUsed = null;
        InputStream membersStream = ResourceLoader.findClusterXML(_clusterMembers);
        try {
            Document clusterXMLDocumet = XmlUtils.getDocumentBuilder().parse(membersStream);
            schemaNameToBeUsed = ClusterXML.getNodeValueIfExists(clusterXMLDocumet.getDocumentElement(), "cluster-schema-name");
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        if (JSpaceUtilities.isEmpty(schemaNameToBeUsed)) {
            String missingSchemaMsg = "Could not find the <cluster-schema-name> tag for cluster members xml file: " + _clusterMembers;
            throw new ClusterConfigurationException(missingSchemaMsg);
        }
        String schemaFilePath = "config/schemas/" + schemaNameToBeUsed + "-cluster-schema.xsl";
        InputStream schemaInputStream = ResourceLoader.getResourceStream(schemaFilePath);
        if (schemaInputStream != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Loaded the cluster xsl schema < " + ResourceLoader.getResourceURL(schemaFilePath) + " > for the cluster config setup.");
            }
            return schemaInputStream;
        }
        String missingSchemaMsg = "Could not find the cluster xsl schema file: " + schemaFilePath;
        throw new ClusterConfigurationException(missingSchemaMsg);
    }

    public static InputStream findClusterXML(String _clusterXML) {
        String schemaNameToBeUsed = _clusterXML;
        String schemaFilePath = "config/" + schemaNameToBeUsed + "-cluster.xml";
        InputStream schemaInputStream = ResourceLoader.getResourceStream(schemaFilePath);
        if (schemaInputStream != null) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("Loaded the cluster XML < " + ResourceLoader.getResourceURL(schemaNameToBeUsed) + " > for the cluster config setup.");
            }
            return schemaInputStream;
        }
        String defaultSchemaFileName = "config/default-cluster.xml";
        schemaInputStream = ResourceLoader.getResourceStream(defaultSchemaFileName);
        if (schemaInputStream != null) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning("Could not find the cluster xml file: " + schemaFilePath + ".\n Loaded the default cluster xml < " + ResourceLoader.getResourceURL(defaultSchemaFileName) + " > for the cluster config setup.");
            }
            return schemaInputStream;
        }
        if (_logger.isLoggable(Level.WARNING)) {
            _logger.warning("The requested cluster xml file does not exist in the following path: " + defaultSchemaFileName);
        }
        return schemaInputStream;
    }

    public static InputStream findClusterXSLSchema(String _clusterXSLSchema) throws ClusterConfigurationException {
        String schemaFilePath;
        InputStream schemaInputStream;
        String schemaNameToBeUsed = _clusterXSLSchema;
        if (schemaNameToBeUsed.equalsIgnoreCase("partitioned-sync2backup")) {
            schemaNameToBeUsed = "partitioned";
        }
        if ((schemaInputStream = ResourceLoader.getResourceStream(schemaFilePath = "config/schemas/" + schemaNameToBeUsed + "-cluster-schema.xsl")) != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Loaded the cluster xsl schema < " + ResourceLoader.getResourceURL(schemaFilePath) + " > for the cluster config setup.");
            }
            return schemaInputStream;
        }
        String missingSchemaMsg = "Could not find the cluster xsl schema file: " + _clusterXSLSchema;
        throw new ClusterConfigurationException(missingSchemaMsg);
    }

    public static InputStream findContainerSchema(String schemaName) {
        return ResourceLoader.findContainerSchema(schemaName, true);
    }

    public static InputStream findContainerSchema(String schemaName, boolean createIfNotExists) {
        String schemaFilePath;
        InputStream schemaInputStream;
        String schemaNameToBeUsed = schemaName;
        if (JSpaceUtilities.isEmpty(schemaName)) {
            schemaNameToBeUsed = "default";
        }
        if ((schemaInputStream = ResourceLoader.getResourceStream(schemaFilePath = "config/schemas/" + schemaNameToBeUsed + "-container-schema.xml", null, createIfNotExists)) != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Loaded the container schema < " + ResourceLoader.getResourceURL(schemaFilePath) + " > for the container configuration.");
            }
            return schemaInputStream;
        }
        if (createIfNotExists || !createIfNotExists && JSpaceUtilities.getSpaceSchemas().contains(schemaName)) {
            String defaultSchemaFileName = "config/schemas/default-container-schema.xml";
            schemaInputStream = ResourceLoader.getResourceStream(defaultSchemaFileName);
            if (schemaInputStream != null) {
                if (_logger.isLoggable(Level.CONFIG)) {
                    URL urlToLoad = ResourceLoader.getResourceURL(schemaFilePath);
                    if (urlToLoad != null) {
                        _logger.config("Could not find the container schema file at: " + urlToLoad + ".\nInstead, loaded the default container schema < " + defaultSchemaFileName + " > for the container configuration.");
                    } else {
                        _logger.config("Could not find the container schema: " + schemaFilePath + ".\nInstead, loaded the default container schema < " + defaultSchemaFileName + " > for the container configuration.");
                    }
                }
                return schemaInputStream;
            }
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning("The requested container schema file does not exist in the following path: " + defaultSchemaFileName);
            }
        }
        return schemaInputStream;
    }

    public static InputStream findConfigDCache(String fileName) {
        String filePath;
        InputStream inputStream;
        if (!"DefaultConfig".equals(fileName) && _logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "Using a custom dcache configuration file is deprecated.");
        }
        if ((inputStream = ResourceLoader.getResourceStream(filePath = "config/" + fileName + "_DCache.xml")) != null && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Loaded DCache configuration from < " + ResourceLoader.getResourceURL(filePath) + " > ");
        }
        return inputStream;
    }

    public static InputStream findJMSConfig(String customConfigFileName) throws Exception {
        InputStream inputStream;
        URL configURL = null;
        String filePath = "config/jms/";
        boolean isFullURLPath = false;
        try {
            configURL = new URL(customConfigFileName);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (configURL != null && !JSpaceUtilities.isEmpty(configURL.getProtocol())) {
            filePath = configURL.getFile();
            isFullURLPath = true;
        }
        if (!isFullURLPath) {
            filePath = customConfigFileName != null ? "config/jms/" + customConfigFileName : "config/jms/jms-config.xml";
        }
        if ((inputStream = ResourceLoader.getResourceStream(filePath)) == null) {
            String missingJMSConfigFileMsg = "Could not find the JMS configuration file '" + filePath + "'. It does not exist or not readable.";
            throw new Exception(missingJMSConfigFileMsg);
        }
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("Loaded the JMS configuration file from < " + ResourceLoader.getResourceURL(filePath) + " > ");
        }
        return inputStream;
    }

    public static SchemaProperties findSpaceSchema(String _schemaName) throws ConfigurationException {
        String schemaFilePath;
        InputStream schemaInputStream;
        String schemaNameToBeUsed = _schemaName;
        if (JSpaceUtilities.isEmpty(_schemaName)) {
            schemaNameToBeUsed = "default";
        }
        if ((schemaInputStream = ResourceLoader.getResourceStream(schemaFilePath = "config/schemas/" + schemaNameToBeUsed + "-space-schema.xml")) != null) {
            URL schemaURL = ResourceLoader.getResourceURL(schemaFilePath);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Loaded the space schema < " + schemaURL + " > for the space configuration.");
            }
            SchemaProperties schemaProperties = new SchemaProperties(schemaInputStream, schemaURL);
            return schemaProperties;
        }
        URL urlToLoad = ResourceLoader.getResourceURL(schemaFilePath);
        String msg = urlToLoad != null ? "Could not find the space schema file at: < " + urlToLoad + " >." : "Could not find the space schema file at: < " + schemaFilePath + " >.";
        throw new ConfigurationException(msg);
    }

    public static URL findContainerXML(String _containerName) {
        URL _containerNameURL = null;
        String _containerNameFilePath = "config/" + _containerName + ".xml";
        _containerNameURL = ResourceLoader.getResourceURL(_containerNameFilePath);
        if (_containerNameURL != null && _logger.isLoggable(Level.INFO)) {
            _logger.info("Loaded the container xml file < " + _containerNameURL + " >.");
        }
        return _containerNameURL;
    }

    public static String[] getClusterSchemas() {
        File directory = new File(SystemInfo.singleton().locations().config() + File.separator + "schemas");
        return ResourceLoader.getClusterSchemas(directory);
    }

    public static String[] getClusterSchemas(File schemasDir) {
        int i;
        if (schemasDir == null || !schemasDir.exists() || !schemasDir.isDirectory()) {
            return new String[0];
        }
        Object[] result = schemasDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.endsWith("-cluster-schema.xsl");
            }
        });
        for (i = 0; i < result.length; ++i) {
            int endIndex = ((String)result[i]).indexOf("-cluster-schema.xsl");
            result[i] = ((String)result[i]).substring(0, endIndex);
        }
        Arrays.sort(result);
        for (i = 1; i < result.length; ++i) {
            if (!((String)result[i]).equals("async_replicated")) continue;
            Object firstElement = result[0];
            result[0] = "async_replicated";
            result[i] = firstElement;
            break;
        }
        return result;
    }

    public static class SchemaProperties {
        private final InputStream _inputStream;
        private final URL _url;
        private static final String _hostName = SystemInfo.singleton().network().getHostId();

        SchemaProperties(InputStream inputStream, URL url) {
            this._inputStream = inputStream;
            this._url = url;
        }

        public InputStream getInputStream() {
            return this._inputStream;
        }

        public static String getHostName() {
            return _hostName;
        }

        public String getFullPath() {
            return "[" + _hostName + "] " + this._url.getPath();
        }
    }
}

