/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.ISafeArray;

@InternalApi
public class SafeArray<T>
implements ISafeArray<T> {
    private T[] _elements;

    public SafeArray(int initialCapacity) {
        this._elements = new Object[initialCapacity];
    }

    public SafeArray(SafeArray<T> copy) {
        T[] localElements = copy._elements;
        this._elements = new Object[localElements.length];
        System.arraycopy(localElements, 0, this._elements, 0, localElements.length);
    }

    public SafeArray() {
        this(10);
    }

    @Override
    public T get(int index) {
        if (this._elements.length <= index) {
            return null;
        }
        return this._elements[index];
    }

    @Override
    public void add(int index, T element) {
        if (this._elements.length <= index) {
            int newSize = index * 3 / 2 + 1;
            if (newSize < 0) {
                if (index < Integer.MAX_VALUE) {
                    newSize = Integer.MAX_VALUE;
                } else {
                    throw new ArrayIndexOutOfBoundsException("Can't add element index is legal: " + index);
                }
            }
            Object[] newElements = new Object[newSize];
            System.arraycopy(this._elements, 0, newElements, 0, this._elements.length);
            this._elements = newElements;
        }
        this._elements[index] = element;
    }

    @Override
    public void clear() {
        this._elements = new Object[10];
    }
}

