/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.GSThread;

@InternalApi
public class ScheduledRunner
extends GSThread {
    private final long _delay;
    private long _period;

    public ScheduledRunner(Runnable target, long delay, long period) {
        this(target, target.getClass().getName(), delay, period);
    }

    public ScheduledRunner(Runnable target, String name, long delay, long period) {
        super(target, name);
        super.setDaemon(true);
        this._delay = delay;
        this._period = period;
        this.start();
    }

    public void run() {
        try {
            if (this._delay > 0L) {
                this.fallAsleep(this._delay);
            }
            while (!this.isInterrupted()) {
                super.run();
                this.fallAsleep();
            }
        }
        catch (InterruptedException ie) {
            this.interrupt();
        }
    }

    private final synchronized void fallAsleep(long duration) throws InterruptedException {
        ((Object)((Object)this)).wait(duration);
    }

    private final synchronized void fallAsleep() throws InterruptedException {
        ((Object)((Object)this)).wait(this._period);
    }

    private final synchronized void wakeUp() {
        ((Object)((Object)this)).notify();
    }

    public final synchronized void reschedule(long period) {
        this._period = period;
        this.wakeUp();
    }

    public void cancel() {
        this.interrupt();
    }
}

