/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.ReentrantSimpleLock;
import com.j_spaces.kernel.AbstractStoredList;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IReusableResourcePool;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.StoredListIterator;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;

@InternalApi
public class SimpleLockStoredList<T>
extends AbstractStoredList<T> {
    protected final ReentrantSimpleLock lock = new ReentrantSimpleLock();
    private static final Scatter _scatter = new Scatter();

    public SimpleLockStoredList(boolean Support_Random_Scans) {
        this(Support_Random_Scans, null);
    }

    public SimpleLockStoredList(boolean Support_Random_Scans, IReusableResourcePool<ReadWriteLock> locksPool) {
        super(Support_Random_Scans);
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            int n = this.m_Size;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean optimizeScanForSingleObject() {
        return this.size() <= 1;
    }

    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.m_Size == 0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public IObjectInfo<T> getHead() {
        this.lock.lock();
        try {
            AbstractStoredList.ObjectInfo objectInfo = this.m_Head;
            return objectInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T getObjectFromHead() {
        this.lock.lock();
        try {
            T t = this.m_Head != null ? (T)this.m_Head.getSubject() : null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean iterate(boolean random_scan, StoredListIterator<T> res) {
        this.lock.lock();
        try {
            boolean bl;
            int num;
            if (this.m_Size <= 0) {
                boolean bl2 = false;
                return bl2;
            }
            random_scan = this.m_Support_Random_Scans && random_scan && this.m_BasicOccupied != null;
            int scanLimit = Math.max(this.m_Size, 100000);
            AbstractStoredList.ObjectInfo oi = null;
            if (!random_scan || this.m_Size == 1) {
                for (oi = this.m_Head; oi != null && oi.getSubject() == null; oi = oi.getBackwardsRef()) {
                }
                if (oi == null) {
                    boolean bl3 = false;
                    return bl3;
                }
                res.setPivotOI(oi);
                res.setCurrentOI(oi);
                res.setSubject(oi.getSubject());
                res.setBackwardsScan(true);
                res.setScanLimit(scanLimit);
                boolean bl4 = true;
                return bl4;
            }
            int pos_inside = num = _scatter.next(this.m_Size);
            AbstractStoredList.ObjectInfo ss = null;
            if (num >= 1000) {
                int chunknum = num / 1000;
                pos_inside = num % 1000;
                ArrayList al = (ArrayList)this.m_AllOccupiedPos.get(chunknum);
                ss = (AbstractStoredList.ObjectInfo)al.get(pos_inside);
            } else {
                ss = (AbstractStoredList.ObjectInfo)this.m_BasicOccupied.get(pos_inside);
            }
            for (oi = ss; oi != null && oi.getSubject() == null; oi = oi.getForwardRef()) {
            }
            if (oi != null) {
                res.setPivotOI(oi);
                res.setCurrentOI(oi);
                res.setSubject(oi.getSubject());
                res.setTryForwardScan(true);
                res.setBackwardsScan(true);
                res.setScanLimit(scanLimit);
                bl = true;
                return bl;
            }
            for (oi = ss.getBackwardsRef(); oi != null && oi.getSubject() == null; oi = oi.getBackwardsRef()) {
            }
            if (oi != null) {
                res.setPivotOI(oi);
                res.setCurrentOI(oi);
                res.setSubject(oi.getSubject());
                res.setTryForwardScan(false);
                res.setBackwardsScan(true);
                res.setScanLimit(scanLimit);
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nextPos(StoredListIterator<T> slh) {
        this.lock.lock();
        try {
            if (this.m_Size == 0) {
                boolean bl = false;
                return bl;
            }
            if (slh.setScanLimit(slh.getScanLimit() - 1) <= 0) {
                boolean bl = false;
                return bl;
            }
            AbstractStoredList.ObjectInfo<T> oi = null;
            if (slh.tryForwardScan()) {
                for (oi = slh.getCurrentOI().getForwardRef(); oi != null && oi.getSubject() == null; oi = oi.getForwardRef()) {
                }
                if (oi != null) {
                    slh.setCurrentOI(oi);
                    slh.setSubject(oi.getSubject());
                    boolean bl = true;
                    return bl;
                }
                if (!slh.backwardsScan()) {
                    boolean bl = false;
                    return bl;
                }
                slh.setTryForwardScan(false);
                slh.setCurrentOI(slh.getPivotOI());
            }
            for (oi = slh.getCurrentOI().getBackwardsRef(); oi != null && oi.getSubject() == null; oi = oi.getBackwardsRef()) {
            }
            if (oi != null) {
                slh.setCurrentOI(oi);
                slh.setSubject(oi.getSubject());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public IObjectInfo<T> add(T subject) {
        this.lock.lock();
        try {
            AbstractStoredList.ObjectInfo<T> objectInfo = this.store_impl(subject);
            return objectInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public IObjectInfo<T> addUnlocked(T subject) {
        return this.store_impl(subject);
    }

    @Override
    public void remove(IObjectInfo<T> oi) {
        this.lock.lock();
        try {
            this.remove_impl((AbstractStoredList.ObjectInfo)oi);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeUnlocked(IObjectInfo<T> oi) {
        this.remove_impl((AbstractStoredList.ObjectInfo)oi);
    }

    @Override
    public boolean removeByObject(T obj) {
        this.lock.lock();
        try {
            boolean bl = this.removeByObject_impl(obj);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean contains(T obj) {
        this.lock.lock();
        try {
            boolean bl = this.contains_impl(obj);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean invalidate() {
        if (this.size() > 0) {
            return false;
        }
        try {
            this.lock.lock();
            if (this.m_Size <= 0) {
                this.m_Size = -1;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected boolean isInvalid() {
        return this.m_Size < 0;
    }

    @Override
    public int getHashCode(int id) {
        throw new RuntimeException(" unsupported");
    }

    @Override
    public Object getKey(int id) {
        throw new RuntimeException(" unsupported");
    }

    @Override
    public IStoredList<T> getValue(int id) {
        throw new RuntimeException(" unsupported");
    }

    @Override
    public boolean isNativeHashEntry() {
        return false;
    }

    private static class Scatter {
        private static int addCounter = 0;

        private Scatter() {
        }

        public int next(int size) {
            int threadID = (int)Thread.currentThread().getId();
            return Math.abs(threadID * addCounter++ % size);
        }
    }
}

