/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.gigaspaces.api.InternalApi;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class SizeConcurrentHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private static final long serialVersionUID = -1322501772526603179L;
    private final AtomicInteger _size = new AtomicInteger();

    public SizeConcurrentHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
    }

    public SizeConcurrentHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public SizeConcurrentHashMap() {
    }

    public SizeConcurrentHashMap(Map<K, V> t) {
        super(t);
    }

    @Override
    public final V putIfAbsent(K key, V value) {
        V o = super.putIfAbsent(key, value);
        if (o == null) {
            this._size.incrementAndGet();
        }
        return o;
    }

    @Override
    public final V put(K key, V value) {
        V o = super.put(key, value);
        if (o == null) {
            this._size.incrementAndGet();
        }
        return o;
    }

    @Override
    public final V remove(Object key) {
        Object o = super.remove(key);
        if (o != null) {
            this._size.decrementAndGet();
        }
        return o;
    }

    @Override
    public final boolean remove(Object key, Object value) {
        if (super.remove(key, value)) {
            this._size.decrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public final int size() {
        return this._size.get();
    }

    @Override
    public final void clear() {
        super.clear();
        this._size.set(super.size());
    }
}

