/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.gigaspaces.api.InternalApi;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

@InternalApi
public class Sizeof {
    private static final int SZ_REF;

    public static int sizeof(boolean b) {
        return 1;
    }

    public static int sizeof(byte b) {
        return 1;
    }

    public static int sizeof(char c) {
        return 2;
    }

    public static int sizeof(short s) {
        return 2;
    }

    public static int sizeof(int i) {
        return 4;
    }

    public static int sizeof(long l) {
        return 8;
    }

    public static int sizeof(float f) {
        return 4;
    }

    public static int sizeof(double d) {
        return 8;
    }

    private static int size_inst(Class c) {
        Field[] flds = c.getDeclaredFields();
        int sz = 0;
        for (int i = 0; i < flds.length; ++i) {
            Field f = flds[i];
            if (!c.isInterface() && (f.getModifiers() & 8) != 0) continue;
            sz += Sizeof.size_prim(f.getType());
        }
        if (c.getSuperclass() != null) {
            sz += Sizeof.size_inst(c.getSuperclass());
        }
        Class<?>[] cv = c.getInterfaces();
        for (int i = 0; i < cv.length; ++i) {
            sz += Sizeof.size_inst(cv[i]);
        }
        return sz;
    }

    private static int size_prim(Class t) {
        if (t == Boolean.TYPE) {
            return 1;
        }
        if (t == Byte.TYPE) {
            return 1;
        }
        if (t == Character.TYPE) {
            return 2;
        }
        if (t == Short.TYPE) {
            return 2;
        }
        if (t == Integer.TYPE) {
            return 4;
        }
        if (t == Long.TYPE) {
            return 8;
        }
        if (t == Float.TYPE) {
            return 4;
        }
        if (t == Double.TYPE) {
            return 8;
        }
        if (t == Void.TYPE) {
            return 0;
        }
        return SZ_REF;
    }

    private static int size_arr(Object obj, Class c) {
        Class<?> ct = c.getComponentType();
        int len = Array.getLength(obj);
        if (ct.isPrimitive()) {
            return len * Sizeof.size_prim(ct);
        }
        int sz = 0;
        for (int i = 0; i < len; ++i) {
            Class<?> c2;
            sz += SZ_REF;
            Object obj2 = Array.get(obj, i);
            if (obj2 == null || !(c2 = obj2.getClass()).isArray()) continue;
            sz += Sizeof.size_arr(obj2, c2);
        }
        return sz;
    }

    public static int sizeof(Object obj) {
        if (obj == null) {
            return 0;
        }
        Class<?> c = obj.getClass();
        if (c.isArray()) {
            return Sizeof.size_arr(obj, c);
        }
        return Sizeof.size_inst(c);
    }

    static {
        int size = 4;
        try {
            size = Integer.parseInt(System.getProperty("sun.arch.data.model")) / 8;
        }
        catch (Exception exception) {
            // empty catch block
        }
        SZ_REF = size;
    }
}

