/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.gigaspaces.internal.utils.collections.economy.ConcurrentSegmentedStoredListHashmapEntry;
import com.j_spaces.kernel.AbstractStoredList;
import com.j_spaces.kernel.HashedSimpleLockIStoredList;
import com.j_spaces.kernel.IOrderedList;
import com.j_spaces.kernel.IReusableResourcePool;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.SimpleLockStoredList;
import com.j_spaces.kernel.SystemProperties;
import com.j_spaces.kernel.list.ConcurrentSegmentedStoredList;
import com.j_spaces.kernel.list.ConcurrentStoredList;
import com.j_spaces.kernel.list.ExternallyLockedStoredList;
import com.j_spaces.kernel.list.RwlLocksPool;
import com.j_spaces.kernel.list.RwlSegmentedStoredList;
import java.util.concurrent.locks.ReadWriteLock;

public final class StoredListFactory {
    private static final IReusableResourcePool<ReadWriteLock> _locksPool = new RwlLocksPool(Integer.getInteger("com.gs.engine.storedListLocks", SystemProperties.ENGINE_STORED_LIST_LOCKS_DEFAULT));

    public static <T> IStoredList<T> createList(boolean reuseLocks) {
        return StoredListFactory.createStoredList(false, reuseLocks);
    }

    public static <T> IStoredList<T> createRandomScanList(boolean reuseLocks) {
        return StoredListFactory.createStoredList(true, reuseLocks);
    }

    public static <T> IOrderedList<T> createOrderedList() {
        return new ExternallyLockedStoredList(false);
    }

    public static <T> IStoredList<T> createSegmentedList() {
        return new RwlSegmentedStoredList(null);
    }

    public static <T> IStoredList<T> createConcurrentList(boolean supportsFifo) {
        return new ConcurrentStoredList(false, supportsFifo);
    }

    public static <T> IStoredList<T> createConcurrentSegmentedList(boolean supportsFifoPerSegment) {
        return StoredListFactory.createConcurrentSegmentedList(supportsFifoPerSegment, 0, true);
    }

    public static <T> IStoredList<T> createConcurrentSegmentedList(boolean supportsFifoPerSegment, int numOfSegments, boolean padded) {
        return new ConcurrentSegmentedStoredList(supportsFifoPerSegment, numOfSegments, padded);
    }

    public static <T> IStoredList<T> createConcurrentSegmentedList(boolean segmented, boolean supportFifoPerSegment, Object StoredIndexValueInHashmap) {
        return new ConcurrentSegmentedStoredListHashmapEntry(segmented, supportFifoPerSegment, StoredIndexValueInHashmap);
    }

    public static <T> AbstractStoredList<T> createStoredList(boolean supportsRandomScans, boolean reuseLocks) {
        IReusableResourcePool<ReadWriteLock> locksPool = reuseLocks ? _locksPool : null;
        return new SimpleLockStoredList(supportsRandomScans, locksPool);
    }

    public static <T> IStoredList<T> createHashList() {
        return new HashedSimpleLockIStoredList(false);
    }
}

