/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum TimeUnitProperty {
    MILLISECONDS("ms", 1),
    SECONDS("s", 1000),
    MINUTES("m", 60000),
    HOURS("h", 3600000);

    static final String TIME_PATTERN = "(\\d+)";
    private String regex;
    int multiplier;

    private TimeUnitProperty(String suffix, int multiplier) {
        this.regex = TIME_PATTERN + suffix;
        this.multiplier = multiplier;
    }

    Long parse(String time) {
        Pattern pattern = Pattern.compile(this.regex);
        Matcher m = pattern.matcher(time);
        if (m.matches()) {
            String timeValue = m.group(1);
            return Long.parseLong(timeValue) * (long)this.multiplier;
        }
        return null;
    }

    Long parseDefault(String time) {
        Pattern pattern = Pattern.compile(TIME_PATTERN);
        Matcher m = pattern.matcher(time);
        if (m.matches()) {
            String timeValue = m.group(1);
            return Long.parseLong(timeValue) * (long)this.multiplier;
        }
        return null;
    }

    public static long getProperty(String key, String def) {
        return TimeUnitProperty.getProperty(key, def, SECONDS);
    }

    public static long getProperty(String key, String def, TimeUnitProperty defaultTimeUnit) {
        String time = System.getProperty(key, def);
        Long timeValue = null;
        for (TimeUnitProperty unit : TimeUnitProperty.values()) {
            timeValue = unit.parse(time);
            if (timeValue == null) continue;
            return timeValue;
        }
        timeValue = defaultTimeUnit.parseDefault(time);
        if (timeValue != null) {
            return timeValue;
        }
        throw new IllegalArgumentException("Invalid time interval pattern.");
    }

    public static long getParsedValue(String time, TimeUnitProperty defaultTimeUnit) {
        Long timeValue = null;
        for (TimeUnitProperty unit : TimeUnitProperty.values()) {
            timeValue = unit.parse(time);
            if (timeValue == null) continue;
            return timeValue;
        }
        timeValue = defaultTimeUnit.parseDefault(time);
        if (timeValue != null) {
            return timeValue;
        }
        throw new IllegalArgumentException("Invalid time interval pattern.");
    }

    public static long getParsedValue(String time) {
        return TimeUnitProperty.getParsedValue(time, SECONDS);
    }
}

