/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.IConsumerObject;
import com.j_spaces.kernel.threadpool.DynamicExecutors;
import com.j_spaces.kernel.threadpool.DynamicThreadPoolExecutor;
import com.j_spaces.kernel.threadpool.policy.ForceQueuePolicy;
import com.j_spaces.kernel.threadpool.policy.TimedBlockingPolicy;
import com.j_spaces.kernel.threadpool.queue.DynamicQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class WorkingGroup<E>
extends DynamicThreadPoolExecutor {
    private final IConsumerObject<E> _consumerObject;
    private final String _workingGroupName;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.kernel");

    public WorkingGroup(IConsumerObject<E> consumerObject, int priority, String wgName, int minPoolSize, int maxPoolSize, long keepAliveTime, int capacity, long waitTime) {
        super(WorkingGroup.resolvePoolSize(minPoolSize), WorkingGroup.resolvePoolSize(maxPoolSize), keepAliveTime, TimeUnit.MILLISECONDS, new DynamicQueue<Runnable>(capacity));
        this._consumerObject = consumerObject;
        this._workingGroupName = wgName;
        if (waitTime == Long.MAX_VALUE) {
            this.setRejectedExecutionHandler(new ForceQueuePolicy());
        } else {
            this.setRejectedExecutionHandler(new TimedBlockingPolicy(waitTime));
        }
        this.setThreadFactory(DynamicExecutors.priorityThreadFactory(priority, wgName));
        ((DynamicQueue)this.getQueue()).setThreadPoolExecutor(this);
    }

    public WorkingGroup(IConsumerObject<E> consumerObject, int priority, String wgName, int minPoolSize, int maxPoolSize, long keepAliveTime) {
        this(consumerObject, priority, wgName, minPoolSize, maxPoolSize, keepAliveTime, Integer.MAX_VALUE, Long.MAX_VALUE);
    }

    private static int resolvePoolSize(int poolSize) {
        if (poolSize == 0) {
            return Runtime.getRuntime().availableProcessors();
        }
        return poolSize;
    }

    public void start() {
        this.prestartAllCoreThreads();
    }

    public void enqueueBlocked(E o) {
        block2: {
            try {
                this.execute(new TaskWrapper<E>(o, this._consumerObject));
            }
            catch (RejectedExecutionException ree) {
                if (!_logger.isLoggable(Level.INFO)) break block2;
                _logger.log(Level.INFO, "Task cannot be accepted for execution.", ree);
            }
        }
    }

    public IConsumerObject<E> getConsumerObject() {
        return this._consumerObject;
    }

    @Override
    public void shutdown() {
        if (!this.isShutdown()) {
            block11: {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(this._workingGroupName + " executor is commencing shutdown...");
                }
                this.getQueue().clear();
                super.shutdown();
                try {
                    this.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    if (!_logger.isLoggable(Level.WARNING)) break block11;
                    _logger.log(Level.WARNING, this._workingGroupName + " interrupted while waiting for shutdown.", e);
                }
            }
            if (this.isTerminated()) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(this._workingGroupName + " shutdown complete.");
                }
            } else if (this.isTerminating()) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.warning(this._workingGroupName + " unsafe shutdown still in progress...");
                } else if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.severe(this._workingGroupName + " shutdown failed to complete.");
                }
            }
            this._consumerObject.cleanUp();
        }
    }

    public String getWorkingGroupName() {
        return this._workingGroupName;
    }

    public boolean hasReachedFullCapacity() {
        return this.getActiveCount() == this.getMaximumPoolSize();
    }

    private static final class TaskWrapper<T>
    implements Runnable {
        private final T task;
        private final IConsumerObject<T> consumerObject;

        public TaskWrapper(T task, IConsumerObject<T> consumerObject) {
            this.task = task;
            this.consumerObject = consumerObject;
        }

        @Override
        public void run() {
            this.consumerObject.dispatch(this.task);
        }
    }
}

