/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.list;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.SystemProperties;
import com.j_spaces.kernel.list.ConcurrentStoredList;
import com.j_spaces.kernel.list.StoredListChainSegment;
import java.util.concurrent.atomic.LongAdder;

@InternalApi
public class ConcurrentSegmentedStoredList<T>
extends ConcurrentStoredList<T> {
    private final StoredListChainSegment<T>[] _segments;
    private final LongAdder _listSize;

    public ConcurrentSegmentedStoredList(boolean supportFifoPerSegment, int inputNumOfSegments, boolean padded) {
        super(true, supportFifoPerSegment);
        int numOfSegments = inputNumOfSegments;
        if (numOfSegments == 0) {
            numOfSegments = Integer.getInteger("com.gs.engine.storedListSegments", SystemProperties.ENGINE_STORED_LIST_SEGMENTS_DEFAULT);
        }
        if (numOfSegments == 0) {
            numOfSegments = SystemProperties.ENGINE_STORED_LIST_SEGMENTS_DEFAULT;
        }
        this._segments = new StoredListChainSegment[numOfSegments];
        for (int seg = 0; seg < numOfSegments; ++seg) {
            this._segments[seg] = new StoredListChainSegment((short)seg, supportFifoPerSegment, padded);
        }
        this._listSize = padded ? new LongAdder() : null;
    }

    @Override
    public int size() {
        if (this._listSize == null) {
            return super.size();
        }
        long res = this._listSize.longValue();
        return res < 0L ? 0 : (int)res;
    }

    @Override
    protected int getNumSegments() {
        return this._segments.length;
    }

    @Override
    protected StoredListChainSegment<T> getSegment(int seg) {
        return this._segments[seg];
    }

    @Override
    protected int incremenetAndGetSize() {
        if (this._listSize == null) {
            return super.incremenetAndGetSize();
        }
        this.incrementSize();
        return this.size();
    }

    @Override
    protected void incrementSize() {
        if (this._listSize == null) {
            super.incrementSize();
        } else {
            this._listSize.increment();
        }
    }

    @Override
    protected void decrementSize() {
        if (this._listSize == null) {
            super.decrementSize();
        } else {
            this._listSize.decrement();
        }
    }

    @Override
    public boolean invalidate() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean supportsInvalidation() {
        return false;
    }
}

