/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.list;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.UncheckedAtomicIntegerFieldUpdater;
import com.gigaspaces.internal.utils.threadlocal.AbstractResource;
import com.gigaspaces.internal.utils.threadlocal.PoolFactory;
import com.gigaspaces.internal.utils.threadlocal.ThreadLocalPool;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import com.j_spaces.kernel.list.StoredListChainSegment;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ConcurrentStoredList<T>
implements IStoredList<T> {
    private final StoredListChainSegment<T> _segment;
    private volatile int _size;
    private static final ThreadLocalPool<SegmentedListIterator> _SLHolderPool = new ThreadLocalPool<SegmentedListIterator>(new SegmentedListIteratorFactory());
    private int addCounter = 0;
    private int scanCounter = 0;
    private static final AtomicIntegerFieldUpdater<ConcurrentStoredList> sizeUpdater = UncheckedAtomicIntegerFieldUpdater.newUpdater(ConcurrentStoredList.class, "_size");

    public ConcurrentStoredList(boolean segmented, boolean supportFifoPerSegment) {
        this._segment = !segmented ? new StoredListChainSegment(0, supportFifoPerSegment, false) : null;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IObjectInfo<T> add(T subject) {
        return this.addImpl(subject, null);
    }

    public IObjectInfo<T> add(T subject, Object segmentHint) {
        return this.addImpl(subject, segmentHint);
    }

    @Override
    public IObjectInfo<T> addUnlocked(T subject) {
        return this.addImpl(subject, null);
    }

    private boolean isSupportsFifoPerSegment() {
        return this.getSegment(0).isSupportFifo();
    }

    private IObjectInfo<T> addImpl(T subject, Object segmentHint) {
        if (this.supportsInvalidation()) {
            int res = this.incremenetAndGetSize();
            if (res < 0) {
                this._size = Integer.MIN_VALUE;
                return null;
            }
        } else {
            this.incrementSize();
        }
        int seg = 0;
        seg = segmentHint == null || this.getNumSegments() == 1 ? this.drawSegmentNumber(true) : this.getSegmentByHint(segmentHint);
        StoredListChainSegment<T> segment = this.getSegment(seg);
        return segment.add(subject);
    }

    private int getSegmentByHint(Object segmentHint) {
        return Math.abs(segmentHint.hashCode()) % this.getNumSegments();
    }

    @Override
    public void remove(IObjectInfo<T> poi) {
        this.remove_impl(poi, true);
    }

    @Override
    public void removeUnlocked(IObjectInfo<T> poi) {
        this.remove_impl(poi, false);
    }

    private void remove_impl(IObjectInfo<T> poi, boolean lock) {
        StoredListChainSegment.ConcurrentSLObjectInfo oi = (StoredListChainSegment.ConcurrentSLObjectInfo)poi;
        short seg = oi.getSegment();
        StoredListChainSegment<T> segment = this.getSegment(seg);
        if (lock) {
            segment.remove(oi);
        } else {
            segment.removeUnlocked(oi);
        }
        this.decrementSize();
    }

    @Override
    public boolean contains(T obj) {
        throw new RuntimeException("ConcurrentStoredList::contains not supported");
    }

    @Override
    public boolean removeByObject(T obj) {
        if (this.getNumSegments() > 1) {
            throw new RuntimeException("ConcurrentSegmentedStoredList::removeByObject not supported for multi segments list");
        }
        if (this.getSegment(0).removeByObject(obj)) {
            this.decrementSize();
            return true;
        }
        return false;
    }

    @Override
    public boolean invalidate() {
        return sizeUpdater.compareAndSet(this, 0, Integer.MIN_VALUE);
    }

    protected boolean supportsInvalidation() {
        return true;
    }

    protected int getNumSegments() {
        return 1;
    }

    protected StoredListChainSegment<T> getSegment(int seg) {
        return this._segment;
    }

    protected int incremenetAndGetSize() {
        return sizeUpdater.incrementAndGet(this);
    }

    protected void incrementSize() {
        sizeUpdater.incrementAndGet(this);
    }

    protected void decrementSize() {
        sizeUpdater.decrementAndGet(this);
    }

    @Override
    public IObjectInfo<T> getHead() {
        IObjectInfo<T> res = null;
        for (int i = 0; i < this.getNumSegments() && (res = this.getSegment(i).getHead()) == null; ++i) {
        }
        return res;
    }

    @Override
    public T getObjectFromHead() {
        IObjectInfo<T> head = this.getHead();
        if (head == null) {
            return null;
        }
        return head.getSubject();
    }

    @Override
    public boolean optimizeScanForSingleObject() {
        return this.getNumSegments() == 1 && this.isSupportsFifoPerSegment() && this.size() <= 1;
    }

    private int drawSegmentNumber(boolean add) {
        if (this.getNumSegments() == 1) {
            return 0;
        }
        int tnum = (int)Thread.currentThread().getId();
        if (tnum % this.getNumSegments() == 0) {
            ++tnum;
        }
        return add ? Math.abs(tnum * this.addCounter++ % this.getNumSegments()) : Math.abs(tnum * this.scanCounter++ % this.getNumSegments());
    }

    @Override
    public IStoredListIterator<T> establishListScan(boolean randomScan) {
        if (!randomScan && this.getNumSegments() > 1 && !this.isSupportsFifoPerSegment()) {
            throw new RuntimeException("establishListScan non-random scans not supported");
        }
        SegmentedListIterator slh = _SLHolderPool.get();
        SegmentedListIterator<T> res = this.establishPos(slh, randomScan);
        if (res == null) {
            slh.release();
        }
        return res;
    }

    private SegmentedListIterator<T> establishPos(SegmentedListIterator<T> res, boolean randomScan) {
        int startSegment = this.drawSegmentNumber(false);
        res.setStartSegment((short)startSegment);
        res._scanLimit = this.size() * 5;
        res._randomScan = randomScan && this.getNumSegments() == 1;
        int seg = startSegment;
        int i = 0;
        while (i < this.getNumSegments()) {
            if (seg == this.getNumSegments()) {
                seg = 0;
            }
            res.setCurrentSegment((short)seg);
            StoredListChainSegment<T> segment = this.getSegment(seg);
            if (segment.establishIterScanPos(res)) {
                return res;
            }
            ++i;
            ++seg;
        }
        return null;
    }

    @Override
    public IStoredListIterator<T> next(IStoredListIterator<T> slh) {
        IStoredListIterator<T> slnext = this.nextPos((SegmentedListIterator)slh);
        if (slnext == null) {
            slh.release();
        }
        return slnext;
    }

    private IStoredListIterator<T> nextPos(SegmentedListIterator<T> slh) {
        int startSegment = slh.getCurrentSegment();
        short rootSegment = slh.getStartSegment();
        int seg = startSegment;
        int i = 0;
        while (i < this.getNumSegments()) {
            if (seg == this.getNumSegments()) {
                seg = 0;
            }
            if (i > 0 && rootSegment == seg) {
                return null;
            }
            slh.setCurrentSegment((short)seg);
            StoredListChainSegment<T> segment = this.getSegment(seg);
            if (slh.isActiveSegment() ? segment.iterNext(slh) : segment.establishIterScanPos(slh)) {
                return slh;
            }
            ++i;
            ++seg;
        }
        return null;
    }

    @Override
    public boolean isMultiObjectCollection() {
        return true;
    }

    @Override
    public boolean isIterator() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(Logger logger, String msg) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(msg);
            IStoredListIterator<T> slh = null;
            try {
                slh = this.establishListScan(false);
                while (slh != null) {
                    T subject = slh.getSubject();
                    if (subject != null) {
                        logger.info(subject.getClass().getName());
                    }
                    slh = this.next(slh);
                }
            }
            finally {
                if (slh != null) {
                    slh.release();
                }
            }
        }
    }

    @Override
    public void freeSLHolder(IStoredListIterator<T> slh) {
        if (slh != null) {
            SegmentedListIterator si = (SegmentedListIterator)slh;
            slh.release();
        }
    }

    public void monitor() {
        for (int i = 0; i < this.getNumSegments(); ++i) {
            this.getSegment(i).monitor();
        }
    }

    @Override
    public int getHashCode(int id) {
        throw new RuntimeException(" unsupported");
    }

    @Override
    public Object getKey(int id) {
        throw new RuntimeException(" unsupported");
    }

    @Override
    public IStoredList<T> getValue(int id) {
        throw new RuntimeException(" unsupported");
    }

    @Override
    public boolean isNativeHashEntry() {
        return false;
    }

    static class SegmentedListIterator<T>
    extends AbstractResource
    implements IStoredListIterator<T> {
        boolean _randomScan;
        private short _startSegment;
        private short _currentSegment;
        int _scanLimit;
        int _currSegmentScanCount;
        StoredListChainSegment.ConcurrentSLObjectInfo<T> _cur;
        StoredListChainSegment.ConcurrentSLObjectInfo<T> _curElement;
        boolean _headToTail;

        @Override
        protected void clean() {
            this.setStartSegment((short)0);
            this.setCurrentSegment((short)0);
            this._scanLimit = 0;
            this._currSegmentScanCount = 0;
            this._cur = null;
            this._curElement = null;
            this._headToTail = false;
            this._randomScan = false;
        }

        void setCurrentSegment(short currentSegment) {
            this._currentSegment = currentSegment;
        }

        short getCurrentSegment() {
            return this._currentSegment;
        }

        boolean isActiveSegment() {
            return this._cur != null;
        }

        void setStartSegment(short segment) {
            this._startSegment = segment;
        }

        short getStartSegment() {
            return this._startSegment;
        }

        @Override
        public void setSubject(T subject) {
            throw new RuntimeException("invalid usage");
        }

        @Override
        public T getSubject() {
            return this._curElement != null ? (T)this._curElement.getSubject() : null;
        }
    }

    private static class SegmentedListIteratorFactory
    implements PoolFactory<SegmentedListIterator> {
        private SegmentedListIteratorFactory() {
        }

        @Override
        public SegmentedListIterator create() {
            return new SegmentedListIterator();
        }
    }
}

