/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.list;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.threadlocal.AbstractResource;
import com.gigaspaces.internal.utils.threadlocal.PoolFactory;
import com.gigaspaces.internal.utils.threadlocal.ThreadLocalPool;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IOrderedList;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ExternallyLockedStoredList<T>
implements IStoredList<T>,
IOrderedList<T> {
    private static final int SCAN_LIMIT = 100000;
    private static final int NUMBER_OF_OCCUPIED_POS_QUOTA = 1000;
    private static final int MINIMAL_NUMBER_TO_HANDLE_POSITIONS = 2;
    private static final ThreadLocalPool<StoredListIterator> _SLHolderPool = new ThreadLocalPool<StoredListIterator>(new StoredListIterator.StoredListIteratorFactory());
    private ArrayList<ObjectInfo<T>> m_BasicOccupied;
    private ArrayList<ArrayList<ObjectInfo<T>>> m_AllOccupiedPos;
    private volatile int m_Size;
    private boolean m_Support_Random_Scans;
    private int m_LastChunk;
    private int m_LastPos;
    private ObjectInfo<T> m_Tail;
    private ObjectInfo<T> m_Head;
    private static final Scatter _scatter = new Scatter();

    public ExternallyLockedStoredList(boolean Support_Random_Scans) {
        this.m_Support_Random_Scans = Support_Random_Scans;
    }

    @Override
    public int size() {
        return this.m_Size;
    }

    @Override
    public boolean optimizeScanForSingleObject() {
        return this.size() <= 1;
    }

    @Override
    public boolean isEmpty() {
        return this.m_Size == 0;
    }

    @Override
    public IObjectInfo<T> getHead() {
        return this.m_Head;
    }

    @Override
    public T getObjectFromHead() {
        return this.m_Head != null ? (T)this.m_Head.getSubject() : null;
    }

    protected StoredListIterator<T> establishPos(boolean random_scan, StoredListIterator<T> res) {
        int num;
        if (this.m_Size <= 0) {
            return null;
        }
        random_scan = this.m_Support_Random_Scans && random_scan && this.m_BasicOccupied != null;
        int scanLimit = Math.max(this.m_Size, 100000);
        ObjectInfo<T> oi = null;
        if (!random_scan || this.m_Size == 1) {
            for (oi = this.m_Head; oi != null && oi.getSubject() == null; oi = oi.getBackwardsRef()) {
            }
            if (oi == null) {
                return null;
            }
            res.setPivotOI(oi);
            res.setCurrentOI(oi);
            res.setSubject(oi.getSubject());
            res.setBackwardsScan(true);
            res.setScanLimit(scanLimit);
            return res;
        }
        int pos_inside = num = _scatter.next(this.m_Size);
        ObjectInfo<T> ss = null;
        if (num >= 1000) {
            int chunknum = num / 1000;
            pos_inside = num % 1000;
            ArrayList<ObjectInfo<T>> al = this.m_AllOccupiedPos.get(chunknum);
            ss = al.get(pos_inside);
        } else {
            ss = this.m_BasicOccupied.get(pos_inside);
        }
        for (oi = ss; oi != null && oi.getSubject() == null; oi = oi.getForwardRef()) {
        }
        if (oi != null) {
            res.setPivotOI(oi);
            res.setCurrentOI(oi);
            res.setSubject(oi.getSubject());
            res.setTryForwardScan(true);
            res.setBackwardsScan(true);
            res.setScanLimit(scanLimit);
            return res;
        }
        for (oi = ss.getBackwardsRef(); oi != null && oi.getSubject() == null; oi = oi.getBackwardsRef()) {
        }
        if (oi != null) {
            res.setPivotOI(oi);
            res.setCurrentOI(oi);
            res.setSubject(oi.getSubject());
            res.setTryForwardScan(false);
            res.setBackwardsScan(true);
            res.setScanLimit(scanLimit);
            return res;
        }
        return null;
    }

    protected StoredListIterator<T> establishOrderedPos(ObjectInfo<T> OrderedScanPivot, boolean ascending, StoredListIterator<T> res) {
        if (this.m_Size <= 0) {
            return null;
        }
        int scanLimit = Math.max(this.m_Size, 100000);
        if (OrderedScanPivot == null) {
            ObjectInfo<T> oi;
            if (!ascending) {
                return this.establishPos(false, res);
            }
            for (oi = this.m_Tail; oi != null && oi.getSubject() == null; oi = oi.getForwardRef()) {
            }
            if (oi == null) {
                return null;
            }
            res.setPivotOI(oi);
            res.setCurrentOI(oi);
            res.setSubject(oi.getSubject());
            res.setBackwardsScan(false);
            res.setTryForwardScan(true);
            res.setScanLimit(scanLimit);
            return res;
        }
        res.setPivotOI(OrderedScanPivot);
        res.setCurrentOI(OrderedScanPivot);
        res.setSubject(OrderedScanPivot.getSubject());
        res.setBackwardsScan(!ascending);
        res.setTryForwardScan(ascending);
        res.setScanLimit(scanLimit);
        return res;
    }

    protected IStoredListIterator<T> nextPos(StoredListIterator<T> slh) {
        if (this.m_Size == 0) {
            return null;
        }
        if (slh.setScanLimit(slh.getScanLimit() - 1) <= 0) {
            return null;
        }
        ObjectInfo<T> oi = null;
        if (slh.tryForwardScan()) {
            for (oi = slh.getCurrentOI().getForwardRef(); oi != null && oi.getSubject() == null; oi = oi.getForwardRef()) {
            }
            if (oi != null) {
                slh.setCurrentOI(oi);
                slh.setSubject(oi.getSubject());
                return slh;
            }
            if (!slh.backwardsScan()) {
                return null;
            }
            slh.setTryForwardScan(false);
            slh.setCurrentOI(slh.getPivotOI());
        }
        for (oi = slh.getCurrentOI().getBackwardsRef(); oi != null && oi.getSubject() == null; oi = oi.getBackwardsRef()) {
        }
        if (oi != null) {
            slh.setCurrentOI(oi);
            slh.setSubject(oi.getSubject());
            return slh;
        }
        return null;
    }

    @Override
    public IObjectInfo<T> add(T subject) {
        return this.store_impl(subject);
    }

    @Override
    public IObjectInfo<T> addUnlocked(T subject) {
        return this.store_impl(subject);
    }

    @Override
    public IObjectInfo<T> storeBeforeCeiling(IObjectInfo<T> theCeiling, T subject) {
        return this.storeBeforeCeiling_impl((ObjectInfo)theCeiling, subject);
    }

    @Override
    public IObjectInfo<T> getLargerInOrder(IObjectInfo<T> ref) {
        return ((ObjectInfo)ref).getForwardRef();
    }

    @Override
    public IObjectInfo<T> getSmallerInOrder(IObjectInfo<T> ref) {
        return ((ObjectInfo)ref).getBackwardsRef();
    }

    @Override
    public void remove(IObjectInfo<T> oi) {
        this.remove_impl((ObjectInfo)oi);
    }

    @Override
    public void removeUnlocked(IObjectInfo<T> oi) {
        this.remove_impl((ObjectInfo)oi);
    }

    @Override
    public boolean removeByObject(T obj) {
        return this.removeByObject_impl(obj);
    }

    @Override
    public boolean contains(T obj) {
        return this.contains_impl(obj);
    }

    @Override
    public boolean invalidate() {
        if (this.size() > 0) {
            return false;
        }
        if (this.m_Size <= 0) {
            this.m_Size = -1;
            return true;
        }
        return false;
    }

    protected boolean isInvalid() {
        return this.m_Size < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(Logger logger, String msg) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(msg);
            IStoredListIterator<T> slh = null;
            try {
                slh = this.establishListScan(false);
                while (slh != null) {
                    Object subject = slh.getSubject();
                    if (subject != null) {
                        logger.info(subject.getClass().getName());
                    }
                    slh = this.next(slh);
                }
            }
            finally {
                if (slh != null) {
                    slh.release();
                }
            }
        }
    }

    @Override
    public StoredListIterator<T> establishListScan(boolean random_scan) {
        if (this.isEmpty()) {
            return null;
        }
        StoredListIterator slh = _SLHolderPool.get();
        StoredListIterator<T> res = this.establishPos(random_scan, slh);
        if (res == null) {
            slh.release();
        }
        return res;
    }

    @Override
    public IStoredListIterator<T> establishListOrderedScan(IObjectInfo<T> OrderedScanPivot, boolean ascending) {
        if (this.m_Size <= 0) {
            return null;
        }
        StoredListIterator slh = _SLHolderPool.get();
        StoredListIterator<T> res = this.establishOrderedPos((ObjectInfo)OrderedScanPivot, ascending, slh);
        if (res == null) {
            slh.release();
        }
        return res;
    }

    @Override
    public IStoredListIterator<T> next(IStoredListIterator<T> slh) {
        IStoredListIterator<T> slnext = this.nextPos((StoredListIterator)slh);
        if (slnext == null) {
            slh.release();
        }
        return slnext;
    }

    @Override
    public void freeSLHolder(IStoredListIterator<T> slh) {
        if (slh != null) {
            slh.release();
        }
    }

    private boolean removeByObject_impl(Object obj) {
        ObjectInfo<T> oi;
        for (oi = this.m_Tail; !(oi == null || oi.getSubject() != null && oi.getSubject().equals(obj)); oi = oi.getForwardRef()) {
        }
        if (oi == null) {
            return false;
        }
        this.remove(oi);
        return true;
    }

    private boolean contains_impl(T obj) {
        for (ObjectInfo<T> oi = this.m_Tail; oi != null; oi = oi.getForwardRef()) {
            if (oi.getSubject() == null || !oi.getSubject().equals(obj)) continue;
            return true;
        }
        return false;
    }

    private void remove_impl(ObjectInfo<T> oiToRemove) {
        if (oiToRemove.getPosInList() == -1) {
            throw new RuntimeException(" Stored list- called remove but element already deleted !");
        }
        if (this.m_Size == 0) {
            throw new RuntimeException(" Stored list- called remove but list is empty !");
        }
        if (oiToRemove.getBackwardsRef() != null) {
            oiToRemove.getBackwardsRef().setForwardRef(oiToRemove.getForwardRef());
        }
        if (oiToRemove.getForwardRef() != null) {
            oiToRemove.getForwardRef().setBackwardsRef(oiToRemove.getBackwardsRef());
        }
        if (this.m_Tail == oiToRemove) {
            this.m_Tail = oiToRemove.getForwardRef();
        }
        if (this.m_Head == oiToRemove) {
            this.m_Head = oiToRemove.getBackwardsRef();
        }
        --this.m_Size;
        if (this.m_Support_Random_Scans && this.m_BasicOccupied != null) {
            ArrayList<ObjectInfo<T>> my_al;
            ArrayList<ObjectInfo<T>> last_al = this.m_LastChunk > 0 ? this.m_AllOccupiedPos.get(this.m_LastChunk) : this.m_BasicOccupied;
            int my_chunknum = (oiToRemove.getPosInList() - 1) / 1000;
            int my_pos_inside = (oiToRemove.getPosInList() - 1) % 1000;
            ArrayList<ObjectInfo<T>> arrayList = my_al = my_chunknum > 0 ? this.m_AllOccupiedPos.get(my_chunknum) : this.m_BasicOccupied;
            if (this.m_Size > 0 && (my_chunknum != this.m_LastChunk || my_pos_inside != this.m_LastPos)) {
                ObjectInfo<T> soi = last_al.get(this.m_LastPos);
                soi.setPosInList(oiToRemove.getPosInList());
                my_al.set(my_pos_inside, soi);
            }
            last_al.remove(this.m_LastPos);
            if (this.m_LastPos == 0 && this.m_LastChunk > 0) {
                this.m_AllOccupiedPos.remove(this.m_LastChunk);
            }
            --this.m_LastPos;
            if (this.m_LastPos < 0) {
                if (this.m_LastChunk > 0) {
                    --this.m_LastChunk;
                    this.m_LastPos = 999;
                    if (this.m_LastChunk == 0) {
                        this.m_AllOccupiedPos = null;
                    }
                } else {
                    this.m_LastPos = 0;
                }
            }
        }
        oiToRemove.setPosInList(-1);
    }

    private ObjectInfo<T> store_impl(T subject) {
        if (this.isInvalid()) {
            return null;
        }
        ++this.m_Size;
        ObjectInfo<T> oi = null;
        if (this.m_Support_Random_Scans && this.m_BasicOccupied == null && this.m_Size >= 2) {
            this.m_BasicOccupied = new ArrayList();
            int indx = 1;
            for (oi = this.m_Tail; oi != null; oi = oi.getForwardRef()) {
                this.m_BasicOccupied.add(oi);
                this.m_LastPos = indx - 1;
                oi.setPosInList(indx++);
            }
        }
        oi = new ObjectInfo<T>(subject);
        if (this.m_Tail != null) {
            oi.setForwardRef(this.m_Tail);
            this.m_Tail.setBackwardsRef(oi);
        }
        this.m_Tail = oi;
        if (this.m_Head == null) {
            this.m_Head = oi;
        }
        if (this.m_Support_Random_Scans && this.m_BasicOccupied != null) {
            ArrayList<ObjectInfo<T>> spos = null;
            int n = this.m_LastPos = this.m_Size > 1 ? this.m_LastPos + 1 : 0;
            if (this.m_LastPos >= 1000) {
                this.m_LastPos = 0;
                ++this.m_LastChunk;
                if (this.m_AllOccupiedPos == null) {
                    this.m_AllOccupiedPos = new ArrayList();
                    this.m_AllOccupiedPos.add(this.m_BasicOccupied);
                }
                this.m_AllOccupiedPos.add(new ArrayList());
            }
            spos = this.m_LastChunk == 0 ? this.m_BasicOccupied : this.m_AllOccupiedPos.get(this.m_LastChunk);
            spos.add(oi);
            oi.setPosInList(this.m_Size);
        }
        return oi;
    }

    private ObjectInfo<T> storeBeforeCeiling_impl(ObjectInfo<T> theCeiling, T subject) {
        if (this.m_Support_Random_Scans) {
            throw new RuntimeException("storeBeforeCeiling and Support_Random_Scans!");
        }
        ObjectInfo<T> oi = new ObjectInfo<T>(subject);
        ObjectInfo<T> ceiling = theCeiling;
        if (ceiling == null) {
            if (this.m_Size == 0) {
                return (ObjectInfo)this.add(subject);
            }
            oi.setBackwardsRef(this.m_Head);
            this.m_Head.setForwardRef(oi);
            this.m_Head = oi;
        } else {
            if (ceiling.getPosInList() == -1) {
                throw new RuntimeException("storeBeforeCeiling and ceiling deleted!");
            }
            oi.setBackwardsRef(ceiling.getBackwardsRef());
            oi.setForwardRef(ceiling);
            ceiling.setBackwardsRef(oi);
            if (oi.getBackwardsRef() != null) {
                oi.getBackwardsRef().setForwardRef(oi);
            }
            if (this.m_Tail == ceiling) {
                this.m_Tail = oi;
            }
        }
        ++this.m_Size;
        return oi;
    }

    @Override
    public boolean isMultiObjectCollection() {
        return true;
    }

    @Override
    public boolean isIterator() {
        return false;
    }

    @Override
    public int getHashCode(int id) {
        throw new RuntimeException(" unsupported");
    }

    @Override
    public Object getKey(int id) {
        throw new RuntimeException(" unsupported");
    }

    @Override
    public IStoredList<T> getValue(int id) {
        throw new RuntimeException(" unsupported");
    }

    @Override
    public boolean isNativeHashEntry() {
        return false;
    }

    public static class StoredListIterator<T>
    extends AbstractResource
    implements IStoredListIterator<T> {
        private ObjectInfo<T> _currentOI;
        private ObjectInfo<T> _pivotOI;
        private T _subject;
        private boolean _tryFwdScan;
        private boolean _backward;
        private int _scanLimit;

        @Override
        protected void clean() {
            this.setCurrentOI(null);
            this.setPivotOI(null);
            this.setSubject(null);
            this.setTryForwardScan(false);
            this.setBackwardsScan(false);
            this.setScanLimit(0);
        }

        public void setCurrentOI(ObjectInfo<T> currentOI) {
            this._currentOI = currentOI;
        }

        public ObjectInfo<T> getCurrentOI() {
            return this._currentOI;
        }

        public void setPivotOI(ObjectInfo<T> pivotOI) {
            this._pivotOI = pivotOI;
        }

        public ObjectInfo<T> getPivotOI() {
            return this._pivotOI;
        }

        @Override
        public void setSubject(T subject) {
            this._subject = subject;
        }

        @Override
        public T getSubject() {
            return this._subject;
        }

        public void setTryForwardScan(boolean tryFwdScan) {
            this._tryFwdScan = tryFwdScan;
        }

        public boolean tryForwardScan() {
            return this._tryFwdScan;
        }

        public void setBackwardsScan(boolean backward) {
            this._backward = backward;
        }

        public boolean backwardsScan() {
            return this._backward;
        }

        public int setScanLimit(int scanLimit) {
            this._scanLimit = scanLimit;
            return this._scanLimit;
        }

        public int getScanLimit() {
            return this._scanLimit;
        }

        public static class StoredListIteratorFactory
        implements PoolFactory<StoredListIterator> {
            @Override
            public StoredListIterator create() {
                return new StoredListIterator();
            }
        }
    }

    protected static class ObjectInfo<T>
    implements Serializable,
    IObjectInfo<T> {
        private static final long serialVersionUID = -4884728672743402002L;
        private volatile ObjectInfo<T> _backwrd;
        private volatile ObjectInfo<T> _fwrd;
        private int _pos;
        private T _subject;

        public ObjectInfo(T subject) {
            this.setSubject(subject);
        }

        @Override
        public void setSubject(T subject) {
            this._subject = subject;
        }

        @Override
        public T getSubject() {
            return this._subject;
        }

        public void setBackwardsRef(ObjectInfo<T> backwrd) {
            this._backwrd = backwrd;
        }

        public ObjectInfo<T> getBackwardsRef() {
            return this._backwrd;
        }

        public void setForwardRef(ObjectInfo<T> fwrd) {
            this._fwrd = fwrd;
        }

        public ObjectInfo<T> getForwardRef() {
            return this._fwrd;
        }

        public void setPosInList(int pos) {
            this._pos = pos;
        }

        public int getPosInList() {
            return this._pos;
        }
    }

    private static class Scatter {
        private static int addCounter = 0;

        private Scatter() {
        }

        public int next(int size) {
            int threadID = (int)Thread.currentThread().getId();
            return Math.abs(threadID * addCounter++ % size);
        }
    }
}

