/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.list;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.IntegerSet;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.list.IObjectsList;
import com.j_spaces.kernel.list.IScanListIterator;
import com.j_spaces.kernel.list.ScanSingleListIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@InternalApi
public class MultiIntersectedStoredList<T>
implements IScanListIterator<T> {
    private static final int INTERSECTED_SIZE_LIMIT = 20000;
    private IObjectsList _shortest;
    private List<IObjectsList> _otherLists;
    private IScanListIterator<T> _current;
    private final boolean _fifoScan;
    private IntegerSet _intersectedSoFarFilter;
    private Set<Object> _intersectedSoFarSet;
    private boolean _terminated;
    private boolean _started;
    private final IObjectsList _allElementslist;
    private final boolean _falsePositiveFilterOnly;
    private final Context _context;
    private Set _uniqueLists;

    public MultiIntersectedStoredList(Context context, IObjectsList list, boolean fifoScan, IObjectsList allElementslist, boolean falsePositiveFilterOnly) {
        this._fifoScan = fifoScan;
        this._allElementslist = allElementslist;
        this._shortest = list != allElementslist ? list : null;
        this._falsePositiveFilterOnly = falsePositiveFilterOnly;
        this._context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IObjectsList list, boolean shortest) {
        if (list == null || list == this._allElementslist || list == this._shortest) {
            return;
        }
        boolean duplicate = this.isDuplicate(list);
        if (duplicate && !shortest) {
            return;
        }
        boolean added = true;
        try {
            if (shortest) {
                if (this._shortest != null) {
                    added = this.addToOtherLists(this._shortest);
                    if (duplicate) {
                        this._otherLists.remove(list);
                    }
                }
                this._shortest = list;
            } else {
                added = this.addToOtherLists(list);
            }
        }
        finally {
            if (added && !duplicate) {
                this._uniqueLists.add(list);
            }
        }
    }

    private boolean isDuplicate(IObjectsList list) {
        if (this._uniqueLists == null) {
            this._uniqueLists = new HashSet();
            if (this._shortest != null) {
                this._uniqueLists.add(this._shortest);
            }
        }
        return this._uniqueLists.contains(list);
    }

    private boolean addToOtherLists(IObjectsList list) {
        if (!list.isIterator() && ((IStoredList)list).size() > 20000) {
            this._context.setBlobStoreUsePureIndexesAccess(false);
            return false;
        }
        if (this._otherLists == null) {
            this._otherLists = new ArrayList<IObjectsList>(2);
        }
        this._otherLists.add(list);
        return true;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this._terminated) {
                return false;
            }
            if (!this._started) {
                this._started = true;
                this.prepareForListsIntersection();
                if (this._terminated) {
                    return false;
                }
                this._current = this.prepareListIterator(this._shortest);
            }
            if (this._current != null && this._current.hasNext()) {
                return true;
            }
            this._current = null;
            return false;
        }
        catch (SAException sAException) {
            return false;
        }
    }

    private void prepareForListsIntersection() {
        if (this._shortest == null) {
            throw new RuntimeException("shortest list is null !!!!!!!");
        }
        if (this._otherLists != null && this._otherLists.contains(this._shortest)) {
            this._otherLists.remove(this._shortest);
        }
        if (this._otherLists == null || this._otherLists.isEmpty()) {
            return;
        }
        for (int i = 0; i < this._otherLists.size(); ++i) {
            this.intersectList(this._otherLists.get(i), i == 0);
            if ((this._intersectedSoFarFilter == null || !this._intersectedSoFarFilter.isEmpty()) && (this._intersectedSoFarSet == null || !this._intersectedSoFarSet.isEmpty())) continue;
            this._terminated = true;
            break;
        }
    }

    private void intersectList(IObjectsList list, boolean isFirstIndex) {
        if (this._falsePositiveFilterOnly) {
            this.intersectListFilter(list, isFirstIndex);
        } else {
            this.intersectListSet(list, isFirstIndex);
        }
    }

    private void intersectListFilter(IObjectsList list, boolean isFirstIndex) {
        IntegerSet newIntersectedIndices = this._intersectedSoFarFilter != null && !this._intersectedSoFarFilter.isEmpty() ? CollectionsFactory.getInstance().createIntegerSet(this._intersectedSoFarFilter.size()) : CollectionsFactory.getInstance().createIntegerSet();
        IScanListIterator<T> toScan = this.prepareListIterator(list);
        try {
            int sofar = 0;
            boolean overflow = false;
            while (toScan.hasNext()) {
                T el = toScan.next();
                if (isFirstIndex || this._intersectedSoFarFilter == null || this._intersectedSoFarFilter.contains(System.identityHashCode(el))) {
                    newIntersectedIndices.add(System.identityHashCode(el));
                }
                if (++sofar <= 20000) continue;
                overflow = true;
                this._context.setBlobStoreUsePureIndexesAccess(false);
                break;
            }
            if (!overflow) {
                this._intersectedSoFarFilter = newIntersectedIndices;
            }
            if (toScan != null) {
                toScan.releaseScan();
            }
        }
        catch (SAException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void intersectListSet(IObjectsList list, boolean isFirstIndex) {
        HashSet<Object> newIntersectedIndices = this._intersectedSoFarSet != null && !this._intersectedSoFarSet.isEmpty() ? new HashSet<Object>(this._intersectedSoFarSet.size()) : new HashSet<Object>();
        IScanListIterator<T> toScan = this.prepareListIterator(list);
        try {
            int sofar = 0;
            boolean overflow = false;
            while (toScan.hasNext()) {
                T el = toScan.next();
                if (isFirstIndex || this._intersectedSoFarSet.contains(el)) {
                    newIntersectedIndices.add(el);
                }
                if (++sofar <= 20000) continue;
                overflow = true;
                this._context.setBlobStoreUsePureIndexesAccess(false);
                break;
            }
            if (!overflow) {
                this._intersectedSoFarSet = newIntersectedIndices;
            }
            if (toScan != null) {
                toScan.releaseScan();
            }
        }
        catch (SAException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public T next() {
        T res = null;
        try {
            if (!this._terminated) {
                res = this.getNext();
            }
        }
        catch (SAException sAException) {
            // empty catch block
        }
        return res;
    }

    private T getNext() throws SAException {
        Object res = null;
        do {
            res = this._current.next();
            if (this._falsePositiveFilterOnly) {
                if (res != null && this._intersectedSoFarFilter != null && !this._intersectedSoFarFilter.contains(System.identityHashCode(res))) {
                    res = null;
                    continue;
                }
            } else if (res != null && this._intersectedSoFarSet != null && !this._intersectedSoFarSet.contains(res)) {
                res = null;
                continue;
            }
            if (res != null) break;
        } while (this._current.hasNext());
        if (res == null) {
            this._terminated = true;
        }
        return res;
    }

    @Override
    public void releaseScan() {
        try {
            if (this._current != null) {
                this._current.releaseScan();
                this._current = null;
            }
        }
        catch (SAException sAException) {
            // empty catch block
        }
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        return -1;
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    @Override
    public boolean isAlreadyMatched() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return true;
    }

    protected IScanListIterator<T> prepareListIterator(IObjectsList list) {
        return !list.isIterator() ? new ScanSingleListIterator((IStoredList)list, this._fifoScan) : (IScanListIterator)list;
    }

    public boolean isMultiList() {
        return this._shortest != null && this.getNumOfLists() > 1;
    }

    private int getNumOfLists() {
        return this._otherLists != null ? this._otherLists.size() + 1 : 1;
    }
}

