/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.list;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.list.IObjectsList;
import com.j_spaces.kernel.list.IScanListIterator;
import com.j_spaces.kernel.list.ScanSingleListIterator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@InternalApi
public class MultiStoredList<T>
implements IScanListIterator<T> {
    private final List<IObjectsList> _multiList;
    private IScanListIterator<T> _current;
    private final boolean _fifoScan;
    private int _posInMultlist = -1;
    private Set _uniqueLists;

    public MultiStoredList() {
        this(null, false);
    }

    public MultiStoredList(List<IObjectsList> multiList, boolean fifoScan) {
        if (multiList == null) {
            this._multiList = new LinkedList<IObjectsList>();
        } else {
            if (multiList.size() > 1) {
                LinkedList<IObjectsList> ml = new LinkedList<IObjectsList>();
                this._uniqueLists = new HashSet();
                for (IObjectsList o : multiList) {
                    if (!this._uniqueLists.add(o)) continue;
                    ml.add(o);
                }
                multiList = ml;
            }
            this._multiList = multiList;
        }
        this._fifoScan = fifoScan;
    }

    public void add(IObjectsList l) {
        if (l == null) {
            return;
        }
        if (this._uniqueLists == null) {
            this._uniqueLists = new HashSet();
            if (!this._multiList.isEmpty()) {
                this._uniqueLists.addAll(this._multiList);
            }
        }
        if (this._uniqueLists.add(l)) {
            this._multiList.add(l);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            while (true) {
                if (this._current == null && this._posInMultlist >= this._multiList.size() - 1) {
                    return false;
                }
                if (this._current != null && this._current.hasNext()) {
                    return true;
                }
                this._current = null;
                if (this._posInMultlist >= this._multiList.size() - 1) continue;
                IObjectsList current = this._multiList.get(++this._posInMultlist);
                this._current = this.prepareListIterator(current);
            }
        }
        catch (SAException sAException) {
            return false;
        }
    }

    @Override
    public T next() {
        T res = null;
        try {
            res = this._current.next();
        }
        catch (SAException sAException) {
            // empty catch block
        }
        return res;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseScan() {
        try {
            if (this._current != null) {
                this._current.releaseScan();
            }
        }
        catch (SAException sAException) {
            // empty catch block
        }
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        return -1;
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    @Override
    public boolean isAlreadyMatched() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return true;
    }

    protected IScanListIterator<T> prepareListIterator(IObjectsList list) {
        return !list.isIterator() ? new ScanSingleListIterator((IStoredList)list, this._fifoScan) : (IScanListIterator)list;
    }

    protected IScanListIterator<T> getCurrentList() {
        return this._current;
    }

    public List<IObjectsList> getAllLists() {
        return this._multiList;
    }

    public int hashCode() {
        if (this._multiList.isEmpty()) {
            return 0;
        }
        int res = Integer.MIN_VALUE;
        for (IObjectsList o : this._multiList) {
            res = res < o.hashCode() ? o.hashCode() : res;
        }
        return res;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiStoredList)) {
            return false;
        }
        MultiStoredList other = (MultiStoredList)o;
        if (this._multiList.size() != other.getAllLists().size()) {
            return false;
        }
        HashSet<IObjectsList> e = new HashSet<IObjectsList>(this._multiList);
        for (IObjectsList l : other.getAllLists()) {
            if (e.contains(o)) continue;
            return false;
        }
        return true;
    }
}

