/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.list;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.IReusableResourcePool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@InternalApi
public class RwlLocksPool
implements IReusableResourcePool<ReadWriteLock> {
    private static AtomicInteger _lockIndex = new AtomicInteger(0);
    private ReadWriteLock[] _locks;

    public RwlLocksPool(int numLocks) {
        this._locks = new ReentrantReadWriteLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this._locks[i] = new ReentrantReadWriteLock();
        }
    }

    @Override
    public ReadWriteLock getResource(int index) {
        return this._locks[index];
    }

    @Override
    public ReadWriteLock getResource() {
        return this._locks[_lockIndex.getAndIncrement() % this.size()];
    }

    @Override
    public int size() {
        return this._locks.length;
    }
}

