/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.list;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.threadlocal.AbstractResource;
import com.gigaspaces.internal.utils.threadlocal.PoolFactory;
import com.gigaspaces.internal.utils.threadlocal.ThreadLocalPool;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IReusableResourcePool;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import com.j_spaces.kernel.SystemProperties;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

@InternalApi
public class RwlSegmentedStoredList<T>
implements IStoredList<T> {
    private final Segment<T>[] _segments;
    private final AtomicInteger _size = new AtomicInteger(0);
    private static final ThreadLocalPool<SegmentedListIterator> _SLHolderPool = new ThreadLocalPool<SegmentedListIterator>(new SegmentedListIteratorFactory());
    private boolean _invalid;
    private int addCounter = 0;
    private int scanCounter = 0;

    public RwlSegmentedStoredList(IReusableResourcePool<ReadWriteLock> locksPool) {
        int numOfSegments = Integer.getInteger("com.gs.engine.storedListSegments", SystemProperties.ENGINE_STORED_LIST_SEGMENTS_DEFAULT);
        if (numOfSegments == 0) {
            numOfSegments = SystemProperties.ENGINE_STORED_LIST_SEGMENTS_DEFAULT;
        }
        this._segments = new Segment[numOfSegments];
        for (int seg = 0; seg < numOfSegments; ++seg) {
            ReadWriteLock rwl = null;
            rwl = locksPool == null ? new ReentrantReadWriteLock() : locksPool.getResource((System.identityHashCode(this) + seg) % locksPool.size());
            this._segments[seg] = new Segment((short)seg, rwl);
        }
    }

    @Override
    public int size() {
        return this._size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectInfo<T> getHead() {
        for (int seg = 0; seg < this.getNumSegments(); ++seg) {
            Segment<T> segment = this._segments[seg];
            ((Segment)segment).getLock().readLock().lock();
            try {
                if (((Segment)segment).isEmpty()) continue;
                ObjectInfo oi = ((ObjectInfo)((Segment)segment).getHead()).getForwardRef();
                while (oi != null) {
                    if (!oi.isDeleted() && oi.getSubject() != null) {
                        ObjectInfo objectInfo = oi;
                        return objectInfo;
                    }
                    oi = oi.getForwardRef();
                }
                continue;
            }
            finally {
                ((Segment)segment).getLock().readLock().unlock();
            }
        }
        return null;
    }

    @Override
    public T getObjectFromHead() {
        IObjectInfo<T> head = this.getHead();
        if (head == null) {
            return null;
        }
        return head.getSubject();
    }

    @Override
    public boolean optimizeScanForSingleObject() {
        return false;
    }

    @Override
    public IStoredListIterator<T> establishListScan(boolean random_scan) {
        if (!random_scan) {
            throw new RuntimeException("RwlSegmentedStoredList:: establishListScan non-random scans not supported");
        }
        SegmentedListIterator slh = _SLHolderPool.get();
        SegmentedListIterator<T> res = this.establishPos(slh);
        if (res == null) {
            slh.release();
        }
        return res;
    }

    private int getNumSegments() {
        return this._segments.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentedListIterator<T> establishPos(SegmentedListIterator<T> res) {
        int startSegment = this.drawSegmentNumber(false);
        res.setStartSegment((short)startSegment);
        int seg = startSegment;
        int i = 0;
        while (i < this.getNumSegments()) {
            if (seg == this.getNumSegments()) {
                seg = 0;
            }
            res.setCurrentSegment((short)seg);
            Segment<T> segment = this._segments[seg];
            ((Segment)segment).getLock().readLock().lock();
            try {
                if (!((Segment)segment).isEmpty()) {
                    ObjectInfo oi = ((ObjectInfo)((Segment)segment).getHead()).getForwardRef();
                    while (oi != null) {
                        if (!oi.isDeleted() && oi.getSubject() != null) {
                            res.setCurrentOI(oi);
                            res.setSubject(oi.getSubject());
                            SegmentedListIterator segmentedListIterator = res;
                            return segmentedListIterator;
                        }
                        oi = oi.getForwardRef();
                    }
                }
            }
            finally {
                ((Segment)segment).getLock().readLock().unlock();
            }
            ++i;
            ++seg;
        }
        return null;
    }

    @Override
    public IStoredListIterator<T> next(IStoredListIterator<T> slh) {
        IStoredListIterator<T> slnext = this.nextPos((SegmentedListIterator)slh);
        if (slnext == null) {
            slh.release();
        }
        return slnext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStoredListIterator<T> nextPos(SegmentedListIterator<T> slh) {
        int startSegment = slh.getCurrentSegment();
        short rootSegment = slh.getStartSegment();
        int seg = startSegment;
        int i = 0;
        while (i < this.getNumSegments()) {
            if (seg == this.getNumSegments()) {
                seg = 0;
            }
            if (i > 0 && rootSegment == seg) {
                return null;
            }
            slh.setCurrentSegment((short)seg);
            Segment<T> segment = this._segments[seg];
            ((Segment)segment).getLock().readLock().lock();
            try {
                if (!((Segment)segment).isEmpty()) {
                    ObjectInfo oi;
                    ObjectInfo objectInfo = oi = seg == startSegment ? ((ObjectInfo)slh.getCurrentOI()).getForwardRef() : ((ObjectInfo)((Segment)segment).getHead()).getForwardRef();
                    while (oi != null) {
                        if (!oi.isDeleted() && oi.getSubject() != null) {
                            slh.setCurrentOI(oi);
                            slh.setSubject(oi.getSubject());
                            SegmentedListIterator segmentedListIterator = slh;
                            return segmentedListIterator;
                        }
                        oi = oi.getForwardRef();
                    }
                }
            }
            finally {
                ((Segment)segment).getLock().readLock().unlock();
            }
            ++i;
            ++seg;
        }
        return null;
    }

    @Override
    public void freeSLHolder(IStoredListIterator<T> slh) {
        if (slh != null) {
            slh.release();
        }
    }

    @Override
    public IObjectInfo<T> add(T subject) {
        return this.addImpl(subject, true);
    }

    @Override
    public IObjectInfo<T> addUnlocked(T subject) {
        return this.addImpl(subject, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectInfo<T> addImpl(T subject, boolean lock) {
        int seg = this.drawSegmentNumber(true);
        Segment<T> segment = this._segments[seg];
        ObjectInfo<T> oi = new ObjectInfo<T>(subject, (short)seg);
        if (lock) {
            ((Segment)segment).getLock().writeLock().lock();
        }
        try {
            IObjectInfo<T> iObjectInfo = this.store_impl(segment, oi);
            return iObjectInfo;
        }
        finally {
            if (lock) {
                ((Segment)segment).getLock().writeLock().unlock();
            }
        }
    }

    protected IObjectInfo<T> store_impl(Segment<T> segment, ObjectInfo<T> oi) {
        if (this._invalid) {
            return null;
        }
        this._size.incrementAndGet();
        ((Segment)segment).incrementSize();
        ObjectInfo tail = ((Segment)segment).getTail();
        tail.setForwardRef((ObjectInfo)oi);
        ((ObjectInfo)oi).setBackwardRef(tail);
        ((Segment)segment).setTail(oi);
        return oi;
    }

    @Override
    public void remove(IObjectInfo<T> poi) {
        this.remove_impl(poi, true);
    }

    @Override
    public void removeUnlocked(IObjectInfo<T> poi) {
        this.remove_impl(poi, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove_impl(IObjectInfo<T> poi, boolean lock) {
        ObjectInfo oi = (ObjectInfo)poi;
        short seg = oi.getSegment();
        Segment<T> segment = this._segments[seg];
        if (lock) {
            ((Segment)segment).getLock().writeLock().lock();
        }
        try {
            this.remove_impl(segment, oi);
        }
        finally {
            if (lock) {
                ((Segment)segment).getLock().writeLock().unlock();
            }
        }
    }

    protected void remove_impl(Segment<T> segment, ObjectInfo<T> oi) {
        if (((ObjectInfo)oi).isDeleted()) {
            throw new RuntimeException(" Stored list- called remove but element already deleted !");
        }
        if (((Segment)segment).getSize() == 0) {
            throw new RuntimeException(" Stored list- called remove but list is empty !");
        }
        oi.setSubject(null);
        if (((ObjectInfo)oi).getForwardRef() != null) {
            ((ObjectInfo)((ObjectInfo)oi).getForwardRef()).setBackwardRef((ObjectInfo)((ObjectInfo)oi).getBackwardRef());
        }
        if (((ObjectInfo)oi).getBackwardRef() != null) {
            ((ObjectInfo)((ObjectInfo)oi).getBackwardRef()).setForwardRef((ObjectInfo)((ObjectInfo)oi).getForwardRef());
        }
        if (((Segment)segment).getTail() == oi) {
            ((Segment)segment).setTail(((ObjectInfo)oi).getBackwardRef());
        }
        ((Segment)segment).decrementSize();
        this._size.decrementAndGet();
        ((ObjectInfo)oi).setDeleted();
    }

    @Override
    public boolean removeByObject(T obj) {
        throw new RuntimeException("RwlSegmentedStoredList::removeByObject not supported");
    }

    @Override
    public boolean contains(T obj) {
        throw new RuntimeException("RwlSegmentedStoredList::contains not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invalidate() {
        int lastSegmentLocked = -1;
        try {
            for (int i = 0; i < this.getNumSegments(); ++i) {
                ((Segment)this._segments[i]).getLock().readLock().lock();
                lastSegmentLocked = i;
                if (((Segment)this._segments[i]).getSize() <= 0) continue;
                boolean bl = false;
                return bl;
            }
            this._invalid = true;
            boolean bl = true;
            return bl;
        }
        finally {
            for (int i = lastSegmentLocked; i >= 0; --i) {
                ((Segment)this._segments[i]).getLock().readLock().unlock();
            }
        }
    }

    private int drawSegmentNumber(boolean add) {
        int tnum = (int)Thread.currentThread().getId();
        if (tnum % this.getNumSegments() == 0) {
            ++tnum;
        }
        return add ? Math.abs(tnum * this.addCounter++ % this.getNumSegments()) : Math.abs(tnum * this.scanCounter++ % this.getNumSegments());
    }

    @Override
    public boolean isMultiObjectCollection() {
        return true;
    }

    @Override
    public boolean isIterator() {
        return false;
    }

    @Override
    public void dump(Logger logger, String msg) {
    }

    @Override
    public int getHashCode(int id) {
        throw new RuntimeException(" unsupported");
    }

    @Override
    public Object getKey(int id) {
        throw new RuntimeException(" unsupported");
    }

    @Override
    public IStoredList<T> getValue(int id) {
        throw new RuntimeException(" unsupported");
    }

    @Override
    public boolean isNativeHashEntry() {
        return false;
    }

    static final class SegmentedListIterator<T>
    extends AbstractResource
    implements IStoredListIterator<T> {
        private ObjectInfo<T> _currentOI;
        private T _subject;
        private short _startSegment;
        private short _currentSegment;
        private int _scanLimit;

        public SegmentedListIterator() {
        }

        public SegmentedListIterator(short startSegment, ObjectInfo<T> oi, T obj, int slimit) {
            this.setCurrentOI(oi);
            this.setSubject(obj);
            this.setScanLimit(slimit);
            this.setStartSegment(startSegment);
            this.setCurrentSegment(startSegment);
        }

        @Override
        protected void clean() {
            this.setCurrentOI(null);
            this.setSubject(null);
            this.setScanLimit(0);
            this.setStartSegment((short)0);
            this.setCurrentSegment((short)0);
        }

        void setCurrentOI(ObjectInfo<T> currentOI) {
            this._currentOI = currentOI;
        }

        ObjectInfo<T> getCurrentOI() {
            return this._currentOI;
        }

        void setCurrentSegment(short currentSegment) {
            this._currentSegment = currentSegment;
        }

        short getCurrentSegment() {
            return this._currentSegment;
        }

        void setStartSegment(short segment) {
            this._startSegment = segment;
        }

        short getStartSegment() {
            return this._startSegment;
        }

        @Override
        public void setSubject(T subject) {
            this._subject = subject;
        }

        @Override
        public T getSubject() {
            return this._subject;
        }

        private int setScanLimit(int scanLimit) {
            this._scanLimit = scanLimit;
            return this._scanLimit;
        }

        public int getScanLimit() {
            return this._scanLimit;
        }
    }

    private static class SegmentedListIteratorFactory
    implements PoolFactory<SegmentedListIterator> {
        private SegmentedListIteratorFactory() {
        }

        @Override
        public SegmentedListIterator create() {
            return new SegmentedListIterator();
        }
    }

    private static class ObjectInfo<T>
    implements Serializable,
    IObjectInfo<T> {
        private static final long serialVersionUID = -7542847245404958608L;
        private ObjectInfo<T> _forward;
        private ObjectInfo<T> _backward;
        private short _segment;
        private T _subject;
        private boolean _deleted;

        public ObjectInfo(T subject, short segment) {
            this.setSubject(subject);
            this.setSegment(segment);
        }

        @Override
        public void setSubject(T subject) {
            this._subject = subject;
        }

        @Override
        public T getSubject() {
            return this._subject;
        }

        private void setForwardRef(ObjectInfo<T> forward) {
            this._forward = forward;
        }

        private ObjectInfo<T> getForwardRef() {
            return this._forward;
        }

        private void setBackwardRef(ObjectInfo<T> backward) {
            this._backward = backward;
        }

        private ObjectInfo<T> getBackwardRef() {
            return this._backward;
        }

        private void setSegment(short segment) {
            this._segment = segment;
        }

        private short getSegment() {
            return this._segment;
        }

        private void setDeleted() {
            this._deleted = true;
        }

        private boolean isDeleted() {
            return this._deleted;
        }
    }

    private static final class Segment<T>
    extends ObjectInfo<T> {
        private static final long serialVersionUID = -5172326325174158826L;
        private final ObjectInfo<T> _head;
        private ObjectInfo<T> _tail;
        private volatile int _size;
        private final ReadWriteLock _lock;

        Segment(short seg, ReadWriteLock lock) {
            super(null, seg);
            this._lock = lock;
            this._tail = this._head = this;
        }

        private ObjectInfo<T> getHead() {
            return this._head;
        }

        private ObjectInfo<T> getTail() {
            return this._tail;
        }

        private void setTail(ObjectInfo<T> oi) {
            this._tail = oi;
        }

        private int getSize() {
            return this._size;
        }

        private int incrementSize() {
            return ++this._size;
        }

        private int decrementSize() {
            return --this._size;
        }

        private boolean isEmpty() {
            return ((ObjectInfo)this._head).getForwardRef() == null;
        }

        private ReadWriteLock getLock() {
            return this._lock;
        }
    }
}

