/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.list;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import com.j_spaces.kernel.list.IScanListIterator;

@InternalApi
public class ScanSingleListIterator<T>
implements IScanListIterator<T> {
    private IStoredList<T> _list;
    private T _nextObj;
    private boolean _singleObjectResult;
    private boolean _gotFirst;
    private IStoredListIterator<T> _pos;
    private final boolean _fifoScan;

    public ScanSingleListIterator(IStoredList<T> list, boolean fifoScan) {
        this._list = list;
        this._fifoScan = fifoScan;
    }

    @Override
    public boolean hasNext() {
        if (this._gotFirst && this._singleObjectResult) {
            return false;
        }
        if (!this._gotFirst) {
            if (this._list.isMultiObjectCollection()) {
                if (this._list.optimizeScanForSingleObject()) {
                    this._singleObjectResult = true;
                    this._nextObj = this._list.getObjectFromHead();
                } else {
                    this._pos = this._list.establishListScan(!this._fifoScan);
                    this._nextObj = this.getNext();
                }
            } else {
                this._singleObjectResult = true;
                this._nextObj = this._list;
            }
            this._gotFirst = true;
        } else {
            this._pos = this._list.next(this._pos);
            this._nextObj = this.getNext();
        }
        return this._nextObj != null;
    }

    private T getNext() {
        while (this._pos != null) {
            T nextObj = this._pos.getSubject();
            if (nextObj != null) {
                return nextObj;
            }
            this._pos = this._list.next(this._pos);
        }
        return null;
    }

    @Override
    public T next() {
        return this._nextObj;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseScan() {
        if (!this._singleObjectResult && this._pos != null) {
            this._list.freeSLHolder(this._pos);
        }
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        return -1;
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    @Override
    public boolean isAlreadyMatched() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return true;
    }

    public void reuse(IStoredList<T> list) {
        this.clean();
        this._list = list;
    }

    private void clean() {
        this._list = null;
        this._nextObj = null;
        this._singleObjectResult = false;
        this._gotFirst = false;
        this._pos = null;
    }
}

