/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.list;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.list.IScanListIterator;
import java.util.Set;

@InternalApi
public class ScanUidsIterator
implements IScanListIterator<IEntryCacheInfo> {
    private static final int WEIGHT_GT_1 = 5;
    private Object[] _uids;
    private int _nextPos;
    private CacheManager _cacheManager;
    private IEntryCacheInfo _subject;

    public ScanUidsIterator(CacheManager cacheManager, Set<String> uids) {
        this._uids = uids.toArray();
        this._cacheManager = cacheManager;
    }

    @Override
    public boolean hasNext() {
        while (this._nextPos < this._uids.length) {
            this._subject = this._cacheManager.getPEntryByUid((String)this._uids[this._nextPos++]);
            if (this._subject == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public IEntryCacheInfo next() {
        IEntryCacheInfo res = this._subject;
        this._subject = null;
        return res;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseScan() {
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        return -1;
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    @Override
    public boolean isAlreadyMatched() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return true;
    }

    public void reuse(IStoredList<IEntryCacheInfo> list) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this._uids.length > 1 ? (this._uids.length - 1) * 5 + 1 : this._uids.length;
    }
}

