/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.list;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.UncheckedAtomicReferenceFieldUpdater;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.list.ConcurrentStoredList;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

@InternalApi
public class StoredListChainSegment<T> {
    private final ConcurrentSLObjectInfo<T> _tail;
    private final ConcurrentSLObjectInfo<T> _head;
    private int _iterCount;
    private final short _segment;
    private static final byte SUPPORT_FIFO = 1;
    private static final byte PADDED = 2;
    private final byte _flags;
    private final byte _healthCheck;

    StoredListChainSegment(short segment, boolean supportFifo, boolean padded) {
        this._segment = segment;
        if (padded) {
            this._tail = new ConcurrentSLObjectInfoPadded<Object>(null, this._segment, null, null, 0);
            this._head = new ConcurrentSLObjectInfoPadded<Object>(null, this._segment, this._tail, null, 0);
        } else {
            this._tail = new ConcurrentSLObjectInfo<Object>(null, this._segment, null, null, 0);
            this._head = new ConcurrentSLObjectInfo<Object>(null, this._segment, this._tail, null, 0);
        }
        this._tail.setFwd(this._head);
        this._tail.nodeInsertionEnded();
        this._head.nodeInsertionEnded();
        byte flags = 0;
        if (supportFifo) {
            flags = (byte)(flags | 1);
        }
        if (padded) {
            flags = (byte)(flags | 2);
        }
        this._flags = flags;
        this._healthCheck = (byte)System.identityHashCode(this);
    }

    public boolean isSupportFifo() {
        return (this._flags & 1) == 1;
    }

    private ConcurrentSLObjectInfo insert(T entry) {
        ConcurrentSLObjectInfo<T> newnode = new ConcurrentSLObjectInfo<T>(entry, this._segment, this._tail, null, this._healthCheck);
        this.insertNode(newnode);
        return newnode;
    }

    private void insertNode(ConcurrentSLObjectInfo newnode) {
        ConcurrentSLObjectInfo cur_first;
        do {
            cur_first = this._tail.getFwd();
            newnode.setFwd(cur_first);
        } while (!this._tail.CAS_forward(cur_first, newnode));
        if (this.isSupportFifo() && cur_first != this._head && cur_first.getFwd().getBwd() == this._tail) {
            this.adjustInsertsPtrs(cur_first);
        }
        cur_first.setBwd(newnode);
        if (cur_first.isNodeRemoved()) {
            this.disconnect_node(cur_first);
        }
        newnode.nodeInsertionEnded();
    }

    private void adjustInsertsPtrs(ConcurrentSLObjectInfo cur_first) {
        ArrayList<ConcurrentSLObjectInfo> nodes = null;
        for (ConcurrentSLObjectInfo base = cur_first.getFwd(); base != null && base.getBwd() == this._tail; base = base.getFwd()) {
            if (nodes == null) {
                nodes = new ArrayList<ConcurrentSLObjectInfo>();
                nodes.add(cur_first);
            }
            nodes.add(base);
        }
        if (nodes == null || nodes.size() == 1) {
            return;
        }
        for (int i = nodes.size() - 1; i >= 1; --i) {
            ConcurrentSLObjectInfo nodeToMend = (ConcurrentSLObjectInfo)nodes.get(i);
            ConcurrentSLObjectInfo toPointTo = (ConcurrentSLObjectInfo)nodes.get(i - 1);
            if (nodeToMend.getBwd() != this._tail) continue;
            nodeToMend.CAS_backward(this._tail, toPointTo);
        }
    }

    private void removeNode(ConcurrentSLObjectInfo nodetodelete, boolean unlocked) {
        if (nodetodelete.getHealthCheck() != this._healthCheck) {
            throw new IllegalStateException("Object was changed without explicitly calling the space api. XAP doesn't clone the objects for performance reasons, so if you want to change an object in the code that runs on the space, please make sure you clone the object before the change.");
        }
        nodetodelete.setNodeRemoved(true);
        if (unlocked) {
            this.disconnect_node_unlocked(nodetodelete);
        } else {
            this.disconnect_node(nodetodelete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean disconnect_node(ConcurrentSLObjectInfo nodetodrop) {
        if (nodetodrop.isDisconnected() || nodetodrop.getBwd() == this._tail) {
            return true;
        }
        ConcurrentSLObjectInfo concurrentSLObjectInfo = nodetodrop;
        synchronized (concurrentSLObjectInfo) {
            if (nodetodrop.isDisconnected() || nodetodrop.getBwd() == this._tail) {
                return true;
            }
            while (true) {
                ConcurrentSLObjectInfo prev = nodetodrop.getFwd();
                ConcurrentSLObjectInfo mybackward = nodetodrop.getBwd();
                ConcurrentSLObjectInfo concurrentSLObjectInfo2 = prev;
                synchronized (concurrentSLObjectInfo2) {
                    if (prev == nodetodrop.getFwd()) {
                        prev.setBwd(mybackward);
                        mybackward.setFwd(prev);
                        // MONITOREXIT @DISABLED, blocks:[2, 3, 4, 5] lbl16 : MonitorExitStatement: MONITOREXIT : var5_5
                        nodetodrop.setDisconnected();
                        return true;
                    }
                }
            }
        }
    }

    private boolean disconnect_node_unlocked(ConcurrentSLObjectInfo nodetodrop) {
        if (nodetodrop.isDisconnected() || nodetodrop.getBwd() == this._tail) {
            return true;
        }
        ConcurrentSLObjectInfo prev = nodetodrop.getFwd();
        ConcurrentSLObjectInfo mybackward = nodetodrop.getBwd();
        prev.setBwd(mybackward);
        mybackward.setFwd(prev);
        nodetodrop.setDisconnected();
        return true;
    }

    public IObjectInfo<T> getHead() {
        ConcurrentSLObjectInfo node = this._head.getBwd();
        if (node == this._tail || !node.isNodeInserted()) {
            return null;
        }
        return node;
    }

    public T getObjectFromHead() {
        IObjectInfo<T> node = this.getHead();
        return node != null ? (T)node.getSubject() : null;
    }

    public void remove(IObjectInfo<T> oi) {
        this.removeNode((ConcurrentSLObjectInfo)oi, false);
        oi.setSubject(null);
    }

    public void removeUnlocked(IObjectInfo<T> oi) {
        this.removeNode((ConcurrentSLObjectInfo)oi, true);
    }

    public boolean removeByObject(T obj) {
        return this.removeByObject_impl(obj);
    }

    private boolean removeByObject_impl(T obj) {
        for (ConcurrentSLObjectInfo baseb = this._tail.getFwd(); baseb != null && baseb != this._head; baseb = baseb.getFwd()) {
            Object other;
            if (baseb.isNodeRemoved() || (other = baseb.getSubject()) == null || !other.equals(obj)) continue;
            this.remove(baseb);
            return true;
        }
        return false;
    }

    public IObjectInfo<T> add(T subject) {
        return this.insert(subject);
    }

    public void monitor() {
        ConcurrentSLObjectInfo myf;
        ConcurrentSLObjectInfo myforward;
        int itersf = 0;
        int itersb = 0;
        int nonbalancedf = 0;
        int nonbalancedb = 0;
        int deletedf = 0;
        int deletedb = 0;
        int deletedInsidef = 0;
        int deletedInsideb = 0;
        for (ConcurrentSLObjectInfo basef = this._head; basef != null; basef = basef.getBwd()) {
            ++itersf;
            if (basef.isNodeRemoved()) {
                ++deletedf;
                continue;
            }
            if (basef != this._head) {
                myforward = basef.forwardRef;
                if (myforward.isNodeRemoved() && basef != this._tail) {
                    ++deletedInsidef;
                    continue;
                }
                if (myforward.backwardRef != basef) {
                    ++nonbalancedf;
                    continue;
                }
            }
            if (basef == this._tail) continue;
            myf = basef.backwardRef;
            if (myf.isNodeRemoved() && myf.getBwd() != this._tail) {
                ++deletedInsidef;
                continue;
            }
            if (myf.forwardRef == basef) continue;
            ++nonbalancedf;
        }
        for (ConcurrentSLObjectInfo baseb = this._tail; baseb != null; baseb = baseb.getFwd()) {
            ++itersb;
            if (baseb.isNodeRemoved()) {
                ++deletedb;
                continue;
            }
            if (baseb != this._head) {
                myforward = baseb.forwardRef;
                if (myforward.isNodeRemoved() && baseb != this._tail) {
                    ++deletedInsideb;
                    continue;
                }
                if (myforward.backwardRef != baseb) {
                    ++nonbalancedb;
                    continue;
                }
            }
            if (baseb == this._tail) continue;
            myf = baseb.backwardRef;
            if (myf.isNodeRemoved() && myf.getBwd() != this._tail) {
                ++deletedInsidef;
                continue;
            }
            if (myf.forwardRef == baseb) continue;
            ++nonbalancedb;
        }
        System.out.println("Seg= " + this._segment + " itersf=" + itersf + " itersb=" + itersb + " nonbalancedf=" + nonbalancedf + " nonbalancedb=" + nonbalancedb + " deletedf=" + deletedf + " deletedb=" + deletedb + " deletedInsidef=" + deletedInsidef + " deletedInsideb=" + deletedInsideb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean establishIterScanPos(ConcurrentStoredList.SegmentedListIterator<T> iter) {
        boolean scanDown = this.isSupportFifo();
        if (this.isSupportFifo() && iter._randomScan) {
            scanDown = ++this._iterCount % 2 != 0;
        }
        try {
            iter._cur = null;
            iter._curElement = null;
            iter._currSegmentScanCount = iter._scanLimit;
            iter._headToTail = scanDown;
            this.next(iter);
            boolean bl = iter._curElement != null;
            return bl;
        }
        finally {
            if (iter._curElement == null) {
                iter._cur = null;
            }
        }
    }

    public boolean iterNext(ConcurrentStoredList.SegmentedListIterator<T> iter) {
        try {
            if (iter._cur == null) {
                boolean bl = false;
                return bl;
            }
            this.next(iter);
            boolean bl = iter._curElement != null;
            return bl;
        }
        finally {
            if (iter._curElement == null) {
                iter._cur = null;
            }
        }
    }

    private void next(ConcurrentStoredList.SegmentedListIterator<T> iter) {
        iter._curElement = null;
        if (iter._currSegmentScanCount < 0) {
            return;
        }
        if (iter._headToTail) {
            this.next_down(iter);
        } else {
            this.next_up(iter);
        }
    }

    private void next_down(ConcurrentStoredList.SegmentedListIterator<T> iter) {
        if (iter._cur == this._tail) {
            return;
        }
        if (iter._cur == null) {
            iter._cur = this._head;
        }
        do {
            iter._cur = iter._cur.getBwd();
            if (iter._cur == this._tail) {
                return;
            }
            --iter._currSegmentScanCount;
            if (!iter._cur.isNodeInserted()) continue;
            iter._curElement = iter._cur;
            return;
        } while (iter._currSegmentScanCount >= 0);
    }

    private void next_up(ConcurrentStoredList.SegmentedListIterator<T> iter) {
        if (iter._cur == this._head) {
            return;
        }
        if (iter._cur == null) {
            iter._cur = this._tail;
        }
        do {
            iter._cur = iter._cur.getFwd();
            if (iter._cur == this._head) {
                return;
            }
            --iter._currSegmentScanCount;
            if (!iter._cur.isNodeInserted()) continue;
            iter._curElement = iter._cur;
            return;
        } while (iter._currSegmentScanCount >= 0);
    }

    static class ConcurrentSLObjectInfoPadded<T>
    extends ConcurrentSLObjectInfo<T> {
        long p1;
        long p2;
        long p3;
        long p4;
        long p5;
        long p6;
        long p7;
        long p8;

        public ConcurrentSLObjectInfoPadded(T subject, short segment, ConcurrentSLObjectInfo backward, ConcurrentSLObjectInfo forward, byte healthCheck) {
            super(subject, segment, backward, forward, healthCheck);
        }
    }

    static class ConcurrentSLObjectInfo<T>
    implements IObjectInfo<T> {
        private T _data;
        private volatile ConcurrentSLObjectInfo backwardRef;
        private volatile ConcurrentSLObjectInfo forwardRef;
        private static final AtomicReferenceFieldUpdater<ConcurrentSLObjectInfo, ConcurrentSLObjectInfo> forwardUpdater = UncheckedAtomicReferenceFieldUpdater.newUpdater(ConcurrentSLObjectInfo.class, ConcurrentSLObjectInfo.class, "forwardRef");
        private static final AtomicReferenceFieldUpdater<ConcurrentSLObjectInfo, ConcurrentSLObjectInfo> backwardUpdater = UncheckedAtomicReferenceFieldUpdater.newUpdater(ConcurrentSLObjectInfo.class, ConcurrentSLObjectInfo.class, "backwardRef");
        private final short _segment;
        public static final byte inserting = 0;
        public static final byte inserted = 1;
        public static final byte removed = 2;
        public static final byte disconnected = 3;
        volatile byte _infoStatus = 0;
        private final byte _healthCheck;

        public ConcurrentSLObjectInfo(T subject, short segment, ConcurrentSLObjectInfo backward, ConcurrentSLObjectInfo forward, byte healthCheck) {
            this.setSubject(subject);
            this._segment = segment;
            if (backward != null) {
                this.backwardRef = backward;
            }
            if (forward != null) {
                this.forwardRef = forward;
            }
            this._healthCheck = healthCheck;
        }

        @Override
        public void setSubject(T subject) {
            this._data = subject;
        }

        @Override
        public T getSubject() {
            return this._data;
        }

        public short getSegment() {
            return this._segment;
        }

        boolean CAS_forward(ConcurrentSLObjectInfo expect, ConcurrentSLObjectInfo update) {
            return forwardUpdater.compareAndSet(this, expect, update);
        }

        boolean CAS_backward(ConcurrentSLObjectInfo expect, ConcurrentSLObjectInfo update) {
            return backwardUpdater.compareAndSet(this, expect, update);
        }

        void setBwd(ConcurrentSLObjectInfo update) {
            this.backwardRef = update;
        }

        void setFwd(ConcurrentSLObjectInfo update) {
            this.forwardRef = update;
        }

        ConcurrentSLObjectInfo getBwd() {
            return this.backwardRef;
        }

        ConcurrentSLObjectInfo getFwd() {
            return this.forwardRef;
        }

        void setNodeRemoved(boolean verify) {
            byte status;
            if (verify && (status = this._infoStatus) != 1) {
                throw new RuntimeException("StoredListChainSegment:setNodeRemoved remove and node status =" + status);
            }
            this._infoStatus = (byte)2;
        }

        boolean isNodeRemoved() {
            byte status = this._infoStatus;
            return status == 2 || status == 3;
        }

        boolean isNodeInserted() {
            return this._infoStatus == 1;
        }

        void nodeInsertionEnded() {
            this._infoStatus = 1;
        }

        boolean isDisconnected() {
            return this._infoStatus == 3;
        }

        void setDisconnected() {
            this._infoStatus = (byte)3;
        }

        byte getHealthCheck() {
            return this._healthCheck;
        }
    }
}

