/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.locks;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.j_spaces.kernel.locks.IBasicLockManager;
import com.j_spaces.kernel.locks.ILockObject;
import com.j_spaces.kernel.locks.ISelfLockingSubject;

@InternalApi
public class BasicEvictableLockManager<T extends ISelfLockingSubject>
implements IBasicLockManager<T> {
    private final LockObject[] _locks;

    public BasicEvictableLockManager(SpaceConfigReader configReader) {
        int size = configReader.getIntSpaceProperty("engine.EvictableLocksSize", "2000");
        this._locks = new LockObject[size];
        for (int i = 0; i < size; ++i) {
            this._locks[i] = new LockObject();
        }
    }

    @Override
    public ILockObject getLockObject(T subject) {
        return this.getLockObject_impl(subject.getUID());
    }

    @Override
    public ILockObject getLockObject(T subject, boolean isEvictable) {
        if (!isEvictable) {
            return subject;
        }
        return this.getLockObject_impl(subject.getUID());
    }

    @Override
    public ILockObject getLockObject(String subjectUid) {
        return this.getLockObject_impl(subjectUid);
    }

    private ILockObject getLockObject_impl(String subjectUid) {
        return this._locks[Math.abs(subjectUid.hashCode() % this._locks.length)];
    }

    @Override
    public void freeLockObject(ILockObject lockObject) {
    }

    @Override
    public boolean isPerLogicalSubjectLockObject(boolean isEvictable) {
        return !isEvictable;
    }

    private static class LockObject
    implements ILockObject {
        private LockObject() {
        }

        @Override
        public boolean isLockSubject() {
            return false;
        }
    }
}

