/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.locks;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.locks.IEvictableLockObject;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class EvictableLockObject
extends AtomicInteger
implements IEvictableLockObject {
    private static final long serialVersionUID = -8146971271147493645L;
    private String _uid;
    private boolean _evictionIndicator;

    public EvictableLockObject(String uid) {
        this(uid, false);
    }

    public EvictableLockObject(String uid, boolean evictionIndicator) {
        super(1);
        this._uid = uid;
        this._evictionIndicator = evictionIndicator;
    }

    @Override
    public String getUID() {
        return this._uid;
    }

    @Override
    public boolean isLockSubject() {
        return false;
    }

    @Override
    public boolean isEvictionPermissionIndicator() {
        return this._evictionIndicator;
    }

    @Override
    public int getNumOfUsers() {
        return this.get();
    }

    @Override
    public boolean incrementNumOfUsersIfNotEmpty() {
        int num;
        do {
            if ((num = this.get()) != 0) continue;
            return false;
        } while (!this.compareAndSet(num, num + 1));
        return true;
    }

    @Override
    public boolean decrementNumOfUsersAndIndicateEmpty() {
        int val = this.decrementAndGet();
        return val == 0;
    }

    @Override
    public int getNumOfUsersAndEmpty() {
        return this.getAndSet(0);
    }

    public IEvictableLockObject getEvictableLockObject() {
        return this;
    }
}

