/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.log;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.io.XmlUtils;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.SpaceInitializationException;
import com.j_spaces.core.exception.SpaceConfigurationException;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@InternalApi
public class JProperties {
    private static Map<String, Properties> _containerPropertiesMap = new HashMap<String, Properties>();
    private static final Properties spaceProperties = new Properties();
    private static Properties m_customProperties;
    private static final Map<String, Properties> m_spaceProperties;
    private static String m_sUri;
    private static final Hashtable<String, String> m_UrlTable;
    private static HashMap<String, JSpaceAttributes> dCacheConfigFilesMap;

    private JProperties() {
    }

    public static void setURL(String containerName, String uriName) throws SAXException, ParserConfigurationException, IOException {
        m_sUri = uriName;
        JProperties.reload(containerName, null, null);
    }

    public static void setInputStream(String containerName, InputStream is, Properties customProps) throws SAXException, ParserConfigurationException, IOException {
        JProperties.reload(containerName, is, customProps);
    }

    public static synchronized JSpaceAttributes loadConfigDCache(String fileName) throws SpaceConfigurationException, IOException, SAXException, ParserConfigurationException {
        InputStream dCacheInputStream;
        JSpaceAttributes prop = dCacheConfigFilesMap.get(fileName);
        if (prop == null && (dCacheInputStream = ResourceLoader.findConfigDCache(fileName)) != null) {
            prop = (JSpaceAttributes)JProperties.convertXML(dCacheInputStream);
            dCacheConfigFilesMap.put(fileName, prop);
        }
        return (JSpaceAttributes)prop.clone();
    }

    public static void setUrlWithSchema(String fullSpaceName, Properties customProperties, InputStream is) throws SAXException, ParserConfigurationException, IOException {
        m_customProperties = customProperties;
        DocumentBuilder docBuilder = XmlUtils.getDocumentBuilder();
        Document doc = docBuilder.parse(is);
        Element root = doc.getDocumentElement();
        if (spaceProperties.isEmpty()) {
            JProperties.convertXMLtoProperty(root, spaceProperties, false);
        }
        Element spaceNameNode = doc.createElement(fullSpaceName);
        spaceNameNode.appendChild(root);
        JSpaceAttributes sp = new JSpaceAttributes();
        JProperties.convertXMLtoProperty(spaceNameNode, sp, false);
        JProperties.convertCustomSpacePropsToJProperties(fullSpaceName, customProperties, sp);
        String configFileName = sp.getProperty(fullSpaceName + "." + "space-config." + "dist-cache.config-name");
        JSpaceAttributes dCacheProperties = JProperties.loadConfigDCache(configFileName);
        JProperties.convertCustomSpacePropsToJProperties(null, customProperties, dCacheProperties);
        sp.setDCacheProperties(dCacheProperties);
        sp.setDCacheConfigName(configFileName);
        m_spaceProperties.put(fullSpaceName, sp);
    }

    public static void setUrlWithoutSchema(String fullSpaceName, Properties customProperties, String urlName) throws SAXException, ParserConfigurationException, IOException {
        m_customProperties = customProperties;
        JSpaceAttributes sp = JProperties.convertXML(urlName, false);
        JProperties.convertCustomSpacePropsToJProperties(fullSpaceName, customProperties, sp);
        sp.setDCacheProperties(sp);
        sp.setDCacheConfigName(null);
        m_spaceProperties.put(fullSpaceName, sp);
        m_UrlTable.put(fullSpaceName, urlName);
    }

    public static String getAllSpacesPropertiesDump() {
        StringBuilder sb = new StringBuilder();
        if (m_spaceProperties != null) {
            Set<String> spacesSet = m_spaceProperties.keySet();
            sb.append("\n\n==============================================================================================\n");
            sb.append("Spaces configuration elements used by the system\n");
            sb.append("\n---------------------------------------------------------------------------------------- \n\n");
            for (String spaceNameKey : spacesSet) {
                sb.append("\n---------------------------------------------------------------------------------------- \n");
                sb.append("Space configuration elements for space < ");
                sb.append(spaceNameKey);
                sb.append(" >");
                sb.append("\n---------------------------------------------------------------------------------------- \n\n");
                StringUtils.appendProperties(sb, m_spaceProperties.get(spaceNameKey));
            }
        }
        return sb.toString();
    }

    public static String getContainerPropertiesDump(String containerName) {
        StringBuilder dumpInfo = new StringBuilder();
        Properties m_properties = _containerPropertiesMap.get(containerName);
        if (m_properties != null) {
            dumpInfo.append("\n\n==============================================================================================\n");
            dumpInfo.append("Container configuration elements for container < " + m_properties.getProperty("com.j_spaces.core.container.name") + " >\n");
            dumpInfo.append("\n---------------------------------------------------------------------------------------- \n\n");
            Enumeration<?> e = m_properties.propertyNames();
            while (e.hasMoreElements()) {
                String propValue;
                String contPropKey = (String)e.nextElement();
                String resolvedPropertyValue = propValue = m_properties.getProperty(contPropKey);
                if (propValue.equalsIgnoreCase("${com.gs.start-embedded-lus}")) {
                    resolvedPropertyValue = JProperties.getPropertyFromSystem(propValue, "true");
                } else if (propValue.equalsIgnoreCase("${com.gs.start-embedded-mahalo}")) {
                    resolvedPropertyValue = JProperties.getPropertyFromSystem(propValue, "false");
                } else if (propValue.equalsIgnoreCase("${com.gs.jini_lus.groups}")) {
                    resolvedPropertyValue = JProperties.getPropertyFromSystem(propValue, SystemInfo.singleton().lookup().defaultGroups());
                } else if (propValue.equalsIgnoreCase("${com.gs.shutdown_hook}")) {
                    resolvedPropertyValue = JProperties.getPropertyFromSystem(propValue, "true");
                } else if (propValue.equalsIgnoreCase("${com.gs.jndi.url}")) {
                    resolvedPropertyValue = JProperties.getPropertyFromSystem(propValue, "localhost:10098");
                } else if (propValue.equalsIgnoreCase("${com.gs.jini_lus.unicast_discovery.enabled}")) {
                    resolvedPropertyValue = JProperties.getPropertyFromSystem(propValue, "false");
                } else if (propValue.equalsIgnoreCase("${com.gs.jini_lus.locators}")) {
                    resolvedPropertyValue = JProperties.getPropertyFromSystem(propValue, "");
                } else if (propValue.equalsIgnoreCase("${com.gs.time-provider}")) {
                    resolvedPropertyValue = JProperties.getPropertyFromSystem(propValue);
                } else if (propValue.equalsIgnoreCase("${com.gs.jms.enabled}")) {
                    resolvedPropertyValue = JProperties.getPropertyFromSystem(propValue, "false");
                } else if (propValue.equalsIgnoreCase("${com.gs.protocol}")) {
                    resolvedPropertyValue = JProperties.getPropertyFromSystem(propValue, "NIO");
                }
                dumpInfo.append("\n\t XPath element key: " + contPropKey);
                dumpInfo.append("\n\t Value: " + propValue);
                if (!resolvedPropertyValue.equalsIgnoreCase(propValue)) {
                    dumpInfo.append("\n\t Default value is set to: " + resolvedPropertyValue);
                }
                dumpInfo.append("\n");
            }
        }
        return dumpInfo.toString();
    }

    public static void convertCustomSpacePropsToJProperties(String spaceName, Properties customProps, JSpaceAttributes spaceAttrib) {
        if (customProps != null) {
            Enumeration<?> e = customProps.propertyNames();
            while (e.hasMoreElements()) {
                String spacePropKey;
                String propName = (String)e.nextElement();
                String propValue = customProps.getProperty(propName);
                String string = spacePropKey = spaceName == null ? propName : spaceName + "." + propName;
                if (!propName.startsWith("space-config.")) continue;
                spaceAttrib.setProperty(spacePropKey, propValue);
            }
        }
    }

    private static void convertCustomContainerPropsToJProperties(Properties customProps, JSpaceAttributes spaceAttrib) {
        if (customProps != null) {
            Enumeration<?> e = customProps.propertyNames();
            while (e.hasMoreElements()) {
                String contPropKey = (String)e.nextElement();
                String propValue = customProps.getProperty(contPropKey);
                if (contPropKey.startsWith("space-config.")) continue;
                spaceAttrib.setProperty(contPropKey, propValue);
            }
        }
    }

    public static String getURL() {
        return m_sUri;
    }

    public static String getURL(String fullSpaceName) {
        return m_UrlTable.get(fullSpaceName);
    }

    public static void removeSpaceProperties(String fullSpaceName) {
        m_UrlTable.remove(fullSpaceName);
        m_spaceProperties.remove(fullSpaceName);
    }

    private static void reload(String containerName, InputStream is, Properties customProps) throws SAXException, ParserConfigurationException, IOException {
        m_customProperties = customProps;
        JSpaceAttributes m_properties = is != null ? JProperties.convertXML(is, false, customProps) : JProperties.convertXML(m_sUri, false);
        _containerPropertiesMap.put(containerName, m_properties);
    }

    public static Properties getContainerProperties(String containerName) {
        return _containerPropertiesMap.get(containerName);
    }

    public static String getContainerProperty(String containerName, String key, String defaultValue) {
        return JProperties.getContainerProperty(containerName, key, defaultValue, true);
    }

    public static String getContainerProperty(String containerName, String key, String defaultValue, boolean convert) {
        Properties m_properties = null;
        if (containerName != null) {
            m_properties = _containerPropertiesMap.get(containerName);
        } else if (key.equals("com.j_spaces.kernel.time-provider")) {
            if (_containerPropertiesMap.size() == 0) {
                return defaultValue;
            }
            Collection<Properties> values = _containerPropertiesMap.values();
            m_properties = values.iterator().next();
        }
        if (m_properties == null) {
            return null;
        }
        String result = m_properties.getProperty(key, defaultValue);
        return convert ? JProperties.getPropertyFromSystem(result, defaultValue) : result;
    }

    public static boolean containsSpaceProperty(String fullSpaceName, String key) {
        Properties sp = m_spaceProperties.get(fullSpaceName);
        if (sp != null) {
            if (sp.containsKey(fullSpaceName + "." + "space-config." + key)) {
                return true;
            }
            if (sp.containsKey("space-config." + key)) {
                return true;
            }
        }
        return false;
    }

    public static Properties getSpaceProperties(String fullSpaceName) {
        return m_spaceProperties.get(fullSpaceName);
    }

    public static void setSpaceProperties(String fullSpaceName, Properties properties) {
        m_spaceProperties.put(fullSpaceName, properties);
    }

    public static SpaceConfigReader loadDCacheConfig(ISpaceProxy remoteSpace, Properties customProperties, String dcacheSuffix) throws SpaceInitializationException {
        try {
            String fullDCacheSpaceName = JSpaceUtilities.createFullSpaceName(remoteSpace.getContainerName(), remoteSpace.getName() + dcacheSuffix);
            SpaceConfig remoteSpaceProperties = ((IRemoteJSpaceAdmin)remoteSpace.getPrivilegedAdmin()).getConfig();
            JSpaceAttributes dcacheProperties = remoteSpaceProperties.getDCacheProperties();
            String dCacheConfigName = remoteSpaceProperties.getDCacheConfigName();
            InputStream dCacheInputStream = ResourceLoader.findConfigDCache(dCacheConfigName);
            if (dCacheInputStream != null) {
                m_customProperties = customProperties;
                dcacheProperties = JProperties.convertXML(dCacheInputStream, false, customProperties);
                JProperties.convertCustomSpacePropsToJProperties(fullDCacheSpaceName, customProperties, dcacheProperties);
                dcacheProperties.setDCacheProperties(dcacheProperties);
                dcacheProperties.setDCacheConfigName(null);
            }
            dcacheProperties.setProperty("engine.local_cache_mode", Boolean.TRUE.toString());
            m_spaceProperties.put(fullDCacheSpaceName, dcacheProperties);
            return new SpaceConfigReader(fullDCacheSpaceName);
        }
        catch (SAXException e) {
            throw new SpaceInitializationException("Failed to load space cache configuration", e);
        }
        catch (ParserConfigurationException e) {
            throw new SpaceInitializationException("Failed to load space cache configuration", e);
        }
        catch (IOException e) {
            throw new SpaceInitializationException("Failed to load space cache configuration", e);
        }
    }

    public static String getSpaceProperty(String fullSpaceName, String key, String defaultValue) {
        return JProperties.getSpaceProperty(fullSpaceName, key, defaultValue, true);
    }

    public static String getSpaceProperty(String fullSpaceName, String key, String defaultValue, boolean convert) {
        Properties sp = m_spaceProperties.get(fullSpaceName);
        String result = null;
        if (sp != null && (result = sp.getProperty(fullSpaceName + "." + "space-config." + key, null)) == null) {
            result = sp.getProperty("space-config." + key, null);
        }
        if (result == null) {
            result = defaultValue;
        }
        if (convert) {
            result = JProperties.getPropertyFromSystem(result, defaultValue);
        }
        return result;
    }

    public static <T> T getObjectSpaceProperty(String fullSpaceName, String key) {
        Properties sp = m_spaceProperties.get(fullSpaceName);
        Object result = null;
        if (sp != null && (result = sp.get(fullSpaceName + "." + "space-config." + key)) == null) {
            result = sp.getProperty("space-config." + key, null);
        }
        return (T)result;
    }

    public static void setSpaceProperty(String fullSpaceName, String key, String value) {
        Properties sp = m_spaceProperties.get(fullSpaceName);
        if (sp != null) {
            sp.setProperty(fullSpaceName + "." + "space-config." + key, value);
        }
    }

    public static JSpaceAttributes convertXML(String uri, boolean isConvertToSystemProperty) throws SAXException, ParserConfigurationException, IOException {
        Document doc = XmlUtils.getDocumentBuilder().parse(uri);
        Element root = doc.getDocumentElement();
        JSpaceAttributes prop = new JSpaceAttributes();
        JProperties.convertXMLtoProperty(root, prop, isConvertToSystemProperty);
        return prop;
    }

    public static Properties convertXML(InputStream is) throws SAXException, ParserConfigurationException, IOException {
        return JProperties.convertXML(is, true, null);
    }

    public static synchronized JSpaceAttributes convertXML(InputStream is, boolean isConvertToSystemProperty, Properties customProps) throws SAXException, ParserConfigurationException, IOException {
        Document doc = XmlUtils.getDocumentBuilder().parse(is);
        Element root = doc.getDocumentElement();
        JSpaceAttributes prop = new JSpaceAttributes();
        JProperties.convertXMLtoProperty(root, prop, isConvertToSystemProperty);
        JProperties.convertCustomContainerPropsToJProperties(customProps, prop);
        return prop;
    }

    private static void convertXMLtoProperty(Node n, Map prop, boolean isConvertToSystemProperty) {
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() == 3 && node.getNodeValue().trim().length() > 0) {
                JProperties.buildProperty(node, prop, isConvertToSystemProperty);
                continue;
            }
            JProperties.convertXMLtoProperty(node, prop, isConvertToSystemProperty);
        }
    }

    private static void buildProperty(Node node, Map<String, String> prop, boolean isConvertFromSystemProperty) {
        Stack<String> inverseKey = new Stack<String>();
        StringBuilder key = new StringBuilder();
        String propertyValue = node.getNodeValue();
        while (node.getParentNode() != null && node.getParentNode().getNodeType() != 9) {
            inverseKey.push(node.getParentNode().getNodeName());
            node = node.getParentNode();
        }
        while (!inverseKey.isEmpty()) {
            key.append((String)inverseKey.pop()).append('.');
        }
        if (key.charAt(key.length() - 1) == '.') {
            key = key.deleteCharAt(key.length() - 1);
        }
        propertyValue = propertyValue.trim();
        if (isConvertFromSystemProperty) {
            propertyValue = JProperties.getPropertyFromSystem(propertyValue);
        }
        String propKey = key.toString();
        prop.put(propKey, propertyValue);
    }

    public static String getPropertyFromSystem(String propertyValue) {
        return JProperties.getPropertyFromSystem(propertyValue, null);
    }

    public static String getPropertyFromSystem(String propertyValue, String defValue) {
        if (propertyValue == null) {
            return null;
        }
        int fIndex = propertyValue.indexOf("${");
        int lIndex = propertyValue.lastIndexOf("}");
        if (fIndex != -1 && lIndex != -1) {
            String cuttedkey = propertyValue.substring(fIndex + 2, lIndex);
            boolean useDefValue = defValue != null;
            StringBuilder sb = new StringBuilder(propertyValue);
            String sysProper = useDefValue ? System.getProperty(cuttedkey, defValue) : System.getProperty(cuttedkey);
            if (sysProper == null && m_customProperties != null) {
                if (m_customProperties.containsKey(cuttedkey)) {
                    sysProper = useDefValue ? m_customProperties.getProperty(cuttedkey, defValue) : m_customProperties.getProperty(cuttedkey);
                } else if (m_customProperties.containsKey(propertyValue)) {
                    sysProper = useDefValue ? m_customProperties.getProperty(propertyValue, defValue) : m_customProperties.getProperty(propertyValue);
                }
            }
            if (sysProper != null) {
                propertyValue = sb.replace(fIndex, lIndex + 1, sysProper).toString().replace('\\', '/');
            }
        }
        return propertyValue;
    }

    public static String resolveSystemPropertyName(String propertyValue) {
        String systemPropertyName = "";
        if (propertyValue == null) {
            return systemPropertyName;
        }
        int fIndex = propertyValue.indexOf("${");
        int lIndex = propertyValue.lastIndexOf("}");
        if (fIndex != -1 && lIndex != -1) {
            systemPropertyName = propertyValue.substring(fIndex + 2, lIndex);
        }
        return systemPropertyName;
    }

    public static void main(String[] args) {
        String str = "../GenericPersistProperties/${com.gs.container.name}_${com.gs.space.name}/${com.gs.container.name}_${com.gs.space.name}DB.dbs";
        System.setProperty("com.gs.container.name", "CONTAINERTEST");
        System.setProperty("com.gs.space.name", "SPACETEST");
        String result = JProperties.getPropertyFromSystemForComplicatedValue(str, "");
        System.out.println("RESULT" + result);
    }

    public static String getPropertyFromSystemForComplicatedValue(String propertyValue, String defValue) {
        int lastOpenIndex;
        if (propertyValue == null) {
            return null;
        }
        int firstOpenIndex = propertyValue.indexOf("${");
        if (firstOpenIndex == (lastOpenIndex = propertyValue.lastIndexOf("${"))) {
            return JProperties.getPropertyFromSystem(propertyValue, defValue);
        }
        StringBuffer resultBuffer = new StringBuffer();
        int beginIndex = 0;
        if (firstOpenIndex != 0) {
            String subStr = propertyValue.substring(0, firstOpenIndex);
            resultBuffer.append(subStr);
            beginIndex = firstOpenIndex;
        }
        int nextOpenBracketIndex = firstOpenIndex;
        boolean isStop = false;
        while (!isStop) {
            if ((nextOpenBracketIndex = propertyValue.indexOf("${", nextOpenBracketIndex + 1)) == -1) {
                nextOpenBracketIndex = propertyValue.length();
                isStop = true;
            }
            String subString = propertyValue.substring(beginIndex, nextOpenBracketIndex);
            beginIndex = nextOpenBracketIndex;
            String val = JProperties.getPropertyFromSystem(subString, "");
            resultBuffer.append(val);
        }
        String result = resultBuffer.toString();
        if (result.length() == 0) {
            result = defValue;
        }
        return result;
    }

    public static boolean isSystemProp(String propertyValue) {
        int fIndex = propertyValue.indexOf("${");
        int lIndex = propertyValue.lastIndexOf("}");
        return fIndex != -1 && lIndex != -1;
    }

    static {
        m_spaceProperties = new Hashtable<String, Properties>();
        m_UrlTable = new Hashtable();
        dCacheConfigFilesMap = new HashMap();
    }
}

