/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.pool;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.pool.IResource;
import com.j_spaces.kernel.pool.IResourceFactory;
import com.j_spaces.kernel.pool.ResourceNotAvailableException;
import com.j_spaces.kernel.pool.ResourcePool;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.LockSupport;

@InternalApi
public class BlockingResourcePool<R extends IResource>
extends ResourcePool<R> {
    private final Queue<Thread> waitingQueue = new ConcurrentLinkedQueue<Thread>();
    private static int noWaitParkTime;

    public BlockingResourcePool(IResourceFactory<R> resourceFactory, int minResources, int maxResources) {
        this(resourceFactory, minResources, maxResources, null);
    }

    public BlockingResourcePool(IResourceFactory<R> resourceFactory, int minResources, int maxResources, R[] initialResources) {
        super(resourceFactory, minResources, maxResources, initialResources);
    }

    @Override
    protected R handleFullPool(boolean waitIfNeeded) {
        Object resource;
        Thread thread = Thread.currentThread();
        do {
            this.waitingQueue.add(thread);
            resource = this.findFreeResource();
            if (resource != null) {
                this.waitingQueue.remove(thread);
                LockSupport.parkUntil(noWaitParkTime);
                return resource;
            }
            if (!waitIfNeeded) {
                this.waitingQueue.remove(thread);
                throw new ResourceNotAvailableException();
            }
            LockSupport.park();
        } while ((resource = this.findFreeResource()) == null);
        return resource;
    }

    @Override
    public void freeResource(R resourceToFree) {
        super.freeResource(resourceToFree);
        Thread thread = this.waitingQueue.poll();
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    static {
        try {
            LockSupport.parkUntil(-1L);
            noWaitParkTime = -1;
        }
        catch (Exception e) {
            noWaitParkTime = 0;
        }
    }
}

