/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.pool;

import com.j_spaces.kernel.pool.IResource;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Resource
implements IResource {
    private final AtomicBoolean _acquired = new AtomicBoolean(false);
    boolean _fromPool;

    @Override
    public void setFromPool(boolean fromPool) {
        this._fromPool = fromPool;
    }

    @Override
    public boolean isFromPool() {
        return this._fromPool;
    }

    @Override
    public boolean acquire() {
        return this._acquired.compareAndSet(false, true);
    }

    @Override
    public void setAcquired(boolean acquired) {
        this._acquired.set(acquired);
    }

    @Override
    public boolean isAcquired() {
        return this._acquired.get();
    }

    @Override
    public void release() {
        this.clear();
        if (!this._acquired.compareAndSet(true, false)) {
            throw new RuntimeException("Resource " + this.getClass().getName() + " had already been released prior to call.");
        }
    }

    @Override
    public abstract void clear();
}

