/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.pool;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.pool.IResource;
import com.j_spaces.kernel.pool.IResourceFactory;
import com.j_spaces.kernel.pool.IResourcePool;
import com.j_spaces.kernel.pool.IResourceProcedure;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class ResourcePool<R extends IResource>
implements IResourcePool<R> {
    private final R[] _resourcesPool;
    private final int _maxResources;
    private final AtomicInteger _nextFreeIndex;
    private final IResourceFactory<R> _resourceFactory;
    private boolean _full;

    public ResourcePool(IResourceFactory<R> resourceFactory, int minResources, int maxResources) {
        this(resourceFactory, minResources, maxResources, null);
    }

    protected ResourcePool(IResourceFactory<R> resourceFactory, int minResources, int maxResources, R[] initialResources) {
        int i;
        this._resourceFactory = resourceFactory;
        this._maxResources = maxResources;
        if (initialResources != null && initialResources.length > maxResources) {
            throw new IllegalArgumentException("initialResources length cannot exceed maxResources");
        }
        this._resourcesPool = new IResource[maxResources];
        if (initialResources != null) {
            for (i = 0; i < initialResources.length; ++i) {
                this._resourcesPool[i] = initialResources[i];
                this._resourcesPool[i].setFromPool(true);
            }
        }
        while (i < minResources) {
            this._resourcesPool[i] = this._resourceFactory.allocate();
            this._resourcesPool[i].setFromPool(true);
            ++i;
        }
        this._nextFreeIndex = new AtomicInteger(i);
    }

    @Override
    public R getResource() {
        return this.getResource(true);
    }

    @Override
    public R getResource(boolean waitIfNeeded) {
        R resource = this.findFreeResource();
        if (resource == null) {
            if (!this._full) {
                resource = this.tryAllocateNewPooledResource();
                if (resource == null) {
                    return this.handleFullPool(waitIfNeeded);
                }
                resource.setAcquired(true);
                int newIndex = this._nextFreeIndex.getAndIncrement();
                if (newIndex < this._maxResources) {
                    resource.setFromPool(true);
                    this._resourcesPool[newIndex] = resource;
                } else {
                    this._full = true;
                }
            } else {
                return this.handleFullPool(waitIfNeeded);
            }
        }
        return resource;
    }

    protected R tryAllocateNewPooledResource() {
        return this._resourceFactory.allocate();
    }

    R findFreeResource() {
        R resource;
        int i = 0;
        while ((resource = this._resourcesPool[i]) != null && !resource.acquire() && ++i < this._maxResources) {
        }
        if (i >= this._maxResources) {
            resource = null;
        }
        return resource;
    }

    protected R handleFullPool(boolean waitIfNeeded) {
        R resource = this._resourceFactory.allocate();
        resource.setAcquired(true);
        return resource;
    }

    @Override
    public void freeResource(R resourceToFree) {
        resourceToFree.release();
    }

    @Override
    public int availableResources() {
        int counter = 0;
        for (int i = 0; i < this._maxResources; ++i) {
            R resource = this._resourcesPool[i];
            if (resource == null || resource.isAcquired()) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public int size() {
        return this._nextFreeIndex.get();
    }

    @Override
    public void forAllResources(IResourceProcedure<R> procedure) {
        for (R resource : this._resourcesPool) {
            if (resource == null) {
                return;
            }
            procedure.invoke(resource);
        }
    }
}

