/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.pool;

import com.gigaspaces.time.SystemTime;
import com.j_spaces.kernel.pool.Resource;

public abstract class TraceableResource
extends Resource {
    private static final long RESOURCE_TIMEOUT = Integer.getInteger("debug.traceable-resource.timeout", 5000).intValue();
    long _timestamp;
    Throwable _stackTrace;

    @Override
    public void release() {
        this._timestamp = 0L;
        this._stackTrace = null;
        super.release();
    }

    @Override
    public boolean acquire() {
        boolean acquired = super.acquire();
        long now = SystemTime.timeMillis();
        if (acquired) {
            this._timestamp = now;
            this._stackTrace = new Throwable("\n\tOrigin of resource request:");
        } else {
            this.failOnElapsedTimeout(now);
        }
        return acquired;
    }

    private void failOnElapsedTimeout(long now) {
        if (this._timestamp > 0L && now - this._timestamp > RESOURCE_TIMEOUT) {
            throw new ResourceTimeoutException("Resource of type: " + this.getClass().getName() + " has exceeded its timeout of " + RESOURCE_TIMEOUT + " ms by " + (now - this._timestamp) + " ms", this._stackTrace);
        }
    }

    private static class ResourceTimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ResourceTimeoutException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

