/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.threadpool;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.threadpool.DynamicThreadFactory;
import com.j_spaces.kernel.threadpool.DynamicThreadPoolExecutor;
import com.j_spaces.kernel.threadpool.monitor.FutureExecutorService;
import com.j_spaces.kernel.threadpool.monitor.TimeoutObserverExecutorService;
import com.j_spaces.kernel.threadpool.policy.ForceQueuePolicy;
import com.j_spaces.kernel.threadpool.policy.TimedBlockingPolicy;
import com.j_spaces.kernel.threadpool.queue.DynamicQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@InternalApi
public class DynamicExecutors {
    public static ExecutorService newScalingThreadPool(int min, int max, long keepAliveTime) {
        DynamicQueue<Runnable> queue = new DynamicQueue<Runnable>();
        DynamicThreadPoolExecutor executor = new DynamicThreadPoolExecutor(min, max, keepAliveTime, TimeUnit.MILLISECONDS, queue);
        executor.setRejectedExecutionHandler(new ForceQueuePolicy());
        queue.setThreadPoolExecutor(executor);
        return executor;
    }

    public static ExecutorService newScalingThreadPool(int min, int max, long keepAliveTime, ThreadFactory threadFactory) {
        ExecutorService executorService = DynamicExecutors.newScalingThreadPool(min, max, keepAliveTime);
        ((ThreadPoolExecutor)executorService).setThreadFactory(threadFactory);
        return executorService;
    }

    public static ExecutorService newBlockingThreadPool(int min, int max, long keepAliveTime, int capacity, long waitTime) {
        return DynamicExecutors.newBlockingThreadPool(min, max, keepAliveTime, capacity, waitTime, false);
    }

    public static ExecutorService newBlockingThreadPool(int min, int max, long keepAliveTime, int capacity, long waitTime, boolean preStart) {
        DynamicQueue<Runnable> queue = new DynamicQueue<Runnable>(capacity);
        DynamicThreadPoolExecutor executor = new DynamicThreadPoolExecutor(min, max, keepAliveTime, TimeUnit.MILLISECONDS, queue);
        executor.setRejectedExecutionHandler(new TimedBlockingPolicy(waitTime));
        queue.setThreadPoolExecutor(executor);
        if (preStart) {
            executor.prestartAllCoreThreads();
        }
        return executor;
    }

    public static ExecutorService newBlockingThreadPool(int min, int max, long keepAliveTime, int capacity, long waitTime, int priority, String poolName, boolean preStart) {
        DynamicQueue<Runnable> queue = new DynamicQueue<Runnable>(capacity);
        ThreadFactory threadFactory = DynamicExecutors.priorityThreadFactory(priority, poolName);
        DynamicThreadPoolExecutor executor = new DynamicThreadPoolExecutor(min, max, keepAliveTime, TimeUnit.MILLISECONDS, queue);
        executor.setThreadFactory(threadFactory);
        executor.setRejectedExecutionHandler(new TimedBlockingPolicy(waitTime));
        queue.setThreadPoolExecutor(executor);
        if (preStart) {
            executor.prestartAllCoreThreads();
        }
        return executor;
    }

    public static ExecutorService newBlockingThreadPool(int min, int max, long keepAliveTime, int capacity, long waitTime, ThreadFactory threadFactory) {
        ExecutorService executorService = DynamicExecutors.newBlockingThreadPool(min, max, keepAliveTime, capacity, waitTime);
        ((ThreadPoolExecutor)executorService).setThreadFactory(threadFactory);
        return executorService;
    }

    public static FutureExecutorService newEventThreadPool(int min, int max, long keepAliveTime, long waitTime, ThreadFactory threadFactory) {
        ExecutorService scalingThreadPool = DynamicExecutors.newScalingThreadPool(min, max, keepAliveTime, threadFactory);
        TimeoutObserverExecutorService futureExecutorService = new TimeoutObserverExecutorService(scalingThreadPool, waitTime);
        return futureExecutorService;
    }

    public static ThreadFactory daemonThreadFactory(String namePrefix) {
        return new DynamicThreadFactory(namePrefix, 5);
    }

    public static ThreadFactory priorityThreadFactory(int priority, String namePrefix) {
        return new DynamicThreadFactory(namePrefix, priority);
    }

    private DynamicExecutors() {
    }
}

