/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.threadpool;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.kernel.threadpool.DynamicThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class DynamicThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    final ThreadGroup _group;
    final AtomicInteger _threadNumber = new AtomicInteger(1);
    final String _namePrefix;
    final int _priority;

    public DynamicThreadFactory(String namePrefix, int priority) {
        SecurityManager s = System.getSecurityManager();
        this._group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this._namePrefix = namePrefix + "-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
        this._priority = priority;
    }

    @Override
    public Thread newThread(Runnable r) {
        DynamicThread t = new DynamicThread(this._group, r, this._namePrefix + this._threadNumber.getAndIncrement(), 0L);
        t.setDaemon(true);
        t.setPriority(this._priority);
        return t;
    }
}

