/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.threadpool.monitor;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.kernel.threadpool.monitor.FutureExecutorService;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

@InternalApi
public class TimeoutObserverExecutorService
implements FutureExecutorService {
    private final ExecutorService executorService;
    private final long timeout;
    private final ObserverThread observerThread;
    private final LinkedBlockingQueue<Observable> queue = new LinkedBlockingQueue();

    public TimeoutObserverExecutorService(ExecutorService executorService, long timeout) {
        this.executorService = executorService;
        this.timeout = timeout;
        this.observerThread = new ObserverThread();
        this.observerThread.setDaemon(true);
        this.observerThread.start();
    }

    private void observe(Future<?> future) {
        Observable observable = new Observable(future, this.timeout);
        this.queue.add(observable);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> tasks) throws InterruptedException {
        List<Future<T>> list = this.executorService.invokeAll(tasks);
        for (Future<T> future : list) {
            this.observe(future);
        }
        return list;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        List<Future<T>> list = this.executorService.invokeAll(tasks, timeout, unit);
        for (Future<T> future : list) {
            this.observe(future);
        }
        return list;
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        this.observerThread.close();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.observerThread.close();
        return this.executorService.shutdownNow();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Future<T> future = this.executorService.submit(task);
        this.observe(future);
        return future;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        Future<T> future = this.executorService.submit(task, result);
        this.observe(future);
        return future;
    }

    @Override
    public Future<?> submit(Runnable task) {
        Future<?> future = this.executorService.submit(task);
        this.observe(future);
        return future;
    }

    private static class Observable {
        private final Future<?> future;
        private final long expiration;

        public Observable(Future<?> future, long timeout) {
            this.future = future;
            this.expiration = SystemTime.timeMillis() + timeout;
        }

        public boolean isObsolete() {
            if (this.future.isDone() || this.future.isCancelled()) {
                return true;
            }
            if (this.expiration > SystemTime.timeMillis()) {
                return false;
            }
            this.future.cancel(true);
            return true;
        }
    }

    private final class ObserverThread
    extends GSThread {
        public ObserverThread() {
            super("TimeoutObserverExecutorService-ObserverThread");
        }

        public void run() {
            try {
                while (!this.isInterrupted()) {
                    Thread.sleep(TimeoutObserverExecutorService.this.timeout);
                    this.harvestObsolete();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void harvestObsolete() {
            Iterator iterator = TimeoutObserverExecutorService.this.queue.iterator();
            while (iterator.hasNext()) {
                Observable observable = (Observable)iterator.next();
                if (!observable.isObsolete()) continue;
                iterator.remove();
            }
        }

        public void close() {
            this.interrupt();
            this.harvestObsolete();
            TimeoutObserverExecutorService.this.queue.clear();
        }
    }
}

