/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.kernel.threadpool.policy;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.ThreadDumpUtility;
import com.gigaspaces.time.SystemTime;
import java.lang.ref.WeakReference;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class TimedBlockingPolicy
implements RejectedExecutionHandler {
    private static final int WARN_INTERVAL_TIME = 60000;
    private static final int SAMPLE_INTERVAL_TIME = Integer.getInteger("com.gs.transport_protocol.lrmi.threshold-check-interval", 15000);
    private final long waitTime;
    private final String poolName;
    private final boolean warnOnRejection;
    private final int warnThreshold;
    private final Logger warnLogger;
    private final Object warnLock = new Object();
    private long lastWarnTime = -1L;
    private long lastSampleTime = -1L;
    private WeakReference<Runnable> pendingFirstTask = new WeakReference<Object>(null);
    private long pendingTimestamp = -1L;

    public TimedBlockingPolicy(long waitTime) {
        this(waitTime, null, false, -1, null);
    }

    public TimedBlockingPolicy(long waitTime, String poolName, boolean warnOnRejection, int warnThreshold, Logger warnLogger) {
        this.waitTime = waitTime;
        this.poolName = poolName;
        this.warnOnRejection = warnOnRejection;
        this.warnThreshold = warnThreshold;
        this.warnLogger = warnLogger;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        try {
            this.warnThresholdExceededIfNeeded(executor);
            boolean successful = executor.getQueue().offer(r, this.waitTime, TimeUnit.MILLISECONDS);
            if (!successful) {
                throw new RejectedExecutionException("Rejected execution after waiting " + this.waitTime + " ms for task [" + r.getClass() + "] to be executed.");
            }
        }
        catch (InterruptedException e) {
            throw new RejectedExecutionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void warnThresholdExceededIfNeeded(ThreadPoolExecutor executor) {
        if (this.warnOnRejection && this.warnLogger.isLoggable(Level.WARNING)) {
            long timeMillis = SystemTime.timeMillis();
            if (timeMillis - this.lastSampleTime < (long)SAMPLE_INTERVAL_TIME) {
                return;
            }
            Object object = this.warnLock;
            synchronized (object) {
                int queueSize;
                boolean queueSizeThresholdBreached;
                boolean tasksDidNotAdvanceSinceLastCheck;
                if (timeMillis - this.lastSampleTime < (long)SAMPLE_INTERVAL_TIME) {
                    return;
                }
                this.lastSampleTime = timeMillis;
                Runnable firstPendingTask = (Runnable)executor.getQueue().peek();
                if (firstPendingTask == null) {
                    return;
                }
                Runnable previousPendingFirstTask = (Runnable)this.pendingFirstTask.get();
                boolean bl = tasksDidNotAdvanceSinceLastCheck = previousPendingFirstTask == firstPendingTask;
                if (!tasksDidNotAdvanceSinceLastCheck) {
                    this.pendingFirstTask = new WeakReference<Runnable>(firstPendingTask);
                    this.pendingTimestamp = timeMillis;
                }
                boolean bl2 = queueSizeThresholdBreached = (queueSize = executor.getQueue().size()) > this.warnThreshold;
                if (timeMillis - this.lastWarnTime >= 60000L && (queueSizeThresholdBreached || tasksDidNotAdvanceSinceLastCheck)) {
                    this.lastWarnTime = timeMillis;
                    if (queueSizeThresholdBreached) {
                        String warningMsg = this.poolName + " resources are at critical level, executions are being queued, current queue size is " + queueSize + " (you can modify the threshold sample rate using 'com.gs.transport_protocol.lrmi.threshold-check-interval' system property setting the desired ms interval). " + this.addIncreaseLogLevelMessageIfNeeded();
                        this.warnLogger.warning(warningMsg);
                        if (this.warnLogger.isLoggable(Level.FINE)) {
                            this.warnLogger.fine("Generating Thread dump upon resource critical level warning " + StringUtils.NEW_LINE + ThreadDumpUtility.generateThreadDumpIfPossible());
                        }
                    }
                    if (tasksDidNotAdvanceSinceLastCheck) {
                        String severeMsg = this.poolName + " resources are at critical level, all threads are busy and first queued execution is pending since " + StringUtils.getTimeStamp(this.pendingTimestamp) + ". This can imply on a logical deadlock in which the current JVM stops responding to remote requests and should be restarted (you can modify the threshold sample rate using 'com.gs.transport_protocol.lrmi.threshold-check-interval' system property setting the desired ms interval). " + this.addIncreaseLogLevelMessageIfNeeded();
                        this.warnLogger.severe(severeMsg);
                        if (this.warnLogger.isLoggable(Level.FINE)) {
                            this.warnLogger.fine("Generating Thread dump upon resource critical level warning " + StringUtils.NEW_LINE + ThreadDumpUtility.generateThreadDumpIfPossible());
                        }
                    }
                }
            }
        }
    }

    private String addIncreaseLogLevelMessageIfNeeded() {
        String increaseLogLevelIfNeeded = this.warnLogger.isLoggable(Level.FINE) ? "" : "(in order to log an automatic thread dump, increase this logger logging level to FINE)";
        return increaseLogLevelIfNeeded;
    }
}

