/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.lookup.entry;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.lookup.entry.GenericEntry;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.entry.Entry;

@InternalApi
public class ClusterGroup
extends GenericEntry
implements Externalizable {
    private static final long serialVersionUID = -3820632312122408764L;
    public String electionGroup;
    public String replicationGroup;
    public String loadBalancingGroup;

    public ClusterGroup() {
    }

    public ClusterGroup(String electionGroup, String replicationGroup, String loadBalancingGroup) {
        if (electionGroup != null) {
            this.electionGroup = electionGroup.intern();
        }
        this.replicationGroup = replicationGroup;
        this.loadBalancingGroup = loadBalancingGroup;
    }

    public ClusterGroup(String replicationGroup) {
        this.replicationGroup = replicationGroup;
    }

    @Override
    public Entry fromString(String group) {
        return new ClusterGroup(group);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte flags = this.buildFlags();
        out.writeByte(flags);
        if (flags == 0) {
            return;
        }
        if (this.electionGroup != null) {
            out.writeObject(this.electionGroup);
        }
        if (this.replicationGroup != null) {
            out.writeObject(this.replicationGroup);
        }
        if (this.loadBalancingGroup != null) {
            out.writeObject(this.loadBalancingGroup);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        if (flags == 0) {
            return;
        }
        if ((flags & 1) != 0) {
            this.electionGroup = (String)in.readObject();
        }
        if ((flags & 2) != 0) {
            this.replicationGroup = (String)in.readObject();
        }
        if ((flags & 4) != 0) {
            this.loadBalancingGroup = (String)in.readObject();
        }
    }

    private byte buildFlags() {
        byte flags = 0;
        if (this.electionGroup != null) {
            flags = (byte)(flags | 1);
        }
        if (this.replicationGroup != null) {
            flags = (byte)(flags | 2);
        }
        if (this.loadBalancingGroup != null) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    private static interface BitMap {
        public static final byte ELECTION_GROUP = 1;
        public static final byte REPLICATION_GROUP = 2;
        public static final byte LOAD_BALANCING_GROUP = 4;
    }
}

