/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.lookup.entry;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.JSpaceState;
import com.j_spaces.lookup.entry.GenericEntry;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.entry.Entry;

@InternalApi
public class State
extends GenericEntry
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public String state;
    public Boolean electable;
    public Boolean replicable;

    public State(int state, Boolean electable, Boolean replicable) {
        this(state);
        this.electable = electable;
        this.replicable = replicable;
    }

    public State(String state) {
        if (state == null) {
            throw new NullPointerException("state is null");
        }
        this.state = state.intern();
    }

    public State(int state) {
        this(JSpaceState.convertToString(state));
    }

    public State() {
    }

    public Boolean isElectable() {
        return this.electable;
    }

    public void setElectable(Boolean electable) {
        this.electable = electable;
    }

    public Boolean getReplicable() {
        return this.replicable;
    }

    public State setReplicable(Boolean replicable) {
        this.replicable = replicable;
        return this;
    }

    @Override
    public Entry fromString(String state) {
        return new State(state);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte flags = this.buildFlags();
        out.writeByte(flags);
        if (flags == 0) {
            return;
        }
        if (this.state != null) {
            out.writeObject(this.state);
        }
        if (this.electable != null) {
            out.writeBoolean(this.electable);
        }
        if (this.replicable != null) {
            out.writeBoolean(this.replicable);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        if (flags == 0) {
            return;
        }
        if ((flags & 1) != 0) {
            this.state = (String)in.readObject();
        }
        if ((flags & 2) != 0) {
            this.electable = in.readBoolean();
        }
        if ((flags & 4) != 0) {
            this.replicable = in.readBoolean();
        }
    }

    private byte buildFlags() {
        byte flags = 0;
        if (this.state != null) {
            flags = (byte)(flags | 1);
        }
        if (this.electable != null) {
            flags = (byte)(flags | 2);
        }
        if (this.replicable != null) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    private static interface BitMap {
        public static final byte STATE = 1;
        public static final byte ELECTABLE = 2;
        public static final byte REPLICATABLE = 4;
    }
}

