/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.sadapter.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataSourceException;
import com.j_spaces.sadapter.datasource.BulkDataItem;
import com.j_spaces.sadapter.datasource.DataStorage;
import java.util.HashMap;
import java.util.LinkedList;

@InternalApi
public class BatchDataWriter {
    protected HashMap<Object, Object> _map = new HashMap();
    protected LinkedList _list = new LinkedList();
    protected DataStorage<Object> _storage;

    public BatchDataWriter(DataStorage<Object> storage) {
        this._storage = storage;
    }

    public void add(BulkDataItem entry) throws DataSourceException {
        if (this._storage.isBulkDataPersister()) {
            this._list.add(entry);
        } else if (this._storage.isDataPersister()) {
            this._list.add(entry.toObject());
        } else {
            throw new UnsupportedOperationException("Failed to insert new object - operation not supported by the data source.");
        }
    }

    public void executeBatch() throws DataSourceException {
        this._map.clear();
        if (!this._list.isEmpty()) {
            if (this._storage.isBulkDataPersister()) {
                this._storage.executeBulk(this._list);
            } else {
                this._storage.writeBatch(this._list);
            }
        }
        this._list.clear();
    }
}

