/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.sadapter.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.sync.DataSyncOperationType;
import com.j_spaces.sadapter.datasource.EntryAdapter;
import com.j_spaces.sadapter.datasource.IDataConverter;
import com.j_spaces.sadapter.datasource.InternalBulkItem;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class BulkDataItem
extends EntryAdapter
implements InternalBulkItem {
    private static final long serialVersionUID = -2854220047028924547L;
    private final short _operation;

    public BulkDataItem(IEntryHolder entryHolder, ITypeDesc typeDesc, short operation) {
        super(entryHolder, typeDesc);
        this._operation = operation;
    }

    public BulkDataItem(IEntryHolder entryHolder, ITypeDesc typeDesc, short operation, IDataConverter<IEntryPacket> converter) {
        super(entryHolder, typeDesc, converter);
        this._operation = operation;
    }

    @Override
    public Object getItem() {
        return this.toObject();
    }

    @Override
    public short getOperation() {
        return this._operation;
    }

    @Override
    public String toString() {
        String operation = null;
        switch (this._operation) {
            case 1: {
                operation = "REMOVE";
                break;
            }
            case 2: {
                operation = "UPDATE";
                break;
            }
            case 3: {
                operation = "WRITE";
                break;
            }
            case 4: {
                operation = "PARTIAL UPDATE";
                break;
            }
            default: {
                operation = "UNKNOWN";
            }
        }
        return "BulkDataItem<Op: " + operation + ", " + super.toString() + ">";
    }

    @Override
    public String getTypeName() {
        return this._entryHolder.getClassName();
    }

    private ITypeDesc getTypeDesc() {
        return this._entryHolder.getServerTypeDesc().getTypeDesc();
    }

    @Override
    public String getIdPropertyName() {
        return this.getTypeDesc().getIdPropertyName();
    }

    @Override
    public Object getIdPropertyValue() {
        ITypeDesc typeDesc = this.getTypeDesc();
        if (typeDesc.getIdPropertyName() != null && typeDesc.isAutoGenerateId()) {
            return this._entryHolder.getUID();
        }
        return this._entryHolder.getEntryData().getPropertyValue(this.getIdPropertyName());
    }

    @Override
    public Object getSpaceId() {
        return this.getIdPropertyValue();
    }

    @Override
    public boolean supportsGetSpaceId() {
        return StringUtils.hasText(this.getTypeDesc().getIdPropertyName());
    }

    @Override
    public Map<String, Object> getItemValues() {
        ITypeDesc typeDesc = this.getTypeDesc();
        IEntryData entryData = this._entryHolder.getEntryData();
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (int i = 0; i < typeDesc.getNumOfFixedProperties(); ++i) {
            props.put(typeDesc.getFixedProperty(i).getName(), entryData.getFixedPropertyValue(i));
        }
        if (entryData.getDynamicProperties() != null) {
            props.putAll(entryData.getDynamicProperties());
        }
        return props;
    }

    @Override
    public String getUid() {
        return this._entryHolder.getUID();
    }

    @Override
    public DataSyncOperationType getDataSyncOperationType() {
        switch (this._operation) {
            case 3: {
                return DataSyncOperationType.WRITE;
            }
            case 2: {
                return DataSyncOperationType.UPDATE;
            }
            case 4: {
                return DataSyncOperationType.PARTIAL_UPDATE;
            }
        }
        return DataSyncOperationType.REMOVE;
    }

    @Override
    public Object getDataAsObject() {
        if (!this.supportsDataAsObject()) {
            throw new UnsupportedOperationException();
        }
        return this.toObject();
    }

    @Override
    public SpaceDocument getDataAsDocument() {
        if (!this.supportsDataAsDocument()) {
            throw new UnsupportedOperationException();
        }
        return this.toDocument();
    }

    @Override
    public boolean supportsGetTypeDescriptor() {
        return this._typeDesc != null;
    }

    @Override
    public boolean supportsDataAsObject() {
        return this._typeDesc != null && this._typeDesc.isConcreteType() || this.getMapEntry() != null;
    }

    @Override
    public boolean supportsDataAsDocument() {
        return true;
    }
}

