/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.sadapter.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.server.storage.EntryHolderFactory;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.SAException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class DataAdaptorIterator
implements ISAdapterIterator<IEntryHolder> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.persistent");
    private final SpaceTypeManager _typeManager;
    private final EntryDataType _entryDataType;
    private List<Iterator<IEntryPacket>> _listOfIterators = new LinkedList<Iterator<IEntryPacket>>();
    private Iterator<IEntryPacket> _iterator;
    private int _cursor = 1;

    public DataAdaptorIterator(SpaceTypeManager typeManager, EntryDataType entryDataType) {
        this._typeManager = typeManager;
        this._entryDataType = entryDataType;
    }

    public void add(Iterator<IEntryPacket> iterator) {
        if (iterator == null) {
            return;
        }
        if (this._iterator == null) {
            this._iterator = iterator;
        }
        this._listOfIterators.add(iterator);
    }

    private IEntryPacket _next() {
        return this._iterator.next();
    }

    private boolean _hasNext() {
        try {
            if (this._iterator.hasNext()) {
                return true;
            }
            while (this._cursor < this._listOfIterators.size()) {
                this._iterator = this._listOfIterators.get(this._cursor++);
                if (!this._iterator.hasNext()) continue;
                return true;
            }
            return false;
        }
        catch (NullPointerException npe) {
            if (this._iterator == null) {
                return false;
            }
            throw npe;
        }
    }

    @Override
    public IEntryHolder next() throws SAException {
        if (!this._hasNext()) {
            return null;
        }
        try {
            IEntryPacket next = this._next();
            if (next == null) {
                return null;
            }
            IServerTypeDesc typeDesc = this._typeManager.loadServerTypeDesc(next);
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("CacheIterator#next() RETURNs " + next.toString());
            }
            return EntryHolderFactory.createEntryHolder(typeDesc, next, this._entryDataType);
        }
        catch (Throwable t) {
            throw new SAException(t);
        }
    }

    @Override
    public void close() throws SAException {
        ListIterator<Iterator<IEntryPacket>> iteration = this._listOfIterators.listIterator();
        while (iteration.hasNext()) {
            Iterator iterator = (Iterator)iteration.next();
            this.discardOfIterator(iterator);
            iteration.remove();
        }
        this._listOfIterators = null;
        this._iterator = null;
    }

    private void discardOfIterator(Iterator<IEntryPacket> iterator) throws SAException {
        try {
            if (iterator instanceof DataIterator) {
                ((DataIterator)iterator).close();
            }
        }
        catch (Throwable t) {
            throw new SAException(t);
        }
    }

    public static String getDataSourceShareIteratorTTLDefault(long leaseManagerExpirationTimeRecentDeletes, long leaseManagerExpirationTimeRecentUpdates) {
        return String.valueOf(Math.min(Math.min(leaseManagerExpirationTimeRecentDeletes, leaseManagerExpirationTimeRecentUpdates) / 2L, 10000L));
    }
}

