/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.sadapter.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.BulkDataPersister;
import com.gigaspaces.datasource.BulkItem;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataPersister;
import com.gigaspaces.datasource.DataProvider;
import com.gigaspaces.datasource.DataSourceException;
import com.gigaspaces.datasource.ManagedDataSource;
import com.gigaspaces.datasource.SQLDataProvider;
import com.j_spaces.core.client.SQLQuery;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class DataStorage<T>
implements DataProvider<T>,
SQLDataProvider<T>,
DataPersister<T>,
BulkDataPersister,
ManagedDataSource<T> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.persistent");
    private final DataProvider<T> _saDataProvider;
    private final DataPersister<T> _saDataPersister;
    private SQLDataProvider<T> _saSQLDataProvider;
    private final BulkDataPersister _saBulkDataPersister;
    private ManagedDataSource<T> _saManagedDataSource;

    public DataStorage(Object store) {
        this._saDataProvider = store instanceof DataProvider ? (DataProvider)store : null;
        this._saDataPersister = store instanceof DataPersister ? (DataPersister)store : null;
        this._saSQLDataProvider = store instanceof SQLDataProvider ? (SQLDataProvider)store : null;
        this._saBulkDataPersister = store instanceof BulkDataPersister ? (BulkDataPersister)store : null;
        this._saManagedDataSource = store instanceof ManagedDataSource ? (ManagedDataSource)store : null;
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config("\n\t Space Data Storage <" + store + "> Loaded\n\t\t " + DataProvider.class.getSimpleName() + "              : " + (this.isDataProvider() ? "Implemented" : "-") + "\n\t\t " + DataPersister.class.getSimpleName() + "             : " + (this.isDataPersister() ? "Implemented" : "-") + "\n\t\t " + BulkDataPersister.class.getSimpleName() + "         : " + (this.isBulkDataPersister() ? "Implemented" : "-") + "\n\t\t " + SQLDataProvider.class.getSimpleName() + "           : " + (this.isSQLDataProvider() ? "Implemented" : "-") + "\n\t\t " + ManagedDataSource.class.getSimpleName() + "         : " + (this.isManagedDataSource() ? "Implemented" : "-") + "\n");
        }
    }

    public boolean isDataProvider() {
        return this._saDataProvider != null;
    }

    public boolean isDataPersister() {
        return this._saDataPersister != null;
    }

    public boolean isSQLDataProvider() {
        return this._saSQLDataProvider != null;
    }

    public boolean isBulkDataPersister() {
        return this._saBulkDataPersister != null;
    }

    public boolean isManagedDataSource() {
        return this._saManagedDataSource != null;
    }

    @Override
    public T read(T template) throws DataSourceException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(DataStorage.class.getName(), "DataProvider#read", template);
        }
        T result = this._saDataProvider.read(template);
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting(DataStorage.class.getName(), "DataProvider#read", result);
        }
        return result;
    }

    @Override
    public DataIterator<T> iterator(T template) throws DataSourceException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(DataStorage.class.getName(), "DataProvider#iterator", template);
        }
        DataIterator<T> iter = this._saDataProvider.iterator(template);
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting(DataStorage.class.getName(), "DataProvider#iterator", iter);
        }
        return iter;
    }

    @Override
    public DataIterator<T> iterator(SQLQuery<T> query) throws DataSourceException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(DataStorage.class.getName(), "SQLDataProvider#iterator", query);
        }
        DataIterator<T> iter = this._saSQLDataProvider.iterator(query);
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting(DataStorage.class.getName(), "SQLDataProvider#iterator", iter);
        }
        return iter;
    }

    @Override
    public void remove(T object) throws DataSourceException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(DataStorage.class.getName(), "DataPersister#remove", object);
        }
        this._saDataPersister.remove(object);
    }

    @Override
    public void update(T object) throws DataSourceException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(DataStorage.class.getName(), "DataPersister#update", object);
        }
        this._saDataPersister.update(object);
    }

    @Override
    public void write(T object) throws DataSourceException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(DataStorage.class.getName(), "DataPersister#write", object);
        }
        this._saDataPersister.write(object);
    }

    @Override
    public void writeBatch(List<T> objects) throws DataSourceException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(DataStorage.class.getName(), "DataPersister#writeBatch", objects);
        }
        this._saDataPersister.writeBatch(objects);
    }

    @Override
    public void executeBulk(List<BulkItem> bulk) throws DataSourceException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(DataStorage.class.getName(), "BulkDataPersister#executeBulk", bulk);
        }
        this._saBulkDataPersister.executeBulk(bulk);
    }

    @Override
    public void init(Properties configuration) throws DataSourceException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(DataStorage.class.getName(), "ManagedDataSource#init", configuration);
        }
        this._saManagedDataSource.init(configuration);
    }

    @Override
    public void shutdown() throws DataSourceException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(DataStorage.class.getName(), "ManagedDataSource#shutdown");
        }
        this._saManagedDataSource.shutdown();
    }

    public boolean isReadOnly() {
        return !this.isDataPersister() && !this.isBulkDataPersister();
    }

    @Override
    public DataIterator<T> initialLoad() throws DataSourceException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering(DataStorage.class.getName(), "ManagedDataSource#initialLoad");
        }
        DataIterator<T> iter = this._saManagedDataSource.initialLoad();
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting(DataStorage.class.getName(), "ManagedDataSource#initialLoad");
        }
        return iter;
    }

    public synchronized void setSQLDataProvider(SQLDataProvider<T> sqlDataProvider) {
        this._saSQLDataProvider = sqlDataProvider;
    }

    public synchronized void setManagedDataSource(ManagedDataSource<T> managedDataSource) {
        this._saManagedDataSource = managedDataSource;
    }
}

