/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.sadapter.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.sadapter.datasource.SQLQueryBuilder;
import java.util.LinkedList;

@InternalApi
public class DefaultSQLQueryBuilder
implements SQLQueryBuilder {
    public static final String BIND_PARAMETER = "?";
    public static final String OR = " or ";
    public static final String AND = " and ";
    private static final String[] extendedMatchCodeMapping = new String[]{" = ", " != ", " > ", " >= ", " < ", " <= ", " is null ", " is not null ", " like ", "[*] = "};

    @Override
    public SQLQuery<?> build(ITemplateHolder template, String typeName, ITypeDesc typeDesc) {
        if (typeDesc == null) {
            return new SQLQuery(typeName, "");
        }
        return template.toSQLQuery(typeDesc);
    }

    public static Object convertToSQLFormat(Object object, short matchCode) {
        if (matchCode == 8) {
            return object.toString().replaceAll("(\\.\\*)", "%").replaceAll("\\.", "_");
        }
        return object;
    }

    @Override
    public SQLQuery<?> build(IEntryPacket entry, ITypeDesc typeDesc) {
        Object id = null;
        String idPropertyName = typeDesc.getIdPropertyName();
        if (idPropertyName == null) {
            idPropertyName = typeDesc.getDefaultPropertyName();
        }
        if (idPropertyName == null) {
            return new SQLQuery(entry.getTypeName(), "");
        }
        id = typeDesc.getIdPropertyName() != null && typeDesc.isAutoGenerateId() ? entry.getUID() : entry.getPropertyValue(idPropertyName);
        StringBuilder wherePart = new StringBuilder();
        wherePart.append(idPropertyName);
        wherePart.append(DefaultSQLQueryBuilder.mapCodeToSign((short)0));
        wherePart.append(BIND_PARAMETER);
        LinkedList<Object> preparedValues = new LinkedList<Object>();
        preparedValues.add(id);
        SQLQuery query = new SQLQuery(entry.getTypeName(), wherePart.toString());
        query.setParameters(preparedValues.toArray());
        return query;
    }

    public static String mapCodeToSign(short code) {
        return extendedMatchCodeMapping[code];
    }
}

