/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.sadapter.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.transport.EntryPacketFactory;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.map.MapEntryFactory;
import com.j_spaces.map.SpaceMapEntry;
import com.j_spaces.sadapter.cache.CacheEntry;
import com.j_spaces.sadapter.datasource.IDataConverter;
import java.rmi.RemoteException;
import java.util.Map;
import net.jini.core.entry.UnusableEntryException;

@InternalApi
public class EntryAdapter
extends CacheEntry {
    private static final long serialVersionUID = 1123908388737972298L;
    protected IDataConverter<IEntryPacket> _converter;

    public EntryAdapter(IDataConverter<IEntryPacket> converter) {
        this._converter = converter;
    }

    public EntryAdapter(IEntryHolder entryHolder, ITypeDesc typeDesc, IDataConverter<IEntryPacket> converter) {
        this(entryHolder, typeDesc);
        this._converter = converter;
    }

    public EntryAdapter(IEntryHolder entryHolder, ITypeDesc typeDesc) {
        super(entryHolder, typeDesc);
    }

    public IDataConverter<IEntryPacket> getConverter() {
        return this._converter;
    }

    public void setConverter(IDataConverter<IEntryPacket> converter) {
        this._converter = converter;
    }

    public Object toObject() {
        if (this.getMapEntry() != null) {
            return this.getMapEntry();
        }
        if (this._converter != null) {
            IEntryPacket packet = this.toEntryPacket();
            return this._converter.toObject(packet);
        }
        return this;
    }

    public SpaceDocument toDocument() {
        return this._converter.toDocument(this.toEntryPacket());
    }

    public SpaceDocument toDocument(String typeName) {
        SpaceDocument document = this.toDocument();
        document.setTypeName(typeName);
        return document;
    }

    public IEntryPacket toEntryPacket() {
        if (this.hasDummyTTE()) {
            return TemplatePacketFactory.createEmptyPacket(this._typeDesc);
        }
        return EntryPacketFactory.createFullPacket(this._entryHolder, null, this._entryHolder.getUidToOperateBy());
    }

    public IEntryPacket toEntry(Object object) throws RemoteException, UnusableEntryException, UnknownTypeException {
        if (object == null) {
            return null;
        }
        if (object instanceof SpaceMapEntry) {
            return this._converter.toInternal(object);
        }
        if (object instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)object;
            SpaceMapEntry envelope = MapEntryFactory.create(entry.getKey(), entry.getValue());
            return this._converter.toInternal(envelope);
        }
        if (this._converter != null) {
            return this._converter.toInternal(object);
        }
        return null;
    }

    public IEntryPacket toEntry(Object key, Object value) throws RemoteException, UnusableEntryException, UnknownTypeException {
        if (key == null || value == null) {
            return null;
        }
        return this._converter.toInternal(MapEntryFactory.create(key, value));
    }

    public ITypeDesc getTypeDescriptor() {
        return this._typeDesc;
    }
}

