/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.sadapter.datasource;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.StorageTypeDeserialization;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.transport.EntryPacketFactory;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.IGSEntry;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.exception.internal.PersistentInternalSpaceException;
import com.j_spaces.sadapter.datasource.IDataConverter;
import java.rmi.RemoteException;
import net.jini.core.entry.UnusableEntryException;

@InternalApi
public class EntryPacketDataConverter
implements IDataConverter<IEntryPacket> {
    private final DataType _dataType;
    protected final SpaceTypeManager _typeManager;

    public EntryPacketDataConverter(SpaceTypeManager typeDescRepository, Class type) {
        this._typeManager = typeDescRepository;
        this._dataType = DataType.getDataType(type);
    }

    @Override
    public IEntryPacket toInternal(Object obj) throws RemoteException, UnusableEntryException, UnknownTypeException {
        if (this._dataType == DataType.RAW) {
            return (IEntryPacket)obj;
        }
        ObjectType objectType = ObjectType.fromObject(obj);
        ITypeDesc typeDesc = this._typeManager.getTypeDescriptorByObject(obj, objectType).getTypeDesc();
        EntryType entryType = objectType == ObjectType.EXTERNAL_ENTRY ? EntryType.EXTERNAL_ENTRY : (objectType == ObjectType.DOCUMENT ? EntryType.DOCUMENT_JAVA : EntryType.OBJECT_JAVA);
        return EntryPacketFactory.createFromObject(obj, typeDesc, entryType, false);
    }

    @Override
    public Object toObject(IEntryPacket entryPacket) {
        if (this._dataType == DataType.RAW) {
            return entryPacket;
        }
        String className = entryPacket.getTypeName();
        if (className == null) {
            return null;
        }
        EntryType entryType = this._dataType.getEntryType();
        try {
            ITypeDesc typeDesc = this._typeManager.loadServerTypeDesc(entryPacket).getTypeDesc();
            return typeDesc.getIntrospector(entryType).toObject(entryPacket);
        }
        catch (Exception e) {
            throw new PersistentInternalSpaceException("Illegal object type descriptor. Object type - " + (Object)((Object)entryType) + " , class - " + className, e);
        }
    }

    @Override
    public SpaceDocument toDocument(IEntryPacket entryPacket) {
        return (SpaceDocument)entryPacket.toObject(QueryResultTypeInternal.DOCUMENT_ENTRY, StorageTypeDeserialization.EAGER);
    }

    public static enum DataType {
        REAL,
        VIRTUAL,
        DOCUMENT,
        RAW;


        public static DataType getDataType(Class type) {
            if (IEntryPacket.class.isAssignableFrom(type)) {
                return RAW;
            }
            if (IGSEntry.class.isAssignableFrom(type)) {
                return VIRTUAL;
            }
            if (SpaceDocument.class.isAssignableFrom(type)) {
                return DOCUMENT;
            }
            return REAL;
        }

        public EntryType getEntryType() {
            if (this == REAL) {
                return EntryType.OBJECT_JAVA;
            }
            if (this == VIRTUAL) {
                return EntryType.EXTERNAL_ENTRY;
            }
            if (this == DOCUMENT) {
                return EntryType.DOCUMENT_JAVA;
            }
            return null;
        }
    }
}

