/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.start;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.ReplaceInFileUtils;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.JSpaceAttributes;
import com.j_spaces.core.JSpaceContainerImpl;
import com.j_spaces.core.NoSuchNameException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.service.AbstractService;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.ResourceLoader;
import com.j_spaces.kernel.log.JProperties;
import com.sun.jini.start.LifeCycle;
import java.io.File;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.export.ProxyAccessor;
import net.jini.lookup.JoinManager;

@InternalApi
public class JSpaceServiceImpl
extends AbstractService
implements ProxyAccessor {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.admin");
    public static final String CONFIG_COMPONENT = "com.gigaspaces.start";
    private Object _spaceProxy;
    private JSpaceAttributes _spaceAttr;
    private JSpaceContainerImpl _spaceContainer;
    private String _spaceName;
    private String _schemaName;
    private String _customPropertiesFileName;
    private String _spaceUrl;
    private String _containerName;
    private String _clusterConfigURL;
    private String _licenseKey;
    private String _homeDirectory;
    private String _initialMemberGroups;
    private String _initialLookupLocators;
    private String _downloadHost;
    private Boolean _startEmbeddedLus;

    public JSpaceServiceImpl(String[] configArgs, LifeCycle lifeCycle) throws Exception {
        block11: {
            super(lifeCycle);
            Configuration config = ConfigurationProvider.getInstance((String[])configArgs, (ClassLoader)this.getClass().getClassLoader());
            this.init(config);
            String cacheUrl = System.getProperty("gs.space.url", this._spaceUrl);
            if (cacheUrl != null) {
                this._spaceProxy = SpaceFinder.find(cacheUrl, null, lifeCycle, null);
                if (this._spaceProxy instanceof IJSpace) {
                    this._spaceProxy = ((IJSpace)this._spaceProxy).getDirectProxy().getNonClusteredProxy();
                }
            } else {
                String spaceFileURL;
                Properties _customPropsObj = null;
                if (this._customPropertiesFileName != null) {
                    _customPropsObj = ResourceLoader.findCustomPropertiesObj(this._customPropertiesFileName);
                }
                this._spaceAttr = new JSpaceAttributes(this._schemaName, this._clusterConfigURL);
                if (_customPropsObj != null) {
                    _customPropsObj.setProperty("properties", this._customPropertiesFileName);
                    this._spaceAttr.setCustomProperties(_customPropsObj);
                }
                if (new File(spaceFileURL = SystemInfo.singleton().locations().config() + File.separator + this._spaceName + ".xml").exists()) {
                    ReplaceInFileUtils updateFile = new ReplaceInFileUtils(spaceFileURL);
                    updateFile.xmlReplace("cluster.enabled", this._clusterConfigURL != null ? "true" : "false");
                    if (this._clusterConfigURL != null) {
                        updateFile.xmlReplace("cluster.config-url", this._clusterConfigURL);
                    }
                    updateFile.close();
                }
                this._spaceContainer = this.initContainer(lifeCycle, this._containerName, this._schemaName, _customPropsObj);
                try {
                    this._spaceProxy = this._spaceContainer.getClusteredSpace(this._spaceName);
                }
                catch (NoSuchNameException ex) {
                    try {
                        this._spaceProxy = this._spaceContainer.createSpace(this._spaceName, this._spaceAttr);
                    }
                    catch (Exception ex1) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block11;
                        _logger.log(Level.SEVERE, ex1.toString(), ex1);
                    }
                }
            }
        }
    }

    private void init(Configuration config) {
        block9: {
            String localhostName = SystemInfo.singleton().network().getHost().getHostAddress();
            try {
                this._containerName = JSpaceServiceImpl.getConfigString(config, "containerName", localhostName);
                this._spaceName = JSpaceServiceImpl.getConfigString(config, "spaceName", "JavaSpaces");
                this._clusterConfigURL = JSpaceServiceImpl.getConfigString(config, "clusterConfigURL", null);
                this._licenseKey = JSpaceServiceImpl.getConfigString(config, "licenseKey", null);
                this._homeDirectory = JSpaceServiceImpl.getConfigString(config, "homeDirectory", null);
                this._initialMemberGroups = JSpaceServiceImpl.getConfigString(config, "initialMemberGroups", null);
                this._initialLookupLocators = JSpaceServiceImpl.getConfigString(config, "initialLookupLocators", null);
                this._downloadHost = JSpaceServiceImpl.getConfigString(config, "downloadHost", localhostName + ":9010");
                this._schemaName = JSpaceServiceImpl.getConfigString(config, "schema", null);
                this._customPropertiesFileName = JSpaceServiceImpl.getConfigString(config, "properties", null);
                this._spaceUrl = JSpaceServiceImpl.getConfigString(config, "spaceURL", null);
                this._startEmbeddedLus = JSpaceServiceImpl.getConfigBoolean(config, "startEmbeddedLus", Boolean.FALSE);
            }
            catch (ConfigurationException e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block9;
                _logger.log(Level.SEVERE, "Error while loading JSpaceService. " + e.toString() + " Please check the Jini configuration files.");
            }
        }
        if (this._containerName != null) {
            System.setProperty("com.gs.container.name", this._containerName);
        }
        if (this._licenseKey != null) {
            System.setProperty("com.gs.licensekey", this._licenseKey);
        }
        if (this._homeDirectory != null) {
            System.setProperty("com.gs.home", this._homeDirectory);
        }
        if (this._initialMemberGroups != null) {
            SystemInfo.singleton().lookup().setGroups(JSpaceUtilities.removeInvertedCommas(this._initialMemberGroups));
        }
        if (this._initialLookupLocators != null) {
            SystemInfo.singleton().lookup().setLocators(JSpaceUtilities.removeInvertedCommas(this._initialLookupLocators));
        }
        if (this._downloadHost != null) {
            System.setProperty("com.gs.downloadhost", this._downloadHost);
        }
        if (this._startEmbeddedLus != null) {
            System.setProperty("com.gs.start-embedded-lus", this._startEmbeddedLus.toString());
        }
    }

    private JSpaceContainerImpl initContainer(LifeCycle lifeCycle, String containerName, String schemaName, Properties schemaProperties) throws Exception {
        String contConfFile = SystemInfo.singleton().locations().config() + File.separator + containerName + "-config.xml";
        File configFile = new File(contConfFile);
        if (!configFile.canRead() && !JSpaceUtilities.isEmpty(schemaName)) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("Couldn't find the required " + containerName + "-config.xml file: " + contConfFile + ".\n About to load the default container schema file from the ResourceBundle, to be used for the container configuration.");
            }
            InputStream schemaInputStream = ResourceLoader.findContainerSchema(schemaName);
            JProperties.setInputStream(containerName, schemaInputStream, schemaProperties);
        } else {
            JProperties.setURL(containerName, contConfFile);
        }
        JProperties.getContainerProperties(containerName).setProperty("com.j_spaces.core.container.name", containerName);
        return new JSpaceContainerImpl(lifeCycle, schemaName, null, schemaProperties);
    }

    @Override
    public String getServiceName() {
        return this._spaceName;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public JoinManager getJoinManager() {
        return null;
    }

    public Object getServiceProxy() throws RemoteException {
        return this._spaceProxy;
    }

    public Object getProxy() {
        return this._spaceProxy;
    }

    @Override
    public String getContainerName() {
        throw new UnsupportedOperationException();
    }

    private static String getConfigString(Configuration config, String name, String defaultValue) throws ConfigurationException {
        return (String)JSpaceServiceImpl.getConfigEntry(config, CONFIG_COMPONENT, name, String.class, defaultValue);
    }

    private static Boolean getConfigBoolean(Configuration config, String name, Boolean defaultValue) throws ConfigurationException {
        return (Boolean)JSpaceServiceImpl.getConfigEntry(config, CONFIG_COMPONENT, name, Boolean.class, defaultValue);
    }

    private static Object getConfigEntry(Configuration config, String component, String name, Class<?> type, Object defaultValue) throws ConfigurationException {
        try {
            return config.getEntry(component, name, type);
        }
        catch (NoSuchEntryException e) {
            return defaultValue;
        }
    }
}

