/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.worker;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.ISpaceComponentsHandler;
import com.gigaspaces.cluster.activeelection.SpaceComponentsInitializeException;
import com.gigaspaces.cluster.activeelection.SpaceInitializationIndicator;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.j_spaces.core.IJSpace;
import com.j_spaces.kernel.ClassLoaderHelper;
import com.j_spaces.worker.IWorker;
import com.j_spaces.worker.WorkerInfo;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
@InternalApi
public class WorkerManager
implements ISpaceComponentsHandler {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.worker");
    private final IJSpace workerProxy;
    private final String workerManagerName;
    private final boolean isInterrupt;
    private final Hashtable<String, WorkerInfo> workerTable;
    private boolean isClosed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerManager(IJSpace workerProxy, String fullSpaceName) {
        this.workerProxy = workerProxy;
        this.workerManagerName = workerProxy.getName();
        SpaceInitializationIndicator.setInitializer();
        try {
            SpaceConfigReader configReader = new SpaceConfigReader(fullSpaceName);
            this.isInterrupt = configReader.getBooleanSpaceProperty("workers.interrupt", "false");
            this.workerTable = this.buildWorkers(configReader);
        }
        finally {
            SpaceInitializationIndicator.unsetInitializer();
        }
    }

    public synchronized void shutdown() {
        if (this.isClosed) {
            return;
        }
        Iterator<WorkerInfo> iterator = this.workerTable.values().iterator();
        while (iterator.hasNext()) {
            WorkerInfo worker = iterator.next();
            iterator.remove();
            this.close(worker);
        }
        this.isClosed = true;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("WorkerManager: " + this.workerManagerName + " closed successfully.");
        }
    }

    private void close(WorkerInfo worker) {
        block4: {
            try {
                if (this.isInterrupt) {
                    worker.getWorkerThread().interrupt();
                }
                worker.getWorker().close();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("WorkerManager: " + this.workerManagerName + " Worker: " + worker.getWorkerName() + " closed successfully.");
                }
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block4;
                _logger.log(Level.FINE, "WorkerManager: " + this.workerManagerName + " Failed to close " + worker.getWorkerName(), ex);
            }
        }
    }

    private Hashtable<String, WorkerInfo> buildWorkers(SpaceConfigReader configReader) {
        Hashtable<String, WorkerInfo> result = new Hashtable<String, WorkerInfo>();
        String workerNames = configReader.getSpaceProperty("workers.worker-names", null);
        if (workerNames == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("No worker defined for " + this.workerManagerName + " space.");
            }
            return result;
        }
        String[] workerArr = workerNames.split(",");
        for (int i = 0; i < workerArr.length; ++i) {
            workerArr[i] = workerArr[i].trim();
            String enabled = configReader.getSpaceProperty("workers." + workerArr[i] + '.' + "enabled", "true");
            if (enabled.equalsIgnoreCase(Boolean.FALSE.toString())) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.fine("Worker: " + workerArr[i] + " disabled.");
                continue;
            }
            String className = configReader.getSpaceProperty("workers." + workerArr[i] + '.' + "class-name", null);
            String arg = configReader.getSpaceProperty("workers." + workerArr[i] + '.' + "arg", null);
            String description = configReader.getSpaceProperty("workers." + workerArr[i] + '.' + "description", null);
            String instancesStr = configReader.getSpaceProperty("workers." + workerArr[i] + '.' + "instances", "1");
            int instances = Integer.parseInt(instancesStr);
            String activeWhenBackupStr = configReader.getSpaceProperty("workers." + workerArr[i] + '.' + "active-when-backup", "true");
            boolean startIfPrimaryOnly = !Boolean.parseBoolean(activeWhenBackupStr);
            String shutdownSpaceOnInitFailureStr = configReader.getSpaceProperty("workers." + workerArr[i] + '.' + "shutdown-space-on-init-failure", "false");
            boolean shutdownSpaceOnInitFailure = Boolean.parseBoolean(shutdownSpaceOnInitFailureStr);
            for (int j = 0; j < instances; ++j) {
                String workerName = workerArr[i] + (j + 1);
                try {
                    WorkerInfo worker = this.buildWorker(workerName, className, arg, description, startIfPrimaryOnly, shutdownSpaceOnInitFailure);
                    result.put(workerName, worker);
                    continue;
                }
                catch (Exception ex) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "Failed to configure worker: " + workerName, ex);
                    }
                    throw new RuntimeException("WorkerManager: Failed to configure worker [" + workerName + "]", ex);
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("WorkerManager: " + this.workerManagerName + " initialized successfully.");
        }
        return result;
    }

    private WorkerInfo buildWorker(String workerName, String className, String arg, String desc, boolean startIfPrimaryOnly, boolean shutdownSpaceOnInitFailure) throws Exception {
        IWorker workerObj;
        if (this.isClosed) {
            throw new RuntimeException("Failed to start worker: " + workerName + ".WorkerManager already shutdown.");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("WorkerManager: " + this.workerManagerName + " Starting Worker: " + workerName + " Class name: " + className + " arg: " + arg);
        }
        if (className == null) {
            String exMes = "Class name for Worker: " + workerName + " doesn't exist.";
            _logger.severe(exMes);
            throw new IllegalArgumentException(exMes);
        }
        try {
            Class workerClass = ClassLoaderHelper.loadClass(className);
            ReflectionUtil.assertIsPublic(workerClass);
            ReflectionUtil.assertHasDefaultConstructor(workerClass);
            workerObj = (IWorker)workerClass.newInstance();
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Class name: " + className + " must be public and needs public no-arg constructor.", ex);
        }
        Thread workerThread = new Thread(workerObj);
        workerThread.setName(workerName + "-" + this.workerProxy.getName());
        WorkerInfo wInfo = new WorkerInfo(workerObj, workerThread, workerName, className, arg, desc, startIfPrimaryOnly, shutdownSpaceOnInitFailure);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("WorkerManager: " + this.workerManagerName + " Worker: " + workerName + " initialized successfully.");
        }
        return wInfo;
    }

    @Override
    public void initComponents(boolean primaryOnly) throws SpaceComponentsInitializeException {
        if (this.isClosed) {
            return;
        }
        Iterator<WorkerInfo> iterator = this.workerTable.values().iterator();
        while (iterator.hasNext()) {
            WorkerInfo worker = iterator.next();
            if (worker.isStartIfPrimaryOnly() != primaryOnly) continue;
            try {
                worker.getWorker().init(this.workerProxy, worker.getWorkerName(), worker.getArg());
            }
            catch (Exception ex) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to initialize worker: " + worker.getWorkerName(), ex);
                }
                if (worker.isShutdownSpaceOnInitFailure()) {
                    throw new SpaceComponentsInitializeException("Failed to initialize worker - " + worker.getWorkerName(), ex);
                }
                iterator.remove();
                this.close(worker);
            }
        }
    }

    @Override
    public void startComponents(boolean primaryOnly) {
        if (this.isClosed) {
            return;
        }
        for (WorkerInfo workerInfo : this.workerTable.values()) {
            if (workerInfo.isStartIfPrimaryOnly() != primaryOnly) continue;
            workerInfo.getWorkerThread().start();
        }
    }

    @Override
    public boolean isRecoverySupported() {
        return false;
    }

    @Override
    public void close(boolean primaryOnly) {
        for (WorkerInfo worker : this.workerTable.values()) {
            if (primaryOnly != worker.isStartIfPrimaryOnly()) continue;
            this.close(worker);
        }
    }
}

